/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.gis;

import com.bigdata.rdf.internal.gis.AbstractCoordinateTestCase;
import com.bigdata.rdf.internal.gis.CoordinateDD;
import java.text.ParseException;

public class TestCoordinateDD
extends AbstractCoordinateTestCase {
    public TestCoordinateDD() {
    }

    public TestCoordinateDD(String arg0) {
        super(arg0);
    }

    public void test_ctor() {
        CoordinateDD c = new CoordinateDD(32.30642, -122.61458);
        TestCoordinateDD.assertEquals((double)c.northSouth, (double)32.30642);
        TestCoordinateDD.assertEquals((double)c.eastWest, (double)-122.61458);
        TestCoordinateDD.assertEquals((String)"+32.30642,-122.61458", (String)c.toString());
    }

    public void test_ctor_correctRejection() {
        try {
            new CoordinateDD(9000001.0, 0.0);
            TestCoordinateDD.fail((String)("Expecting " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException ex) {
            System.err.println("Ignoring expected exception: " + ex);
        }
        try {
            new CoordinateDD(-9000001.0, 0.0);
            TestCoordinateDD.fail((String)("Expecting " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException ex) {
            System.err.println("Ignoring expected exception: " + ex);
        }
        try {
            new CoordinateDD(0.0, 1.8000001E7);
            TestCoordinateDD.fail((String)("Expecting " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException ex) {
            System.err.println("Ignoring expected exception: " + ex);
        }
        try {
            new CoordinateDD(0.0, -1.8000001E7);
            TestCoordinateDD.fail((String)("Expecting " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException ex) {
            System.err.println("Ignoring expected exception: " + ex);
        }
    }

    public void test_parse() throws ParseException {
        CoordinateDD c = new CoordinateDD(32.30642, -122.61458);
        this.assertEquals(c, CoordinateDD.parse((String)"+32.30642, -122.61458"));
        this.assertEquals(c, CoordinateDD.parse((String)"+32.30642,-122.61458"));
        this.assertEquals(c, CoordinateDD.parse((String)"+32.30642 -122.61458"));
        this.assertEquals(c, CoordinateDD.parse((String)"+32.30642 / -122.61458"));
        this.assertEquals(c, CoordinateDD.parse((String)"+32.30642/-122.61458"));
        this.assertEquals(c, CoordinateDD.parse((String)"+32.30642-122.61458"));
        c = new CoordinateDD(36.0726355, -79.7919754);
        this.assertEquals(c, CoordinateDD.parse((String)"+36.0726355 -79.7919754"));
    }
}

