/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.gis;

import com.bigdata.rdf.internal.gis.AbstractCoordinateTestCase;
import com.bigdata.rdf.internal.gis.CoordinateDD;
import com.bigdata.rdf.internal.gis.CoordinateDDM;
import com.bigdata.rdf.internal.gis.ICoordinate;
import java.text.ParseException;
import java.util.regex.Matcher;

public class TestCoordinateDDM
extends AbstractCoordinateTestCase {
    public TestCoordinateDDM() {
    }

    public TestCoordinateDDM(String arg0) {
        super(arg0);
    }

    public void test_ctor() {
        CoordinateDDM c = new CoordinateDDM(32, 18385, -122, -36875);
        TestCoordinateDDM.assertEquals((int)c.degreesNorth, (int)32);
        TestCoordinateDDM.assertEquals((int)c.thousandthsOfMinutesNorth, (int)18385);
        TestCoordinateDDM.assertEquals((int)c.degreesEast, (int)-122);
        TestCoordinateDDM.assertEquals((int)c.thousandthsOfMinutesEast, (int)-36875);
        TestCoordinateDDM.assertEquals((String)"32 18.385N 122 36.875W", (String)c.toString());
    }

    public void test_ctor_correctRejection() {
    }

    public void test_pattern_ddm_groups() {
        String text = "32\ufffd 18.385' N 122\ufffd 36.875' W";
        Matcher m = CoordinateDDM.pattern_ddm.matcher(text);
        TestCoordinateDDM.assertTrue((boolean)m.matches());
        TestCoordinateDDM.assertEquals((String)"32", (String)m.group(4));
        TestCoordinateDDM.assertEquals((String)"18.385", (String)m.group(5));
        TestCoordinateDDM.assertEquals((String)"N", (String)m.group(6));
        TestCoordinateDDM.assertEquals((String)"122", (String)m.group(9));
        TestCoordinateDDM.assertEquals((String)"36.875", (String)m.group(10));
        TestCoordinateDDM.assertEquals((String)"W", (String)m.group(11));
    }

    public void test_parse() throws ParseException {
        CoordinateDDM c = CoordinateDDM.parse((String)"32\ufffd 18.385' N 122\ufffd 36.875' W");
        TestCoordinateDDM.assertEquals((int)32, (int)c.degreesNorth);
        TestCoordinateDDM.assertEquals((int)18385, (int)c.thousandthsOfMinutesNorth);
        TestCoordinateDDM.assertEquals((int)-122, (int)c.degreesEast);
        TestCoordinateDDM.assertEquals((int)-36875, (int)c.thousandthsOfMinutesEast);
        c = CoordinateDDM.parse((String)"32 18.385 N 122 36.875 W");
        TestCoordinateDDM.assertEquals((int)32, (int)c.degreesNorth);
        TestCoordinateDDM.assertEquals((int)18385, (int)c.thousandthsOfMinutesNorth);
        TestCoordinateDDM.assertEquals((int)-122, (int)c.degreesEast);
        TestCoordinateDDM.assertEquals((int)-36875, (int)c.thousandthsOfMinutesEast);
        c = CoordinateDDM.parse((String)"32 18.385N 122 36.875W");
        TestCoordinateDDM.assertEquals((int)32, (int)c.degreesNorth);
        TestCoordinateDDM.assertEquals((int)18385, (int)c.thousandthsOfMinutesNorth);
        TestCoordinateDDM.assertEquals((int)-122, (int)c.degreesEast);
        TestCoordinateDDM.assertEquals((int)-36875, (int)c.thousandthsOfMinutesEast);
        c = CoordinateDDM.parse((String)"32:18.385N 122:36.875W");
        TestCoordinateDDM.assertEquals((int)32, (int)c.degreesNorth);
        TestCoordinateDDM.assertEquals((int)18385, (int)c.thousandthsOfMinutesNorth);
        TestCoordinateDDM.assertEquals((int)-122, (int)c.degreesEast);
        TestCoordinateDDM.assertEquals((int)-36875, (int)c.thousandthsOfMinutesEast);
    }

    public void test_toDD() throws ParseException {
        CoordinateDDM ddm = CoordinateDDM.parse((String)"32\ufffd 18.385' N 122\ufffd 36.875' W");
        CoordinateDD dd = CoordinateDD.parse((String)"+32.30642\ufffd -122.61458\ufffd");
        TestCoordinateDDM.assertEquals((int)0, (int)((int)dd.distance((ICoordinate)ddm.toDD(), ICoordinate.UNITS.Meters)));
    }
}

