/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.gis;

import com.bigdata.rdf.internal.gis.AbstractCoordinateTestCase;
import com.bigdata.rdf.internal.gis.CoordinateDD;
import com.bigdata.rdf.internal.gis.CoordinateDMS;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TestCoordinateDMS
extends AbstractCoordinateTestCase {
    public TestCoordinateDMS() {
    }

    public TestCoordinateDMS(String arg0) {
        super(arg0);
    }

    public void test_parseTenthsOfSecond() throws ParseException {
        TestCoordinateDMS.assertEquals((int)525, (int)CoordinateDMS.parseTenthsOfSecond((String)"52.5"));
        TestCoordinateDMS.assertEquals((int)520, (int)CoordinateDMS.parseTenthsOfSecond((String)"52.0"));
        TestCoordinateDMS.assertEquals((int)520, (int)CoordinateDMS.parseTenthsOfSecond((String)"52."));
        TestCoordinateDMS.assertEquals((int)520, (int)CoordinateDMS.parseTenthsOfSecond((String)"52"));
    }

    public void test_formatTenthsOfSecond() {
        TestCoordinateDMS.assertEquals((String)"52.0", (String)CoordinateDMS.formatTenthsOfSecond((int)520));
        TestCoordinateDMS.assertEquals((String)"52.5", (String)CoordinateDMS.formatTenthsOfSecond((int)525));
    }

    public void test_ctor() throws ParseException {
        CoordinateDMS c = new CoordinateDMS(32, 18, 231, -122, -36, -525);
        TestCoordinateDMS.assertEquals((int)c.degreesNorth, (int)32);
        TestCoordinateDMS.assertEquals((int)c.minutesNorth, (int)18);
        TestCoordinateDMS.assertEquals((int)c.tenthsOfSecondsNorth, (int)231);
        TestCoordinateDMS.assertEquals((int)c.degreesEast, (int)-122);
        TestCoordinateDMS.assertEquals((int)c.minutesEast, (int)-36);
        TestCoordinateDMS.assertEquals((int)c.tenthsOfSecondsEast, (int)-525);
        TestCoordinateDMS.assertEquals((String)"32 18 23.1N 122 36 52.5W", (String)c.toString());
    }

    public void test_roundSeconds() {
        CoordinateDMS c = new CoordinateDMS(32, 18, 231, -122, -36, -525);
        CoordinateDMS c1 = new CoordinateDMS(32, 18, 230, -122, -36, -530);
        this.assertEquals(c1, c.roundSeconds());
    }

    public void test_roundMinutes() {
        CoordinateDMS c = new CoordinateDMS(32, 18, 231, -122, -36, -525);
        CoordinateDMS expected = new CoordinateDMS(32, 18, 0, -122, -37, 0);
        CoordinateDMS actual = c.roundMinutes();
        this.assertEquals(expected, actual);
    }

    public void test_regex_lat() {
        Pattern p = Pattern.compile("((\\d{1,2})\\s?[:\ufffd*\\s]?\\s?(\\d{1,2})\\s?[:'\\s]?\\s?((\\d{1,2}|\\d{1,2}\\.\\d?)\\s?\"?)?\\s?([NnSs]))");
        String text = "32\ufffd 18' 23.1\" N";
        Matcher m = p.matcher(text);
        TestCoordinateDMS.assertTrue((boolean)m.matches());
        TestCoordinateDMS.assertEquals((String)"32", (String)m.group(2));
        TestCoordinateDMS.assertEquals((String)"18", (String)m.group(3));
        TestCoordinateDMS.assertEquals((String)"23.1", (String)m.group(5));
        TestCoordinateDMS.assertEquals((String)"N", (String)m.group(6));
        text = "32\ufffd 18' 23.1\"N";
        m = p.matcher(text);
        TestCoordinateDMS.assertTrue((boolean)m.matches());
        TestCoordinateDMS.assertEquals((String)"32", (String)m.group(2));
        TestCoordinateDMS.assertEquals((String)"18", (String)m.group(3));
        TestCoordinateDMS.assertEquals((String)"23.1", (String)m.group(5));
        TestCoordinateDMS.assertEquals((String)"N", (String)m.group(6));
        text = "32 18 23.1 N";
        m = p.matcher(text);
        TestCoordinateDMS.assertTrue((boolean)m.matches());
        TestCoordinateDMS.assertEquals((String)"32", (String)m.group(2));
        TestCoordinateDMS.assertEquals((String)"18", (String)m.group(3));
        TestCoordinateDMS.assertEquals((String)"23.1", (String)m.group(5));
        TestCoordinateDMS.assertEquals((String)"N", (String)m.group(6));
        text = "32 18 23.1N";
        m = p.matcher(text);
        TestCoordinateDMS.assertTrue((boolean)m.matches());
        TestCoordinateDMS.assertEquals((String)"32", (String)m.group(2));
        TestCoordinateDMS.assertEquals((String)"18", (String)m.group(3));
        TestCoordinateDMS.assertEquals((String)"23.1", (String)m.group(5));
        TestCoordinateDMS.assertEquals((String)"N", (String)m.group(6));
        text = "32 18 23 N";
        m = p.matcher(text);
        TestCoordinateDMS.assertTrue((boolean)m.matches());
        TestCoordinateDMS.assertEquals((String)"32", (String)m.group(2));
        TestCoordinateDMS.assertEquals((String)"18", (String)m.group(3));
        TestCoordinateDMS.assertEquals((String)"23", (String)m.group(5));
        TestCoordinateDMS.assertEquals((String)"N", (String)m.group(6));
        text = "32 18 23N";
        m = p.matcher(text);
        TestCoordinateDMS.assertTrue((boolean)m.matches());
        TestCoordinateDMS.assertEquals((String)"32", (String)m.group(2));
        TestCoordinateDMS.assertEquals((String)"18", (String)m.group(3));
        TestCoordinateDMS.assertEquals((String)"23", (String)m.group(5));
        TestCoordinateDMS.assertEquals((String)"N", (String)m.group(6));
        text = "32 18 N";
        m = p.matcher(text);
        TestCoordinateDMS.assertTrue((boolean)m.matches());
        TestCoordinateDMS.assertEquals((String)"32", (String)m.group(2));
        TestCoordinateDMS.assertEquals((String)"18", (String)m.group(3));
        TestCoordinateDMS.assertEquals(null, (String)m.group(5));
        TestCoordinateDMS.assertEquals((String)"N", (String)m.group(6));
        text = "32 18N";
        m = p.matcher(text);
        TestCoordinateDMS.assertTrue((boolean)m.matches());
        TestCoordinateDMS.assertEquals((String)"32", (String)m.group(2));
        TestCoordinateDMS.assertEquals((String)"18", (String)m.group(3));
        TestCoordinateDMS.assertEquals(null, (String)m.group(5));
        TestCoordinateDMS.assertEquals((String)"N", (String)m.group(6));
        text = "32:18:23.1 N";
        m = p.matcher(text);
        TestCoordinateDMS.assertTrue((boolean)m.matches());
        TestCoordinateDMS.assertEquals((String)"32", (String)m.group(2));
        TestCoordinateDMS.assertEquals((String)"18", (String)m.group(3));
        TestCoordinateDMS.assertEquals((String)"23.1", (String)m.group(5));
        TestCoordinateDMS.assertEquals((String)"N", (String)m.group(6));
        text = "32:18:23.1N";
        m = p.matcher(text);
        TestCoordinateDMS.assertTrue((boolean)m.matches());
        TestCoordinateDMS.assertEquals((String)"32", (String)m.group(2));
        TestCoordinateDMS.assertEquals((String)"18", (String)m.group(3));
        TestCoordinateDMS.assertEquals((String)"23.1", (String)m.group(5));
        TestCoordinateDMS.assertEquals((String)"N", (String)m.group(6));
        text = "32:18:23 N";
        m = p.matcher(text);
        TestCoordinateDMS.assertTrue((boolean)m.matches());
        TestCoordinateDMS.assertEquals((String)"32", (String)m.group(2));
        TestCoordinateDMS.assertEquals((String)"18", (String)m.group(3));
        TestCoordinateDMS.assertEquals((String)"23", (String)m.group(5));
        TestCoordinateDMS.assertEquals((String)"N", (String)m.group(6));
        text = "32:18:23N";
        m = p.matcher(text);
        TestCoordinateDMS.assertTrue((boolean)m.matches());
        TestCoordinateDMS.assertEquals((String)"32", (String)m.group(2));
        TestCoordinateDMS.assertEquals((String)"18", (String)m.group(3));
        TestCoordinateDMS.assertEquals((String)"23", (String)m.group(5));
        TestCoordinateDMS.assertEquals((String)"N", (String)m.group(6));
    }

    public void test_regex_long() {
        Pattern p = Pattern.compile("((\\d{1,3})\\s?[:\ufffd*\\s]?\\s?(\\d{1,2})\\s?[:'\\s]?\\s?((\\d{1,2}|\\d{1,2}\\.\\d?)\\s?\"?)?\\s?([EeWw]))");
        String text = "122\ufffd 36' 52.5\" W";
        Matcher m = p.matcher(text);
        TestCoordinateDMS.assertTrue((boolean)m.matches());
        TestCoordinateDMS.assertEquals((String)"122", (String)m.group(2));
        TestCoordinateDMS.assertEquals((String)"36", (String)m.group(3));
        TestCoordinateDMS.assertEquals((String)"52.5", (String)m.group(5));
        TestCoordinateDMS.assertEquals((String)"W", (String)m.group(6));
        text = "122\ufffd 36' 52.5\"W";
        m = p.matcher(text);
        TestCoordinateDMS.assertTrue((boolean)m.matches());
        TestCoordinateDMS.assertEquals((String)"122", (String)m.group(2));
        TestCoordinateDMS.assertEquals((String)"36", (String)m.group(3));
        TestCoordinateDMS.assertEquals((String)"52.5", (String)m.group(5));
        TestCoordinateDMS.assertEquals((String)"W", (String)m.group(6));
        text = "122 36 52.5 W";
        m = p.matcher(text);
        TestCoordinateDMS.assertTrue((boolean)m.matches());
        TestCoordinateDMS.assertEquals((String)"122", (String)m.group(2));
        TestCoordinateDMS.assertEquals((String)"36", (String)m.group(3));
        TestCoordinateDMS.assertEquals((String)"52.5", (String)m.group(5));
        TestCoordinateDMS.assertEquals((String)"W", (String)m.group(6));
        text = "122 36 52.5W";
        m = p.matcher(text);
        TestCoordinateDMS.assertTrue((boolean)m.matches());
        TestCoordinateDMS.assertEquals((String)"122", (String)m.group(2));
        TestCoordinateDMS.assertEquals((String)"36", (String)m.group(3));
        TestCoordinateDMS.assertEquals((String)"52.5", (String)m.group(5));
        TestCoordinateDMS.assertEquals((String)"W", (String)m.group(6));
        text = "122 36 52 W";
        m = p.matcher(text);
        TestCoordinateDMS.assertTrue((boolean)m.matches());
        TestCoordinateDMS.assertEquals((String)"122", (String)m.group(2));
        TestCoordinateDMS.assertEquals((String)"36", (String)m.group(3));
        TestCoordinateDMS.assertEquals((String)"52", (String)m.group(5));
        TestCoordinateDMS.assertEquals((String)"W", (String)m.group(6));
        text = "122 36 52W";
        m = p.matcher(text);
        TestCoordinateDMS.assertTrue((boolean)m.matches());
        TestCoordinateDMS.assertEquals((String)"122", (String)m.group(2));
        TestCoordinateDMS.assertEquals((String)"36", (String)m.group(3));
        TestCoordinateDMS.assertEquals((String)"52", (String)m.group(5));
        TestCoordinateDMS.assertEquals((String)"W", (String)m.group(6));
        text = "122 36 W";
        m = p.matcher(text);
        TestCoordinateDMS.assertTrue((boolean)m.matches());
        TestCoordinateDMS.assertEquals((String)"122", (String)m.group(2));
        TestCoordinateDMS.assertEquals((String)"36", (String)m.group(3));
        TestCoordinateDMS.assertEquals(null, (String)m.group(5));
        TestCoordinateDMS.assertEquals((String)"W", (String)m.group(6));
        text = "122 36W";
        m = p.matcher(text);
        TestCoordinateDMS.assertTrue((boolean)m.matches());
        TestCoordinateDMS.assertEquals((String)"122", (String)m.group(2));
        TestCoordinateDMS.assertEquals((String)"36", (String)m.group(3));
        TestCoordinateDMS.assertEquals(null, (String)m.group(5));
        TestCoordinateDMS.assertEquals((String)"W", (String)m.group(6));
        text = "122:36:52.5 W";
        m = p.matcher(text);
        TestCoordinateDMS.assertTrue((boolean)m.matches());
        TestCoordinateDMS.assertEquals((String)"122", (String)m.group(2));
        TestCoordinateDMS.assertEquals((String)"36", (String)m.group(3));
        TestCoordinateDMS.assertEquals((String)"52.5", (String)m.group(5));
        TestCoordinateDMS.assertEquals((String)"W", (String)m.group(6));
        text = "122:36:52.5W";
        m = p.matcher(text);
        TestCoordinateDMS.assertTrue((boolean)m.matches());
        TestCoordinateDMS.assertEquals((String)"122", (String)m.group(2));
        TestCoordinateDMS.assertEquals((String)"36", (String)m.group(3));
        TestCoordinateDMS.assertEquals((String)"52.5", (String)m.group(5));
        TestCoordinateDMS.assertEquals((String)"W", (String)m.group(6));
        text = "122:36:52 W";
        m = p.matcher(text);
        TestCoordinateDMS.assertTrue((boolean)m.matches());
        TestCoordinateDMS.assertEquals((String)"122", (String)m.group(2));
        TestCoordinateDMS.assertEquals((String)"36", (String)m.group(3));
        TestCoordinateDMS.assertEquals((String)"52", (String)m.group(5));
        TestCoordinateDMS.assertEquals((String)"W", (String)m.group(6));
        text = "122:36:52W";
        m = p.matcher(text);
        TestCoordinateDMS.assertTrue((boolean)m.matches());
        TestCoordinateDMS.assertEquals((String)"122", (String)m.group(2));
        TestCoordinateDMS.assertEquals((String)"36", (String)m.group(3));
        TestCoordinateDMS.assertEquals((String)"52", (String)m.group(5));
        TestCoordinateDMS.assertEquals((String)"W", (String)m.group(6));
    }

    public void test_pattern_dms1_groups() {
        String text = "32 18 23.1 N 122 36 52.5 W";
        Matcher m = CoordinateDMS.pattern_dms1.matcher(text);
        TestCoordinateDMS.assertTrue((boolean)m.matches());
        TestCoordinateDMS.assertEquals((String)"32", (String)m.group(4));
        TestCoordinateDMS.assertEquals((String)"18", (String)m.group(5));
        TestCoordinateDMS.assertEquals((String)"23.1", (String)m.group(7));
        TestCoordinateDMS.assertEquals((String)"N", (String)m.group(8));
        TestCoordinateDMS.assertEquals((String)"122", (String)m.group(11));
        TestCoordinateDMS.assertEquals((String)"36", (String)m.group(12));
        TestCoordinateDMS.assertEquals((String)"52.5", (String)m.group(14));
        TestCoordinateDMS.assertEquals((String)"W", (String)m.group(15));
    }

    public void test_parse01() throws ParseException {
        CoordinateDMS c = new CoordinateDMS(32, 18, 231, -122, -36, -525);
        this.assertEquals(c, CoordinateDMS.parse((String)"32\ufffd 18' 23.1\" N 122\ufffd 36' 52.5\" W"));
        this.assertEquals(c, CoordinateDMS.parse((String)"32* 18' 23.1\" N 122* 36' 52.5\" W"));
        this.assertEquals(c, CoordinateDMS.parse((String)"32 * 18 ' 23.1 \" N 122 * 36 ' 52.5 \" W"));
        this.assertEquals(c, CoordinateDMS.parse((String)"32 18 23.1N 122 36 52.5W"));
        this.assertEquals(c, CoordinateDMS.parse((String)"32 18 23.1 N 122 36 52.5 W"));
        this.assertEquals(c, CoordinateDMS.parse((String)"32 18 23.1N/122 36 52.5W"));
        this.assertEquals(c, CoordinateDMS.parse((String)"32 18 23.1N / 122 36 52.5W"));
        this.assertEquals(c, CoordinateDMS.parse((String)"32 18 23.1 N / 122 36 52.5 W"));
        this.assertEquals(c.roundSeconds(), CoordinateDMS.parse((String)"32 18 23 N / 122 36 53 W"));
        this.assertEquals(c.roundSeconds(), CoordinateDMS.parse((String)"32 18 23N / 122 36 53W"));
        this.assertEquals(c.roundSeconds(), CoordinateDMS.parse((String)"32 18 23N, 122 36 53W"));
        this.assertEquals(c.roundMinutes(), CoordinateDMS.parse((String)"32 18N / 122 37W"));
        this.assertEquals(c.roundMinutes(), CoordinateDMS.parse((String)"32 18N, 122 37W"));
        this.assertEquals(c.roundMinutes(), CoordinateDMS.parse((String)"32 18N 122 37W"));
        this.assertEquals(c, CoordinateDMS.parse((String)"32:18:23.1N/122:36:52.5W"));
        this.assertEquals(c, CoordinateDMS.parse((String)"32:18:23.1N / 122:36:52.5W"));
        this.assertEquals(c, CoordinateDMS.parse((String)"32:18:23.1N 122:36:52.5W"));
        this.assertEquals(c.roundSeconds(), CoordinateDMS.parse((String)"32:18:23N/122:36:53W"));
        this.assertEquals(c.roundSeconds(), CoordinateDMS.parse((String)"32:18:23N / 122:36:53W"));
        this.assertEquals(c.roundSeconds(), CoordinateDMS.parse((String)"32:18:23N 122:36:53W"));
        this.assertEquals(c.roundSeconds(), CoordinateDMS.parse((String)"321823N/1223653W"));
        this.assertEquals(c.roundSeconds(), CoordinateDMS.parse((String)"321823N / 1223653W"));
        this.assertEquals(c.roundSeconds(), CoordinateDMS.parse((String)"321823N 1223653W"));
        this.assertEquals(c.roundMinutes(), CoordinateDMS.parse((String)"3218N/12237W"));
        this.assertEquals(c.roundMinutes(), CoordinateDMS.parse((String)"3218N / 12237W"));
        this.assertEquals(c.roundMinutes(), CoordinateDMS.parse((String)"3218N 12237W"));
    }

    public void test_toDD() throws ParseException {
        CoordinateDMS dms = CoordinateDMS.parse((String)"360421N 0794731W");
        TestCoordinateDMS.assertEquals((int)36, (int)dms.degreesNorth);
        TestCoordinateDMS.assertEquals((int)4, (int)dms.minutesNorth);
        TestCoordinateDMS.assertEquals((int)210, (int)dms.tenthsOfSecondsNorth);
        TestCoordinateDMS.assertEquals((int)-79, (int)dms.degreesEast);
        TestCoordinateDMS.assertEquals((int)-47, (int)dms.minutesEast);
        TestCoordinateDMS.assertEquals((int)-310, (int)dms.tenthsOfSecondsEast);
        CoordinateDD dd = dms.toDD();
        System.err.println("dms(" + dms + ") => dd(" + dd + ")");
        TestCoordinateDMS.assertEquals((double)36.0725, (double)this.round5(dd.northSouth));
        TestCoordinateDMS.assertEquals((double)-79.79194, (double)this.round5(dd.eastWest));
    }
}

