/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.gis;

import com.bigdata.rdf.internal.gis.AbstractCoordinateTestCase;
import com.bigdata.rdf.internal.gis.CoordinateDD;
import com.bigdata.rdf.internal.gis.CoordinateUtility;
import com.bigdata.rdf.internal.gis.ICoordinate;
import java.text.NumberFormat;
import java.text.ParseException;

public class TestCoordinateUtility
extends AbstractCoordinateTestCase {
    public TestCoordinateUtility() {
    }

    public TestCoordinateUtility(String arg0) {
        super(arg0);
    }

    public void test_toRadians() {
        TestCoordinateUtility.assertEquals((double)(Math.PI / 180), (double)CoordinateUtility.toRadians((double)1.0));
    }

    public void test_toDegrees() {
        TestCoordinateUtility.assertEquals((double)57.29577951308232, (double)CoordinateUtility.toDegrees((double)1.0));
    }

    public void test_metersLatitude() {
        TestCoordinateUtility.assertEquals((double)30.82, (double)CoordinateUtility.metersPerSecondOfLatitudeAtSeaLevel);
        TestCoordinateUtility.assertEquals((double)1849.2, (double)CoordinateUtility.metersPerMinuteOfLatitudeAtSeaLevel);
        TestCoordinateUtility.assertEquals((double)110952.0, (double)CoordinateUtility.metersPerDegreeOfLatitudeAtSeaLevel);
    }

    public void test_approxMetersLongitude() throws ParseException {
        boolean dad = false;
        TestCoordinateUtility.assertEquals((double)this.round(30.92, 0), (double)this.round(CoordinateUtility.approxMetersPerDegreeOfLongitudeAtSeaLevel((double)0.0) / 3600.0, 0));
        TestCoordinateUtility.assertEquals((double)this.round(26.76, 0), (double)this.round(CoordinateUtility.approxMetersPerDegreeOfLongitudeAtSeaLevel((double)30.0) / 3600.0, 0));
        TestCoordinateUtility.assertEquals((double)this.round(26.76, 0), (double)this.round(CoordinateUtility.approxMetersPerDegreeOfLongitudeAtSeaLevel((double)-30.0) / 3600.0, 0));
        TestCoordinateUtility.assertEquals((double)this.round(15.42, 0), (double)this.round(CoordinateUtility.approxMetersPerDegreeOfLongitudeAtSeaLevel((double)60.0) / 3600.0, 0));
        TestCoordinateUtility.assertEquals((double)this.round(15.42, 0), (double)this.round(CoordinateUtility.approxMetersPerDegreeOfLongitudeAtSeaLevel((double)-60.0) / 3600.0, 0));
        double degrees = CoordinateUtility.toDecimalDegrees((int)51, (int)28, (double)38.0);
        System.err.println("Greenwich latitude in decimal degrees: " + degrees);
        TestCoordinateUtility.assertEquals((double)this.round(19.22, 0), (double)this.round(CoordinateUtility.approxMetersPerDegreeOfLongitudeAtSeaLevel((double)degrees) / 3600.0, 0));
        TestCoordinateUtility.assertEquals((double)this.round(19.22, 0), (double)this.round(CoordinateUtility.approxMetersPerDegreeOfLongitudeAtSeaLevel((double)(-degrees)) / 3600.0, 0));
    }

    public void test_realMetersLongitude() throws ParseException {
        int dad = 2;
        TestCoordinateUtility.assertEquals((double)30.92, (double)this.round(CoordinateUtility.realMetersPerDegreeOfLongitudeAtSeaLevel((double)0.0) / 3600.0, 2));
        TestCoordinateUtility.assertEquals((double)26.76, (double)this.round(CoordinateUtility.realMetersPerDegreeOfLongitudeAtSeaLevel((double)30.0) / 3600.0, 2));
        TestCoordinateUtility.assertEquals((double)26.76, (double)this.round(CoordinateUtility.realMetersPerDegreeOfLongitudeAtSeaLevel((double)-30.0) / 3600.0, 2));
        TestCoordinateUtility.assertEquals((double)15.42, (double)this.round(CoordinateUtility.realMetersPerDegreeOfLongitudeAtSeaLevel((double)60.0) / 3600.0, 2));
        TestCoordinateUtility.assertEquals((double)15.42, (double)this.round(CoordinateUtility.realMetersPerDegreeOfLongitudeAtSeaLevel((double)-60.0) / 3600.0, 2));
        double degrees = CoordinateUtility.toDecimalDegrees((int)51, (int)28, (double)38.0);
        System.err.println("Greenwich latitude in decimal degrees: " + degrees);
        TestCoordinateUtility.assertEquals((double)19.22, (double)this.round(CoordinateUtility.realMetersPerDegreeOfLongitudeAtSeaLevel((double)degrees) / 3600.0, 2));
        TestCoordinateUtility.assertEquals((double)19.22, (double)this.round(CoordinateUtility.realMetersPerDegreeOfLongitudeAtSeaLevel((double)(-degrees)) / 3600.0, 2));
    }

    public void test_distance_noDistance01() throws ParseException {
        CoordinateDD c = new CoordinateDD(0.0, 0.0);
        TestCoordinateUtility.assertEquals((double)0.0, (double)c.northSouth);
        TestCoordinateUtility.assertEquals((double)0.0, (double)c.eastWest);
        TestCoordinateUtility.assertEquals((double)0.0, (double)CoordinateUtility.distance((CoordinateDD)c, (CoordinateDD)c, (ICoordinate.UNITS)ICoordinate.UNITS.Meters));
    }

    public void test_distance_noDistance02() throws ParseException {
        CoordinateDD c = CoordinateDD.parse((String)"+36.0726355 -79.7919754");
        TestCoordinateUtility.assertEquals((double)0.0, (double)CoordinateUtility.distance((CoordinateDD)c, (CoordinateDD)c, (ICoordinate.UNITS)ICoordinate.UNITS.Meters));
    }

    public void test_distance_washingtonDC_greensboroNC() throws ParseException {
        CoordinateDD p1 = CoordinateDD.parse((String)"36.0726355 -79.7919754");
        CoordinateDD p2 = CoordinateDD.parse((String)"38.8951118 -77.0363658");
        double d = CoordinateUtility.distance((CoordinateDD)p1, (CoordinateDD)p2, (ICoordinate.UNITS)ICoordinate.UNITS.Miles);
        NumberFormat fmt = NumberFormat.getNumberInstance();
        fmt.setMinimumFractionDigits(3);
        System.err.println("The distance between Washington, DC and Greensboro, NC is " + fmt.format(d) + " miles");
    }
}

