/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.impl.uri;

import com.bigdata.rdf.internal.impl.literal.IPv4AddrIV;
import java.net.UnknownHostException;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.junit.Test;

public class IPv4AddrIVTest
extends TestCase {
    private static final transient Logger log = Logger.getLogger(IPv4AddrIVTest.class);

    @Test
    public void testIPAddress() {
        String testCase = "192.168.1.100";
        IPv4AddrIV addr = null;
        try {
            addr = new IPv4AddrIV(testCase);
        }
        catch (UnknownHostException uh) {
            log.info((Object)uh);
            IPv4AddrIVTest.fail();
        }
    }

    @Test
    public void testIPAddress1() {
        String testCase = "66.249.211.254";
        IPv4AddrIV addr = null;
        try {
            addr = new IPv4AddrIV(testCase);
        }
        catch (UnknownHostException uh) {
            log.info((Object)uh);
            IPv4AddrIVTest.fail();
        }
    }

    @Test
    public void testIPAddress2() {
        String testCase = "66.249.71.255";
        IPv4AddrIV addr = null;
        try {
            addr = new IPv4AddrIV(testCase);
        }
        catch (UnknownHostException uh) {
            log.info((Object)uh);
            IPv4AddrIVTest.fail();
        }
    }

    @Test
    public void testIPAddress3() {
        String testCase = "66.249.71.253/32";
        IPv4AddrIV addr = null;
        try {
            addr = new IPv4AddrIV(testCase);
        }
        catch (UnknownHostException uh) {
            log.info((Object)uh);
            IPv4AddrIVTest.fail();
        }
    }

    @Test
    public void testIPAddressCIDR() {
        String testCase = "192.168.1.100/32";
        boolean test = true;
        IPv4AddrIV addr = null;
        try {
            addr = new IPv4AddrIV(testCase);
        }
        catch (UnknownHostException uh) {
            log.info((Object)uh);
            test = false;
        }
        IPv4AddrIVTest.assertEquals((boolean)true, (boolean)test);
    }

    @Test
    public void testIPAddressCIDR2() {
        String testCase = "192.168.1.100/24";
        boolean test = true;
        IPv4AddrIV addr = null;
        try {
            addr = new IPv4AddrIV(testCase);
        }
        catch (UnknownHostException uh) {
            log.info((Object)uh);
            test = false;
        }
        IPv4AddrIVTest.assertEquals((boolean)true, (boolean)test);
    }

    @Test
    public void testIPAddressBadCIDR() {
        String testCase = "192.168.1.100/323";
        boolean test = false;
        IPv4AddrIV addr = null;
        try {
            addr = new IPv4AddrIV(testCase);
        }
        catch (UnknownHostException uh) {
            log.info((Object)uh);
            test = true;
        }
        IPv4AddrIVTest.assertEquals((boolean)test, (boolean)true);
    }

    @Test
    public void testIPAddressBad() {
        String testCase = "192.168.1.300";
        boolean test = false;
        IPv4AddrIV addr = null;
        try {
            addr = new IPv4AddrIV(testCase);
        }
        catch (UnknownHostException uh) {
            log.info((Object)uh);
            test = true;
        }
        IPv4AddrIVTest.assertEquals((boolean)test, (boolean)true);
    }

    @Test
    public void testIPAddressBad2() {
        String testCase = "192.168.1";
        boolean test = false;
        IPv4AddrIV addr = null;
        try {
            addr = new IPv4AddrIV(testCase);
        }
        catch (UnknownHostException uh) {
            log.info((Object)uh);
            test = true;
        }
        IPv4AddrIVTest.assertEquals((boolean)test, (boolean)true);
    }

    @Test
    public void testDeviceAddress() {
        String testCase = "dev:1434498383:110:1427217760000";
        boolean test = false;
        IPv4AddrIV addr = null;
        try {
            addr = new IPv4AddrIV(testCase);
        }
        catch (UnknownHostException uh) {
            log.info((Object)uh);
            test = true;
        }
        IPv4AddrIVTest.assertEquals((boolean)test, (boolean)true);
    }
}

