/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.lexicon;

import com.bigdata.bop.Constant;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.Var;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.lexicon.LexPredicate;
import com.bigdata.rdf.lexicon.LexiconKeyOrder;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.lexicon.TestAddTerms;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.AbstractTripleStoreTestCase;
import com.bigdata.rdf.vocab.NoVocabulary;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.striterator.IKeyOrder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.RDF;

public class TestAccessPaths
extends AbstractTripleStoreTestCase {
    public TestAccessPaths() {
    }

    public TestAccessPaths(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_TERMS_accessPaths() {
        Properties properties = this.getProperties();
        properties.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        properties.setProperty(AbstractTripleStore.Options.TEXT_INDEX, "false");
        AbstractTripleStore store = this.getStore(properties);
        try {
            HashSet<Object> terms = new HashSet<Object>();
            BigdataValueFactory f = store.getValueFactory();
            BigdataURI rdfType = f.asValue(RDF.TYPE);
            terms.add(rdfType);
            terms.add(f.asValue(RDF.PROPERTY));
            terms.add(f.createLiteral("test"));
            terms.add(f.createLiteral("test", "en"));
            terms.add(f.createLiteral("10", (URI)f.createURI("http://www.w3.org/2001/XMLSchema#int")));
            terms.add(f.createLiteral("12", (URI)f.createURI("http://www.w3.org/2001/XMLSchema#float")));
            terms.add(f.createLiteral("12.", (URI)f.createURI("http://www.w3.org/2001/XMLSchema#float")));
            terms.add(f.createLiteral("12.0", (URI)f.createURI("http://www.w3.org/2001/XMLSchema#float")));
            terms.add(f.createLiteral("12.00", (URI)f.createURI("http://www.w3.org/2001/XMLSchema#float")));
            BigdataLiteral largeLiteral = f.createLiteral(TestAddTerms.getVeryLargeLiteral());
            terms.add(largeLiteral);
            if (store.getLexiconRelation().isStoreBlankNodes()) {
                terms.add(f.createBNode());
                terms.add(f.createBNode("a"));
            }
            int size = terms.size();
            BigdataValue[] a = terms.toArray(new BigdataValue[size]);
            store.getLexiconRelation().addTerms(a, size, false);
            ArrayList<IV> ids = new ArrayList<IV>();
            for (BigdataValue t : a) {
                ids.add(t.getIV());
            }
            this.doAccessPathTest((BigdataValue)rdfType, (IKeyOrder<BigdataValue>)LexiconKeyOrder.ID2TERM, store);
            this.doAccessPathTest((BigdataValue)largeLiteral, (IKeyOrder<BigdataValue>)LexiconKeyOrder.BLOBS, store);
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    private void doAccessPathTest(BigdataValue expected, IKeyOrder<BigdataValue> expectedKeyOrder, AbstractTripleStore store) {
        TestAccessPaths.assertNotNull((Object)expected.getIV());
        LexiconRelation r = store.getLexiconRelation();
        Var termvar = Var.var((String)"termvar");
        LexPredicate predicate = LexPredicate.reverseInstance((String)r.getNamespace(), (long)0L, (IVariable)termvar, (IVariableOrConstant)new Constant((Object)expected.getIV()));
        IKeyOrder keyOrder = r.getKeyOrder((IPredicate)predicate);
        TestAccessPaths.assertEquals(expectedKeyOrder, (Object)keyOrder);
        IAccessPath ap = r.newAccessPath(store.getIndexManager(), (IPredicate)predicate, keyOrder);
        TestAccessPaths.assertEquals((long)1L, (long)ap.rangeCount(false));
        TestAccessPaths.assertEquals((long)1L, (long)ap.rangeCount(true));
        IChunkedOrderedIterator itr = ap.iterator();
        TestAccessPaths.assertTrue((boolean)itr.hasNext());
        BigdataValue actual = (BigdataValue)itr.next();
        TestAccessPaths.assertFalse((boolean)itr.hasNext());
        TestAccessPaths.assertEquals((Object)expected, (Object)actual);
        TestAccessPaths.assertEquals((Object)expected.getIV(), (Object)actual.getIV());
    }
}

