/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.lexicon;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.BigdataBNode;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.AbstractTripleStoreTestCase;
import com.bigdata.rdf.vocab.NoVocabulary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.RDF;

public class TestAddTerms
extends AbstractTripleStoreTestCase {
    public TestAddTerms() {
    }

    public TestAddTerms(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_addTerms() {
        Properties properties = this.getProperties();
        properties.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        properties.setProperty(AbstractTripleStore.Options.TEXT_INDEX, "false");
        properties.setProperty(AbstractTripleStore.Options.INLINE_XSD_DATATYPE_LITERALS, "false");
        AbstractTripleStore store = this.getStore(properties);
        try {
            HashSet<BigdataValue> terms = new HashSet<BigdataValue>();
            BigdataValueFactory f = store.getValueFactory();
            terms.add((BigdataValue)f.asValue(RDF.TYPE));
            terms.add((BigdataValue)f.asValue(RDF.PROPERTY));
            terms.add((BigdataValue)f.createURI(TestAddTerms.getVeryLargeURI()));
            terms.add((BigdataValue)f.createLiteral("test"));
            terms.add((BigdataValue)f.createLiteral("test", "en"));
            terms.add((BigdataValue)f.createLiteral(TestAddTerms.getVeryLargeLiteral()));
            terms.add((BigdataValue)f.createLiteral("10", (URI)f.createURI("http://www.w3.org/2001/XMLSchema#int")));
            terms.add((BigdataValue)f.createLiteral("12", (URI)f.createURI("http://www.w3.org/2001/XMLSchema#float")));
            terms.add((BigdataValue)f.createLiteral("12.", (URI)f.createURI("http://www.w3.org/2001/XMLSchema#float")));
            terms.add((BigdataValue)f.createLiteral("12.0", (URI)f.createURI("http://www.w3.org/2001/XMLSchema#float")));
            terms.add((BigdataValue)f.createLiteral("12.00", (URI)f.createURI("http://www.w3.org/2001/XMLSchema#float")));
            if (store.getLexiconRelation().isStoreBlankNodes()) {
                terms.add((BigdataValue)f.createBNode());
                terms.add((BigdataValue)f.createBNode("a"));
                terms.add((BigdataValue)f.createBNode(TestAddTerms.getVeryLargeLiteral()));
            }
            Map<IV<?, ?>, BigdataValue> ids = this.doAddTermsTest(store, terms);
            if (store.isStable()) {
                store.commit();
                store = this.reopenStore(store);
                Map ids2 = store.getLexiconRelation().getTerms(ids.keySet());
                TestAddTerms.assertEquals((int)ids.size(), (int)ids2.size());
                for (Map.Entry e : ids2.entrySet()) {
                    IV id = (IV)e.getKey();
                    TestAddTerms.assertEquals((String)("Id mapped to a different term? : termId=" + id), (Object)ids.get(id), ids2.get(id));
                }
            }
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_toldBNodes() {
        Properties properties = this.getProperties();
        properties.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        properties.setProperty(AbstractTripleStore.Options.TEXT_INDEX, "false");
        properties.setProperty(AbstractTripleStore.Options.STORE_BLANK_NODES, "true");
        AbstractTripleStore store = this.getStore(properties);
        try {
            if (!store.isStable()) {
                return;
            }
            HashSet<BigdataValue> terms = new HashSet<BigdataValue>();
            BigdataValueFactory f = store.getValueFactory();
            terms.add((BigdataValue)f.createBNode());
            terms.add((BigdataValue)f.createBNode("a"));
            Map<IV<?, ?>, BigdataValue> ids = this.doAddTermsTest(store, terms);
            if (store.isStable()) {
                store.commit();
                store = this.reopenStore(store);
                Map ids2 = store.getLexiconRelation().getTerms(ids.keySet());
                TestAddTerms.assertEquals((int)ids.size(), (int)ids2.size());
                for (Map.Entry<IV<?, ?>, BigdataValue> e : ids.entrySet()) {
                    IV<?, ?> id = e.getKey();
                    TestAddTerms.assertEquals((String)("Id mapped to a different term? : termId=" + id), (Object)ids.get(id), ids2.get(id));
                }
            }
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_duplicates_same_reference() {
        Properties properties = this.getProperties();
        properties.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        properties.setProperty(AbstractTripleStore.Options.TEXT_INDEX, "false");
        properties.setProperty(AbstractTripleStore.Options.INLINE_XSD_DATATYPE_LITERALS, "false");
        AbstractTripleStore store = this.getStore(properties);
        try {
            LinkedList<BigdataValue> terms = new LinkedList<BigdataValue>();
            BigdataValueFactory f = store.getValueFactory();
            BigdataURI type = f.asValue(RDF.TYPE);
            terms.add((BigdataValue)type);
            terms.add((BigdataValue)type);
            TestAddTerms.assertEquals((int)2, (int)terms.size());
            BigdataURI largeURI = f.createURI(TestAddTerms.getVeryLargeURI());
            terms.add((BigdataValue)largeURI);
            terms.add((BigdataValue)largeURI);
            TestAddTerms.assertEquals((int)4, (int)terms.size());
            BigdataLiteral lit1 = f.createLiteral("test");
            BigdataLiteral lit2 = f.createLiteral("test", "en");
            BigdataLiteral lit3 = f.createLiteral(TestAddTerms.getVeryLargeLiteral());
            terms.add((BigdataValue)lit1);
            terms.add((BigdataValue)lit1);
            terms.add((BigdataValue)lit2);
            terms.add((BigdataValue)lit2);
            terms.add((BigdataValue)lit3);
            terms.add((BigdataValue)lit3);
            TestAddTerms.assertEquals((int)10, (int)terms.size());
            if (store.getLexiconRelation().isStoreBlankNodes()) {
                BigdataBNode bnode1 = f.createBNode();
                BigdataBNode bnode2 = f.createBNode("a");
                BigdataBNode bnode3 = f.createBNode(TestAddTerms.getVeryLargeLiteral());
                terms.add((BigdataValue)bnode1);
                terms.add((BigdataValue)bnode1);
                terms.add((BigdataValue)bnode2);
                terms.add((BigdataValue)bnode2);
                terms.add((BigdataValue)bnode3);
                terms.add((BigdataValue)bnode3);
                TestAddTerms.assertEquals((int)16, (int)terms.size());
            }
            Map<IV<?, ?>, BigdataValue> ids = this.doAddTermsTest(store, terms);
            if (store.isStable()) {
                store.commit();
                store = this.reopenStore(store);
                Map ids2 = store.getLexiconRelation().getTerms(ids.keySet());
                TestAddTerms.assertEquals((int)ids.size(), (int)ids2.size());
                for (Map.Entry e : ids2.entrySet()) {
                    IV id = (IV)e.getKey();
                    TestAddTerms.assertEquals((String)("Id mapped to a different term? : termId=" + id), (Object)ids.get(id), ids2.get(id));
                }
            }
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_duplicates_distinct_references() {
        Properties properties = this.getProperties();
        properties.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        properties.setProperty(AbstractTripleStore.Options.TEXT_INDEX, "false");
        properties.setProperty(AbstractTripleStore.Options.INLINE_XSD_DATATYPE_LITERALS, "false");
        AbstractTripleStore store = this.getStore(properties);
        try {
            LinkedList<BigdataValue> terms = new LinkedList<BigdataValue>();
            BigdataValueFactory f = store.getValueFactory();
            terms.add((BigdataValue)f.asValue(RDF.TYPE));
            terms.add((BigdataValue)f.asValue(RDF.TYPE));
            TestAddTerms.assertEquals((int)2, (int)terms.size());
            terms.add((BigdataValue)f.createURI(TestAddTerms.getVeryLargeURI()));
            terms.add((BigdataValue)f.createURI(TestAddTerms.getVeryLargeURI()));
            TestAddTerms.assertEquals((int)4, (int)terms.size());
            terms.add((BigdataValue)f.createLiteral("test"));
            terms.add((BigdataValue)f.createLiteral("test"));
            terms.add((BigdataValue)f.createLiteral("test", "en"));
            terms.add((BigdataValue)f.createLiteral("test", "en"));
            terms.add((BigdataValue)f.createLiteral(TestAddTerms.getVeryLargeLiteral()));
            terms.add((BigdataValue)f.createLiteral(TestAddTerms.getVeryLargeLiteral()));
            TestAddTerms.assertEquals((int)10, (int)terms.size());
            if (store.getLexiconRelation().isStoreBlankNodes()) {
                terms.add((BigdataValue)f.createBNode());
                terms.add((BigdataValue)f.createBNode());
                terms.add((BigdataValue)f.createBNode("a"));
                terms.add((BigdataValue)f.createBNode("a"));
                terms.add((BigdataValue)f.createBNode(TestAddTerms.getVeryLargeLiteral()));
                terms.add((BigdataValue)f.createBNode(TestAddTerms.getVeryLargeLiteral()));
                TestAddTerms.assertEquals((int)16, (int)terms.size());
            }
            Map<IV<?, ?>, BigdataValue> ids = this.doAddTermsTest(store, terms);
            if (store.isStable()) {
                store.commit();
                store = this.reopenStore(store);
                Map ids2 = store.getLexiconRelation().getTerms(ids.keySet());
                TestAddTerms.assertEquals((int)ids.size(), (int)ids2.size());
                for (Map.Entry e : ids2.entrySet()) {
                    IV id = (IV)e.getKey();
                    TestAddTerms.assertEquals((String)("Id mapped to a different term? : termId=" + id), (Object)ids.get(id), ids2.get(id));
                }
            }
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    private Map<IV<?, ?>, BigdataValue> doAddTermsTest(AbstractTripleStore store, Collection<BigdataValue> terms) {
        int size = terms.size();
        BigdataValue[] a = terms.toArray(new BigdataValue[size]);
        store.getLexiconRelation().addTerms(a, size, false);
        ArrayList<IV> ids = new ArrayList<IV>();
        for (BigdataValue t : a) {
            ids.add(t.getIV());
        }
        Map tmp = store.getLexiconRelation().getTerms(ids);
        for (BigdataValue expected : a) {
            TestAddTerms.assertNotNull((String)("Did not assign IV? : " + expected), (Object)expected.getIV());
            BigdataValue actual = (BigdataValue)tmp.get(expected.getIV());
            if (actual == null) {
                TestAddTerms.fail((String)("Lexicon does not have value: iv=" + expected.getIV() + ", expected=" + expected));
            }
            TestAddTerms.assertEquals((String)("Id mapped to a different term? iv=" + expected.getIV()), (Object)expected, (Object)actual);
        }
        return tmp;
    }

    static String getVeryLargeURI() {
        int len = 1024000;
        StringBuilder sb = new StringBuilder(1024020);
        sb.append("http://www.bigdata.com/");
        for (int i = 0; i < 1024000; ++i) {
            sb.append(Character.toChars(65 + i % 26));
        }
        String s = sb.toString();
        return s;
    }

    static String getVeryLargeLiteral() {
        int len = 1024000;
        StringBuilder sb = new StringBuilder(1024000);
        for (int i = 0; i < 1024000; ++i) {
            sb.append(Character.toChars(65 + i % 26));
        }
        String s = sb.toString();
        return s;
    }
}

