/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.lexicon;

import com.bigdata.btree.BTree;
import com.bigdata.btree.IIndex;
import com.bigdata.btree.ITupleSerializer;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.KVO;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.btree.proc.AbstractKeyArrayIndexProcedureConstructor;
import com.bigdata.btree.proc.IResultHandler;
import com.bigdata.io.SerializerUtil;
import com.bigdata.rawstore.IRawStore;
import com.bigdata.rawstore.SimpleMemoryRawStore;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.AbstractIV;
import com.bigdata.rdf.internal.impl.BlobIV;
import com.bigdata.rdf.lexicon.BlobsIndexHelper;
import com.bigdata.rdf.lexicon.BlobsTupleSerializer;
import com.bigdata.rdf.lexicon.BlobsWriteProc;
import com.bigdata.rdf.lexicon.BlobsWriteTask;
import com.bigdata.rdf.lexicon.WriteTaskStats;
import com.bigdata.rdf.model.BigdataBNode;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.BigdataValueFactoryImpl;
import com.bigdata.rdf.util.DumpLexicon;
import com.bigdata.util.BytesUtil;
import java.util.Arrays;
import java.util.UUID;
import junit.framework.TestCase2;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.XMLSchema;

public class TestBlobsIndex
extends TestCase2 {
    public TestBlobsIndex() {
    }

    public TestBlobsIndex(String name) {
        super(name);
    }

    public void test_generateSortKeys() {
        BlobsIndexHelper h = new BlobsIndexHelper();
        String namespace = this.getName();
        BigdataValueFactory vf = BigdataValueFactoryImpl.getInstance((String)namespace);
        BigdataURI uri1 = vf.createURI("http://www.bigdata.com/testTerm");
        BigdataLiteral lit1 = vf.createLiteral("bigdata");
        BigdataLiteral lit2 = vf.createLiteral("bigdata", "en");
        BigdataLiteral lit3 = vf.createLiteral("bigdata", XMLSchema.STRING);
        BigdataBNode bnode1 = vf.createBNode();
        BigdataBNode bnode2 = vf.createBNode("abc");
        BigdataValue[] values = new BigdataValue[]{uri1, lit1, lit2, lit3, bnode1, bnode2};
        KVO[] a = h.generateKVOs(vf.getValueSerializer(), values, values.length);
        IKeyBuilder keyBuilder = h.newKeyBuilder();
        int i = 0;
        while (i < a.length) {
            KVO kvo = a[i];
            byte[] baseKey = kvo.key;
            int counter = i++;
            byte[] key = h.makeKey(keyBuilder.reset(), baseKey, counter);
            BlobIV iv = (BlobIV)IVUtility.decodeFromOffset((byte[])key, (int)0);
            TestBlobsIndex.assertEquals((Object)VTE.valueOf((Value)((Value)kvo.obj)), (Object)AbstractIV.getVTE((byte)KeyBuilder.decodeByte((int)key[0])));
            TestBlobsIndex.assertEquals((byte)BlobIV.toFlags((VTE)VTE.valueOf((Value)((Value)kvo.obj))), (byte)KeyBuilder.decodeByte((int)key[0]));
            TestBlobsIndex.assertEquals((Object)VTE.valueOf((Value)((Value)kvo.obj)), (Object)iv.getVTE());
            TestBlobsIndex.assertEquals((int)((BigdataValue)kvo.obj).hashCode(), (int)iv.hashCode());
            TestBlobsIndex.assertEquals((Object)iv, (Object)BlobIV.fromString((String)iv.toString()));
        }
    }

    static IndexMetadata getTermsIndexMetadata(String namespace) {
        String name = namespace + ".TERMS";
        BigdataValueFactory valueFactory = BigdataValueFactoryImpl.getInstance((String)namespace);
        IndexMetadata metadata = new IndexMetadata(name, UUID.randomUUID());
        metadata.setRawRecords(true);
        metadata.setTupleSerializer((ITupleSerializer)new BlobsTupleSerializer(namespace, valueFactory));
        return metadata;
    }

    static BTree createTermsIndex(IRawStore store, String namespace) {
        IndexMetadata metadata = TestBlobsIndex.getTermsIndexMetadata(namespace);
        BTree ndx = BTree.create((IRawStore)store, (IndexMetadata)metadata);
        return ndx;
    }

    public void test_termsIndex_addLookupValues_with_standard_bnode_semantics() {
        this.doTermsIndexAddLookupTest(false);
    }

    public void test_termsIndex_addLookupValue_with_toldBNodesMode() {
        this.doTermsIndexAddLookupTest(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTermsIndexAddLookupTest(boolean toldBNodes) {
        SimpleMemoryRawStore store = new SimpleMemoryRawStore();
        try {
            String namespace = this.getName();
            BTree ndx = TestBlobsIndex.createTermsIndex((IRawStore)store, namespace);
            BigdataValueFactory vf = BigdataValueFactoryImpl.getInstance((String)namespace);
            BlobsIndexHelper h = new BlobsIndexHelper();
            BigdataURI uri1 = vf.createURI("http://www.bigdata.com/testTerm");
            BigdataLiteral lit1 = vf.createLiteral("bigdata");
            BigdataLiteral lit2 = vf.createLiteral("bigdata", "en");
            BigdataLiteral lit3 = vf.createLiteral("bigdata", XMLSchema.STRING);
            BigdataBNode bnode1 = vf.createBNode();
            BigdataBNode bnode2 = vf.createBNode("abc");
            BigdataValue[] values = new BigdataValue[]{uri1, lit1, lit2, lit3, bnode1, bnode2};
            KVO[] a = h.generateKVOs(vf.getValueSerializer(), values, values.length);
            byte[][] keys = new byte[a.length][];
            byte[][] vals = new byte[a.length][];
            for (int i = 0; i < a.length; ++i) {
                keys[i] = a[i].key;
                vals[i] = a[i].val;
            }
            boolean readOnly = true;
            WriteTaskStats stats = new WriteTaskStats();
            BlobsWriteProc.BlobsWriteProcConstructor ctor = new BlobsWriteProc.BlobsWriteProcConstructor(true, toldBNodes);
            ndx.submit(0, values.length, (byte[][])keys, (byte[][])vals, (AbstractKeyArrayIndexProcedureConstructor)ctor, (IResultHandler)new BlobsWriteTask.BlobsWriteProcResultHandler(a, true, stats));
            for (int i = 0; i < a.length; ++i) {
                TestBlobsIndex.assertNull((Object)((BigdataValue)a[i].obj).getIV());
            }
            TestBlobsIndex.assertEquals((int)a.length, (int)stats.nunknown.get());
            readOnly = false;
            stats = new WriteTaskStats();
            ctor = new BlobsWriteProc.BlobsWriteProcConstructor(false, toldBNodes);
            ndx.submit(0, values.length, (byte[][])keys, (byte[][])vals, (AbstractKeyArrayIndexProcedureConstructor)ctor, (IResultHandler)new BlobsWriteTask.BlobsWriteProcResultHandler(a, false, stats));
            TestBlobsIndex.assertEquals((int)0, (int)stats.nunknown.get());
            IKeyBuilder keyBuilder = h.newKeyBuilder();
            for (int i = 0; i < a.length; ++i) {
                BigdataValue actual;
                BigdataValue expected = (BigdataValue)a[i].obj;
                IV iv = expected.getIV();
                TestBlobsIndex.assertNotNull((Object)iv);
                TestBlobsIndex.assertEquals((Object)VTE.valueOf((Value)expected), (Object)iv.getVTE());
                TestBlobsIndex.assertEquals((int)expected.hashCode(), (int)iv.hashCode());
                byte[] key = iv.encode(keyBuilder.reset()).getKey();
                IV decodedIV = IVUtility.decode((byte[])key);
                TestBlobsIndex.assertEquals((Object)iv, (Object)decodedIV);
                byte[] val = ndx.lookup(key);
                if (val == null) {
                    TestBlobsIndex.fail((String)("Could not resolve IV against index: expectedIV=" + iv + ", key=" + BytesUtil.toString((byte[])key)));
                }
                if (!expected.equals(actual = (BigdataValue)vf.getValueSerializer().deserialize(val))) {
                    log.error((Object)DumpLexicon.dumpBlobs((String)namespace, (IIndex)ndx));
                    TestBlobsIndex.fail((String)("Expected=" + expected + "(" + iv + "), actual=" + actual + "(" + actual.getIV() + ")"));
                }
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("i=" + expected + ", iv=" + iv));
            }
            IV[] expected = new IV[a.length];
            BigdataValueFactory vf2 = BigdataValueFactoryImpl.getInstance((String)(namespace + "-not-the-same"));
            for (int i = 0; i < a.length; ++i) {
                BigdataValue tmp = (BigdataValue)a[i].obj;
                TestBlobsIndex.assertNotNull((Object)((BigdataValue)a[i].obj).getIV());
                expected[i] = ((BigdataValue)a[i].obj).getIV();
                BigdataValue newVal = vf.asValue((Value)vf2.asValue((Value)tmp));
                a[i] = new KVO(a[i].key, a[i].val, (Object)newVal);
                TestBlobsIndex.assertEquals((Object)tmp, (Object)a[i].obj);
                TestBlobsIndex.assertNull((Object)((BigdataValue)a[i].obj).getIV());
            }
            boolean readOnly2 = true;
            WriteTaskStats stats2 = new WriteTaskStats();
            BlobsWriteProc.BlobsWriteProcConstructor ctor2 = new BlobsWriteProc.BlobsWriteProcConstructor(true, toldBNodes);
            ndx.submit(0, values.length, (byte[][])keys, (byte[][])vals, (AbstractKeyArrayIndexProcedureConstructor)ctor2, (IResultHandler)new BlobsWriteTask.BlobsWriteProcResultHandler(a, true, stats2));
            int nnotfound = 0;
            for (int i = 0; i < a.length; ++i) {
                IV expectedIV = expected[i];
                IV actualIV = ((BigdataValue)a[i].obj).getIV();
                if (expectedIV.isBNode()) {
                    if (toldBNodes) {
                        TestBlobsIndex.assertNotNull((Object)actualIV);
                        TestBlobsIndex.assertEquals((Object)expected[i], (Object)actualIV);
                        continue;
                    }
                    if (actualIV != null) {
                        TestBlobsIndex.fail((String)("Not expecting to unify blank node: expectedIV=" + expectedIV + ", but actualIV=" + actualIV + "(should be null)"));
                    }
                    ++nnotfound;
                    continue;
                }
                TestBlobsIndex.assertNotNull((Object)actualIV);
                TestBlobsIndex.assertEquals((Object)expected[i], (Object)actualIV);
            }
            TestBlobsIndex.assertEquals((int)nnotfound, (int)stats2.nunknown.get());
        }
        finally {
            store.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_blank_nodes_are_distinct() {
        boolean storeBlankNodes = false;
        SimpleMemoryRawStore store = new SimpleMemoryRawStore();
        try {
            String namespace = this.getName();
            IndexMetadata metadata = TestBlobsIndex.getTermsIndexMetadata(namespace);
            BTree ndx = BTree.create((IRawStore)store, (IndexMetadata)metadata);
            BigdataValueFactory vf = BigdataValueFactoryImpl.getInstance((String)namespace);
            BlobsIndexHelper h = new BlobsIndexHelper();
            BigdataBNode bnode1 = vf.createBNode();
            BigdataBNode bnode2 = vf.createBNode("abc");
            BigdataValue[] values = new BigdataValue[]{bnode1, bnode2};
            KVO[] a = h.generateKVOs(vf.getValueSerializer(), values, values.length);
            byte[][] keys = new byte[a.length][];
            byte[][] vals = new byte[a.length][];
            for (int i = 0; i < a.length; ++i) {
                keys[i] = a[i].key;
                vals[i] = a[i].val;
            }
            boolean readOnly = false;
            WriteTaskStats stats = new WriteTaskStats();
            BlobsWriteProc.BlobsWriteProcConstructor ctor = new BlobsWriteProc.BlobsWriteProcConstructor(false, false);
            ndx.submit(0, values.length, (byte[][])keys, (byte[][])vals, (AbstractKeyArrayIndexProcedureConstructor)ctor, (IResultHandler)new BlobsWriteTask.BlobsWriteProcResultHandler(a, false, stats));
            IV[] ivs1 = new IV[a.length];
            for (int i = 0; i < a.length; ++i) {
                IV iv = ((BigdataValue)a[i].obj).getIV();
                TestBlobsIndex.assertNotNull((Object)iv);
                ivs1[i] = iv;
            }
            BigdataBNode bnode12 = vf.createBNode();
            BigdataBNode bnode22 = vf.createBNode("abc");
            BigdataValue[] values2 = new BigdataValue[]{bnode12, bnode22};
            KVO[] a2 = h.generateKVOs(vf.getValueSerializer(), values2, values2.length);
            byte[][] keys2 = new byte[a2.length][];
            byte[][] vals2 = new byte[a2.length][];
            for (int i = 0; i < a2.length; ++i) {
                keys2[i] = a2[i].key;
                vals2[i] = a2[i].val;
            }
            boolean readOnly2 = false;
            WriteTaskStats stats2 = new WriteTaskStats();
            BlobsWriteProc.BlobsWriteProcConstructor ctor2 = new BlobsWriteProc.BlobsWriteProcConstructor(false, false);
            ndx.submit(0, values2.length, (byte[][])keys2, (byte[][])vals2, (AbstractKeyArrayIndexProcedureConstructor)ctor2, (IResultHandler)new BlobsWriteTask.BlobsWriteProcResultHandler(a2, false, stats2));
            IV[] ivs2 = new IV[a2.length];
            for (int i = 0; i < a2.length; ++i) {
                IV iv = ((BigdataValue)a2[i].obj).getIV();
                TestBlobsIndex.assertNotNull((Object)iv);
                ivs2[i] = iv;
            }
            IKeyBuilder keyBuilder = h.newKeyBuilder();
            TestBlobsIndex.assertEquals((int)ivs1.length, (int)ivs2.length);
            for (int i = 0; i < ivs1.length; ++i) {
                TestBlobsIndex.assertNotNull((Object)ivs1[i]);
                TestBlobsIndex.assertNotNull((Object)ivs2[i]);
                TestBlobsIndex.assertNotSame((Object)ivs1[i], (Object)ivs2[i]);
                TestBlobsIndex.assertNotNull((Object)h.lookup((IIndex)ndx, (BlobIV)ivs1[i], keyBuilder));
                TestBlobsIndex.assertNotNull((Object)h.lookup((IIndex)ndx, (BlobIV)ivs2[i], keyBuilder));
            }
        }
        finally {
            store.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_TermsTupleSerializer() {
        SimpleMemoryRawStore store = new SimpleMemoryRawStore();
        try {
            String namespace = this.getName();
            BTree ndx = TestBlobsIndex.createTermsIndex((IRawStore)store, namespace);
            BlobsIndexHelper h = new BlobsIndexHelper();
            BigdataValueFactory vf = BigdataValueFactoryImpl.getInstance((String)namespace);
            BigdataURI uri1 = vf.createURI("http://www.bigdata.com/testTerm");
            BigdataLiteral lit1 = vf.createLiteral("bigdata");
            BigdataLiteral lit2 = vf.createLiteral("bigdata", "en");
            BigdataLiteral lit3 = vf.createLiteral("bigdata", XMLSchema.STRING);
            BigdataBNode bnode1 = vf.createBNode();
            BigdataBNode bnode2 = vf.createBNode("abc");
            BigdataValue[] values = new BigdataValue[]{uri1, lit1, lit2, lit3, bnode1, bnode2};
            KVO[] a = h.generateKVOs(vf.getValueSerializer(), values, values.length);
            byte[][] keys = new byte[a.length][];
            byte[][] vals = new byte[a.length][];
            for (int i = 0; i < a.length; ++i) {
                keys[i] = a[i].key;
                vals[i] = a[i].val;
            }
            boolean readOnly = false;
            boolean storeBlankNodes = true;
            WriteTaskStats stats = new WriteTaskStats();
            BlobsWriteProc.BlobsWriteProcConstructor ctor = new BlobsWriteProc.BlobsWriteProcConstructor(false, true);
            ndx.submit(0, values.length, (byte[][])keys, (byte[][])vals, (AbstractKeyArrayIndexProcedureConstructor)ctor, (IResultHandler)new BlobsWriteTask.BlobsWriteProcResultHandler(a, false, stats));
            BlobsTupleSerializer tupSer = (BlobsTupleSerializer)ndx.getIndexMetadata().getTupleSerializer();
            for (BigdataValue value : values) {
                IV iv = value.getIV();
                TestBlobsIndex.assertNotNull((Object)iv);
                byte[] key = tupSer.serializeKey((Object)iv);
                byte[] val = ndx.lookup(key);
                BigdataValue actualValue = (BigdataValue)vf.getValueSerializer().deserialize(val);
                TestBlobsIndex.assertEquals((Object)value, (Object)actualValue);
            }
        }
        finally {
            store.destroy();
        }
    }

    public void test_blobsResultSerialization() {
        long totalBucketSize = 7L;
        int maxBucketSize = 3;
        int[] counters = new int[]{1, 0, 2, Integer.MIN_VALUE, 3};
        BlobsWriteProc.Result given = new BlobsWriteProc.Result(7L, 3, counters);
        TestBlobsIndex.assertEquals((String)"totalBucketSize", (long)7L, (long)given.totalBucketSize);
        TestBlobsIndex.assertEquals((String)"maxBucketSize", (int)3, (int)given.maxBucketSize);
        TestBlobsIndex.assertTrue((String)"counters[]", (boolean)Arrays.equals(counters, given.counters));
        byte[] b = SerializerUtil.serialize((Object)given);
        BlobsWriteProc.Result actual = (BlobsWriteProc.Result)SerializerUtil.deserialize((byte[])b);
        TestBlobsIndex.assertEquals((String)"totalBucketSize", (long)7L, (long)actual.totalBucketSize);
        TestBlobsIndex.assertEquals((String)"maxBucketSize", (int)3, (int)actual.maxBucketSize);
        TestBlobsIndex.assertTrue((String)"counters[]", (boolean)Arrays.equals(counters, actual.counters));
    }
}

