/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.lexicon;

import com.bigdata.btree.BTree;
import com.bigdata.btree.IIndex;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.rawstore.IRawStore;
import com.bigdata.rawstore.SimpleMemoryRawStore;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.BlobIV;
import com.bigdata.rdf.lexicon.BlobsIndexHelper;
import com.bigdata.rdf.lexicon.BlobsWriteTask;
import com.bigdata.rdf.lexicon.TestBlobsIndex;
import com.bigdata.rdf.lexicon.WriteTaskStats;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.BigdataValueFactoryImpl;
import junit.framework.TestCase2;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;

public class TestBlobsWriteTask
extends TestCase2 {
    public TestBlobsWriteTask() {
    }

    public TestBlobsWriteTask(String name) {
        super(name);
    }

    public void test_add_abc() {
        Value[] valuesIn = new Value[]{new LiteralImpl("abc")};
        this.doAddTermsTest(valuesIn, false);
    }

    public void test_add_emptyLiteral() {
        Value[] valuesIn = new Value[]{new LiteralImpl("")};
        this.doAddTermsTest(valuesIn, false);
    }

    public void test_add_various_toldBNodes() {
        Value[] valuesIn = new Value[]{new LiteralImpl("abc"), RDF.TYPE, RDF.PROPERTY, new LiteralImpl("test"), new LiteralImpl("test", "en"), new LiteralImpl("10", (URI)new URIImpl("http://www.w3.org/2001/XMLSchema#int")), new LiteralImpl("12", (URI)new URIImpl("http://www.w3.org/2001/XMLSchema#float")), new LiteralImpl("12.", (URI)new URIImpl("http://www.w3.org/2001/XMLSchema#float")), new LiteralImpl("12.0", (URI)new URIImpl("http://www.w3.org/2001/XMLSchema#float")), new LiteralImpl("12.00", (URI)new URIImpl("http://www.w3.org/2001/XMLSchema#float")), new BNodeImpl("a"), new BNodeImpl("12")};
        this.doAddTermsTest(valuesIn, true);
    }

    public void test_add_various_standardBNodes() {
        Value[] valuesIn = new Value[]{new LiteralImpl("abc"), RDF.TYPE, RDF.PROPERTY, new LiteralImpl("test"), new LiteralImpl("test", "en"), new LiteralImpl("10", (URI)new URIImpl("http://www.w3.org/2001/XMLSchema#int")), new LiteralImpl("12", (URI)new URIImpl("http://www.w3.org/2001/XMLSchema#float")), new LiteralImpl("12.", (URI)new URIImpl("http://www.w3.org/2001/XMLSchema#float")), new LiteralImpl("12.0", (URI)new URIImpl("http://www.w3.org/2001/XMLSchema#float")), new LiteralImpl("12.00", (URI)new URIImpl("http://www.w3.org/2001/XMLSchema#float"))};
        this.doAddTermsTest(valuesIn, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAddTermsTest(Value[] valuesIn, boolean toldBNodes) {
        for (int i = 0; i < valuesIn.length; ++i) {
            Value v = valuesIn[i];
            if (v == null) {
                TestBlobsWriteTask.fail((String)"Not expecting null inputs.");
            }
            if (!(v instanceof BigdataValue)) continue;
            TestBlobsWriteTask.fail((String)"Not expecting BigdataValue inputs.");
        }
        BlobsIndexHelper h = new BlobsIndexHelper();
        BigdataValueFactory vf = BigdataValueFactoryImpl.getInstance((String)this.getName());
        SimpleMemoryRawStore store = new SimpleMemoryRawStore();
        try {
            BigdataValue value;
            int i;
            int i2;
            BTree ndx = TestBlobsIndex.createTermsIndex((IRawStore)store, this.getName());
            for (int i3 = 0; i3 < valuesIn.length; ++i3) {
                IV iv = this.getTermIV(valuesIn[i3], h, vf, (IIndex)ndx);
                TestBlobsWriteTask.assertNull((Object)iv);
            }
            BigdataValue[] values = new BigdataValue[valuesIn.length];
            for (int i4 = 0; i4 < valuesIn.length; ++i4) {
                values[i4] = vf.asValue(valuesIn[i4]);
            }
            WriteTaskStats stats = this.addValues(vf, (IIndex)ndx, true, toldBNodes, values);
            for (i2 = 0; i2 < valuesIn.length; ++i2) {
                BigdataValue value2 = values[i2];
                IV iv = value2.getIV();
                if (iv == null) continue;
                TestBlobsWriteTask.fail((String)("Not expecting IV for " + value2));
            }
            IV[] expectedIVs = new IV[valuesIn.length];
            BigdataValue[] values2 = new BigdataValue[valuesIn.length];
            for (i2 = 0; i2 < valuesIn.length; ++i2) {
                values2[i2] = vf.asValue(valuesIn[i2]);
            }
            WriteTaskStats stats2 = this.addValues(vf, (IIndex)ndx, false, toldBNodes, values2);
            for (i = 0; i < valuesIn.length; ++i) {
                value = values2[i];
                IV iv = value.getIV();
                TestBlobsWriteTask.assertNotNull((Object)iv);
                if (iv.isNullIV()) {
                    TestBlobsWriteTask.fail((String)("Not expecting NullIV for " + value));
                }
                expectedIVs[i] = iv;
            }
            values2 = new BigdataValue[valuesIn.length];
            for (int i5 = 0; i5 < valuesIn.length; ++i5) {
                values2[i5] = vf.asValue(valuesIn[i5]);
            }
            stats = this.addValues(vf, (IIndex)ndx, true, toldBNodes, values2);
            for (i = 0; i < valuesIn.length; ++i) {
                IV expectedIV = expectedIVs[i];
                value = values2[i];
                IV actualIV = value.getIV();
                if (expectedIV.equals(actualIV)) continue;
                TestBlobsWriteTask.fail((String)("Value=" + value + ": expected=" + expectedIV + ", but actual=" + actualIV));
            }
            for (int i6 = 0; i6 < valuesIn.length; ++i6) {
                Value value3 = valuesIn[i6];
                IV expectedIV = expectedIVs[i6];
                IV actualIV = this.getTermIV(valuesIn[i6], h, vf, (IIndex)ndx);
                if (expectedIV.equals(actualIV)) continue;
                TestBlobsWriteTask.fail((String)("Value=" + value3 + ": expected=" + expectedIV + ", but actual=" + actualIV));
            }
        }
        finally {
            store.destroy();
        }
    }

    private IV getTermIV(Value value, BlobsIndexHelper h, BigdataValueFactory vf, IIndex ndx) {
        byte[] val;
        IKeyBuilder keyBuilder = h.newKeyBuilder();
        BigdataValue asValue = vf.asValue(value);
        byte[] baseKey = h.makePrefixKey(keyBuilder.reset(), asValue);
        int counter = h.resolveOrAddValue(ndx, true, keyBuilder, baseKey, val = vf.getValueSerializer().serialize((Value)asValue), null, null);
        if (counter == Integer.MIN_VALUE) {
            return null;
        }
        BlobIV iv = new BlobIV(VTE.valueOf((Value)asValue), asValue.hashCode(), (short)counter);
        return iv;
    }

    private WriteTaskStats addValues(BigdataValueFactory vf, IIndex ndx, boolean readOnly, boolean toldBNodes, BigdataValue[] values) {
        WriteTaskStats stats = new WriteTaskStats();
        BlobsWriteTask task = new BlobsWriteTask(ndx, vf, readOnly, toldBNodes, values.length, values, stats);
        try {
            task.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)stats);
        }
        return stats;
    }
}

