/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.lexicon;

import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.AbstractTripleStoreTestCase;
import java.util.HashSet;
import java.util.Iterator;
import org.openrdf.model.Literal;
import org.openrdf.model.impl.LiteralImpl;

public class TestCompletionScan
extends AbstractTripleStoreTestCase {
    public TestCompletionScan() {
    }

    public TestCompletionScan(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_completionScan() {
        AbstractTripleStore store = this.getStore();
        try {
            BigdataValueFactory f = store.getValueFactory();
            BigdataValue[] terms = new BigdataValue[]{f.createLiteral("mingus"), f.createLiteral("minor"), f.createLiteral("minor league"), f.createLiteral("minor threat"), f.createLiteral("minority report"), f.createLiteral("missing report")};
            store.addTerms(terms);
            HashSet<LiteralImpl> expected = new HashSet<LiteralImpl>();
            expected.add(new LiteralImpl("minor"));
            expected.add(new LiteralImpl("minor league"));
            expected.add(new LiteralImpl("minor threat"));
            expected.add(new LiteralImpl("minority report"));
            Iterator itr = store.getLexiconRelation().prefixScan((Literal)new LiteralImpl("minor"));
            while (itr.hasNext()) {
                if (expected.isEmpty()) {
                    TestCompletionScan.fail((String)"Nothing else is expected");
                }
                IV tid = (IV)itr.next();
                Literal lit = (Literal)store.getLexiconRelation().getTerm(tid);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Found: " + lit));
                }
                if (expected.remove(lit)) continue;
                TestCompletionScan.fail((String)("Not expecting: " + lit));
            }
            if (!expected.isEmpty()) {
                TestCompletionScan.fail((String)("Additional terms were expected: not found=" + expected));
            }
        }
        finally {
            store.__tearDownUnitTest();
        }
    }
}

