/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.lexicon;

import com.bigdata.btree.ChunkedLocalRangeIterator;
import com.bigdata.btree.IIndex;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.filter.TupleFilter;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.lexicon.ITextIndexer;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.spo.TestSPOKeyOrder;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.AbstractTripleStoreTestCase;
import com.bigdata.rdf.store.BigdataValueIteratorImpl;
import com.bigdata.rdf.util.DumpLexicon;
import com.bigdata.search.Hit;
import com.bigdata.search.Hiterator;
import com.bigdata.striterator.ChunkedWrappedIterator;
import com.bigdata.striterator.IChunkedIterator;
import com.bigdata.striterator.Resolver;
import com.bigdata.striterator.Striterator;
import cutthecrap.utils.striterators.IFilter;
import java.util.Iterator;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.model.vocabulary.XMLSchema;

public class TestFullTextIndex
extends AbstractTripleStoreTestCase {
    public TestFullTextIndex() {
    }

    public TestFullTextIndex(String name) {
        super(name);
    }

    private void assertExpectedHits(AbstractTripleStore store, String query, String languageCode, BigdataValue[] expected) {
        this.assertExpectedHits(store, query, languageCode, 0.4f, expected);
    }

    private void assertExpectedHits(AbstractTripleStore store, String query, boolean prefixMatch, BigdataValue[] expected) {
        this.assertExpectedHits(store, query, null, prefixMatch, 0.4f, expected);
    }

    private void assertExpectedHits(AbstractTripleStore store, String query, String languageCode, float minCosine, BigdataValue[] expected) {
        this.assertExpectedHits(store, query, languageCode, false, minCosine, expected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertExpectedHits(AbstractTripleStore store, String query, String languageCode, boolean prefixMatch, float minCosine, BigdataValue[] expected) {
        Hiterator hitr = store.getLexiconRelation().getSearchEngine().search(new ITextIndexer.FullTextQuery(query, languageCode, prefixMatch, null, false, false, (double)minCosine, 1.0, 1, Integer.MAX_VALUE, Long.MAX_VALUE, TimeUnit.MILLISECONDS));
        try (BigdataValueIteratorImpl itr2 = new BigdataValueIteratorImpl(store, (IChunkedIterator)new ChunkedWrappedIterator((Iterator)new Striterator((Iterator)hitr).addFilter((com.bigdata.striterator.IFilter)new Resolver(){
            private static final long serialVersionUID = 1L;

            protected Object resolve(Object e) {
                return ((Hit)e).getDocId();
            }
        })));){
            TestSPOKeyOrder.assertSameIteratorAnyOrder(expected, (Iterator)itr2);
        }
    }

    private LiteralImpl getLargeLiteral(AbstractTripleStore store) {
        int len = store.getLexiconRelation().getLexiconConfiguration().getBlobsThreshold();
        StringBuilder sb = new StringBuilder(len);
        String[] tokens = new String[]{"apple", "mary", "john", "barley", "mellow", "pudding", "fries", "peal", "gadzooks"};
        int i = 0;
        while (sb.length() < len) {
            sb.append(tokens[i % tokens.length]);
            sb.append(" ");
            ++i;
        }
        String s = sb.toString();
        if (log.isInfoEnabled()) {
            log.info((Object)("length(s)=" + s.length()));
        }
        return new LiteralImpl(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_fullTextIndex01() throws InterruptedException {
        AbstractTripleStore store = this.getStore();
        try {
            TestFullTextIndex.assertNotNull((Object)store.getLexiconRelation().getSearchEngine());
            BigdataValueFactory f = store.getValueFactory();
            LiteralImpl largeLiteral = this.getLargeLiteral(store);
            BigdataValue[] terms = new BigdataValue[]{f.createLiteral("abc"), f.createLiteral("abc", "en"), f.createLiteral("good day", "en"), f.createLiteral("gutten tag", "de"), f.createLiteral("tag team", "en"), f.createLiteral("the first day", "en"), f.createURI("http://www.bigdata.com"), f.asValue(RDF.TYPE), f.asValue(RDFS.SUBCLASSOF), f.asValue(XMLSchema.DECIMAL), f.createBNode(UUID.randomUUID().toString()), f.createBNode("a12"), f.asValue((Literal)largeLiteral)};
            store.addTerms(terms);
            if (log.isInfoEnabled()) {
                log.info((Object)DumpLexicon.dump((LexiconRelation)store.getLexiconRelation()));
            }
            this.assertExpectedHits(store, "abc", null, new BigdataValue[]{f.createLiteral("abc"), f.createLiteral("abc", "en")});
            this.assertExpectedHits(store, "tag", "en", new BigdataValue[]{f.createLiteral("gutten tag", "de"), f.createLiteral("tag team", "en")});
            this.assertExpectedHits(store, "tag", "de", new BigdataValue[]{f.createLiteral("gutten tag", "de"), f.createLiteral("tag team", "en")});
            this.assertExpectedHits(store, "GOOD DAY", "en", 0.0f, new BigdataValue[]{f.createLiteral("good day", "en"), f.createLiteral("the first day", "en")});
            this.assertExpectedHits(store, "GOOD DAY", "en", 0.5f, new BigdataValue[]{f.createLiteral("good day", "en")});
            this.assertExpectedHits(store, "day", "en", 0.0f, new BigdataValue[]{f.createLiteral("good day", "en"), f.createLiteral("the first day", "en")});
            this.assertExpectedHits(store, "the", "en", new BigdataValue[0]);
            this.assertExpectedHits(store, largeLiteral.getLabel(), null, 0.0f, new BigdataValue[]{f.asValue((Literal)largeLiteral)});
            if (store.isStable()) {
                store.commit();
                store = this.reopenStore(store);
                TestFullTextIndex.assertNotNull((Object)store.getLexiconRelation().getSearchEngine());
                this.assertExpectedHits(store, "abc", null, new BigdataValue[]{f.createLiteral("abc"), f.createLiteral("abc", "en")});
                this.assertExpectedHits(store, "tag", "en", new BigdataValue[]{f.createLiteral("gutten tag", "de"), f.createLiteral("tag team", "en")});
                this.assertExpectedHits(store, "tag", "de", new BigdataValue[]{f.createLiteral("gutten tag", "de"), f.createLiteral("tag team", "en")});
                this.assertExpectedHits(store, "GOOD DAY", "en", 0.0f, new BigdataValue[]{f.createLiteral("good day", "en"), f.createLiteral("the first day", "en")});
                this.assertExpectedHits(store, "GOOD DAY", "en", 0.5f, new BigdataValue[]{f.createLiteral("good day", "en")});
                this.assertExpectedHits(store, "day", "en", 0.0f, new BigdataValue[]{f.createLiteral("good day", "en"), f.createLiteral("the first day", "en")});
                this.assertExpectedHits(store, largeLiteral.getLabel(), null, 0.0f, new BigdataValue[]{f.asValue((Literal)largeLiteral)});
            }
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_text_index_datatype_literals() {
        Properties properties = this.getProperties();
        properties.setProperty(AbstractTripleStore.Options.TEXT_INDEX_DATATYPE_LITERALS, "true");
        properties.setProperty(AbstractTripleStore.Options.MAX_INLINE_TEXT_LENGTH, "0");
        AbstractTripleStore store = this.getStore(properties);
        try {
            TestFullTextIndex.assertNotNull((Object)store.getLexiconRelation().getSearchEngine());
            BigdataValueFactory f = store.getValueFactory();
            BigdataValue[] terms = new BigdataValue[]{f.createLiteral("quick brown fox"), f.createLiteral("slow brown dog", (URI)f.asValue(XMLSchema.STRING)), f.createLiteral("http://www.bigdata.com/mangy/yellow/cat", (URI)f.asValue(XMLSchema.ANYURI)), f.createLiteral("10.128.1.2", (URI)f.asValue(XSD.IPV4))};
            store.addTerms(terms);
            if (log.isInfoEnabled()) {
                log.info((Object)DumpLexicon.dump((LexiconRelation)store.getLexiconRelation()));
            }
            this.assertExpectedHits(store, "brown", "en", 0.0f, new BigdataValue[]{f.createLiteral("quick brown fox"), f.createLiteral("slow brown dog", XMLSchema.STRING)});
            this.assertExpectedHits(store, "cat", "en", new BigdataValue[]{f.createLiteral("http://www.bigdata.com/mangy/yellow/cat", (URI)f.asValue(XMLSchema.ANYURI))});
            this.assertExpectedHits(store, "10.128.", true, new BigdataValue[]{f.createLiteral("10.128.1.2", (URI)f.asValue(XSD.IPV4))});
            if (store.isStable()) {
                store.commit();
                store = this.reopenStore(store);
                TestFullTextIndex.assertNotNull((Object)store.getLexiconRelation().getSearchEngine());
                this.assertExpectedHits(store, "brown", "en", 0.0f, new BigdataValue[]{f.createLiteral("quick brown fox"), f.createLiteral("slow brown dog", XMLSchema.STRING)});
                this.assertExpectedHits(store, "cat", "en", new BigdataValue[]{f.createLiteral("http://www.bigdata.com/mangy/yellow/cat", (URI)f.asValue(XMLSchema.ANYURI))});
                this.assertExpectedHits(store, "10.128.", true, new BigdataValue[]{f.createLiteral("10.128.1.2", (URI)f.asValue(XSD.IPV4))});
            }
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    public void test_text_index_inline_unicode_literals() {
        log.warn((Object)"Full text index is not supported for inline Unicode at this time.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_rebuildIndex() {
        AbstractTripleStore store = this.getStore();
        try {
            TestFullTextIndex.assertNotNull((Object)store.getLexiconRelation().getSearchEngine());
            BigdataValueFactory f = store.getValueFactory();
            LiteralImpl largeLiteral = this.getLargeLiteral(store);
            BigdataValue[] terms = new BigdataValue[]{f.createLiteral("abc"), f.createLiteral("abc", "en"), f.createLiteral("good day", "en"), f.createLiteral("gutten tag", "de"), f.createLiteral("tag team", "en"), f.createLiteral("the first day", "en"), f.createURI("http://www.bigdata.com"), f.asValue(RDF.TYPE), f.asValue(RDFS.SUBCLASSOF), f.asValue(XMLSchema.DECIMAL), f.createBNode(UUID.randomUUID().toString()), f.createBNode("a12"), f.asValue((Literal)largeLiteral)};
            BigdataURI s = f.createURI("x:s");
            BigdataURI p = f.createURI("x:p");
            StatementBuffer buffer = new StatementBuffer(null, store, terms.length, 0);
            for (int i = 0; i < terms.length; ++i) {
                buffer.add((Resource)s, (URI)p, (Value)terms[i]);
            }
            buffer.flush();
            if (log.isInfoEnabled()) {
                log.info((Object)DumpLexicon.dump((LexiconRelation)store.getLexiconRelation()));
            }
            this.assertExpectedHits(store, "abc", null, new BigdataValue[]{f.createLiteral("abc"), f.createLiteral("abc", "en")});
            this.assertExpectedHits(store, "tag", "en", new BigdataValue[]{f.createLiteral("gutten tag", "de"), f.createLiteral("tag team", "en")});
            this.assertExpectedHits(store, "tag", "de", new BigdataValue[]{f.createLiteral("gutten tag", "de"), f.createLiteral("tag team", "en")});
            this.assertExpectedHits(store, "GOOD DAY", "en", 0.0f, new BigdataValue[]{f.createLiteral("good day", "en"), f.createLiteral("the first day", "en")});
            this.assertExpectedHits(store, "GOOD DAY", "en", 0.5f, new BigdataValue[]{f.createLiteral("good day", "en")});
            this.assertExpectedHits(store, "day", "en", 0.0f, new BigdataValue[]{f.createLiteral("good day", "en"), f.createLiteral("the first day", "en")});
            this.assertExpectedHits(store, "the", "en", new BigdataValue[0]);
            this.assertExpectedHits(store, largeLiteral.getLabel(), null, 0.0f, new BigdataValue[]{f.asValue((Literal)largeLiteral)});
            if (store.isStable()) {
                store.commit();
                store = this.reopenStore(store);
            }
            String name = store.getLexiconRelation().getNamespace() + "." + "search";
            IIndex btree = store.getIndexManager().getIndex(name, store.getTimestamp());
            ChunkedLocalRangeIterator itr = new ChunkedLocalRangeIterator(btree, null, null, 100, 19, (IFilter)new TupleFilter(){

                protected boolean isValid(ITuple tuple) {
                    return true;
                }
            });
            while (itr.hasNext()) {
                ITuple x = itr.next();
                log.info((Object)("removed FTS value: " + x));
            }
            if (store.isStable()) {
                store.commit();
                store = this.reopenStore(store);
            }
            TestFullTextIndex.assertNotNull((Object)store.getLexiconRelation().getSearchEngine());
            this.assertExpectedHits(store, "abc", null, new BigdataValue[0]);
            this.assertExpectedHits(store, "tag", "en", new BigdataValue[0]);
            this.assertExpectedHits(store, "tag", "de", new BigdataValue[0]);
            this.assertExpectedHits(store, "GOOD DAY", "en", 0.0f, new BigdataValue[0]);
            this.assertExpectedHits(store, "GOOD DAY", "en", 0.5f, new BigdataValue[0]);
            this.assertExpectedHits(store, "day", "en", 0.0f, new BigdataValue[0]);
            this.assertExpectedHits(store, largeLiteral.getLabel(), null, 0.0f, new BigdataValue[0]);
            store.getLexiconRelation().rebuildTextIndex(false);
            name = store.getLexiconRelation().getNamespace() + "." + "search";
            btree = store.getIndexManager().getIndex(name, store.getTimestamp());
            itr = btree.rangeIterator();
            while (itr.hasNext()) {
                log.info((Object)("fixed FTS value: " + itr.next()));
            }
            if (store.isStable()) {
                store.commit();
                store = this.reopenStore(store);
            }
            f = store.getValueFactory();
            TestFullTextIndex.assertNotNull((Object)store.getLexiconRelation().getSearchEngine());
            this.assertExpectedHits(store, "abc", null, new BigdataValue[]{f.createLiteral("abc"), f.createLiteral("abc", "en")});
            this.assertExpectedHits(store, "tag", "en", new BigdataValue[]{f.createLiteral("gutten tag", "de"), f.createLiteral("tag team", "en")});
            this.assertExpectedHits(store, "tag", "de", new BigdataValue[]{f.createLiteral("gutten tag", "de"), f.createLiteral("tag team", "en")});
            this.assertExpectedHits(store, "GOOD DAY", "en", 0.0f, new BigdataValue[]{f.createLiteral("good day", "en"), f.createLiteral("the first day", "en")});
            this.assertExpectedHits(store, "GOOD DAY", "en", 0.5f, new BigdataValue[]{f.createLiteral("good day", "en")});
            this.assertExpectedHits(store, "day", "en", 0.0f, new BigdataValue[]{f.createLiteral("good day", "en"), f.createLiteral("the first day", "en")});
            this.assertExpectedHits(store, largeLiteral.getLabel(), null, 0.0f, new BigdataValue[]{f.asValue((Literal)largeLiteral)});
        }
        finally {
            store.__tearDownUnitTest();
        }
    }
}

