/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.lexicon;

import com.bigdata.io.SerializerUtil;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.NotMaterializedException;
import com.bigdata.rdf.internal.impl.AbstractIV;
import com.bigdata.rdf.internal.impl.bnode.NumericBNodeIV;
import com.bigdata.rdf.internal.impl.bnode.UUIDBNodeIV;
import com.bigdata.rdf.internal.impl.literal.UUIDLiteralIV;
import com.bigdata.rdf.internal.impl.literal.XSDBooleanIV;
import com.bigdata.rdf.internal.impl.literal.XSDDecimalIV;
import com.bigdata.rdf.internal.impl.literal.XSDIntegerIV;
import com.bigdata.rdf.internal.impl.literal.XSDNumericIV;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.model.BigdataBNode;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.AbstractTripleStoreTestCase;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.UUID;

public class TestIVCache
extends AbstractTripleStoreTestCase {
    public TestIVCache() {
    }

    public TestIVCache(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_getValue() {
        AbstractTripleStore store = this.getStore(this.getProperties());
        try {
            LexiconRelation lex = store.getLexiconRelation();
            BigdataValueFactory f = lex.getValueFactory();
            BigdataURI uri = f.createURI("http://www.bigdata.com");
            BigdataBNode bnd = f.createBNode();
            BigdataLiteral lit = f.createLiteral("bigdata");
            BigdataValue[] a = new BigdataValue[]{uri, bnd, lit};
            lex.addTerms(a, a.length, false);
            this.doTest(lex, uri.getIV(), (BigdataValue)uri);
            this.doTest(lex, bnd.getIV(), (BigdataValue)bnd);
            this.doTest(lex, lit.getIV(), (BigdataValue)lit);
            this.doTest(lex, (IV)new XSDBooleanIV(true));
            this.doTest(lex, (IV)new XSDNumericIV(1));
            this.doTest(lex, (IV)new XSDNumericIV(1));
            this.doTest(lex, (IV)new XSDNumericIV(1));
            this.doTest(lex, (IV)new XSDNumericIV(1L));
            this.doTest(lex, (IV)new XSDNumericIV(1.0f));
            this.doTest(lex, (IV)new XSDNumericIV(1.0));
            this.doTest(lex, (IV)new XSDIntegerIV(BigInteger.valueOf(1L)));
            this.doTest(lex, (IV)new XSDDecimalIV(BigDecimal.valueOf(1.0)));
            this.doTest(lex, (IV)new UUIDBNodeIV(UUID.randomUUID()));
            this.doTest(lex, (IV)new NumericBNodeIV(1));
            this.doTest(lex, (IV)new UUIDLiteralIV(UUID.randomUUID()));
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    private void doTest(LexiconRelation lex, IV iv) {
        this.doTest(lex, iv, null);
    }

    private void doTest(LexiconRelation lex, IV iv, BigdataValue given) {
        BigdataValue val;
        try {
            iv.getValue();
            TestIVCache.fail((String)("Expecting: " + NotMaterializedException.class));
        }
        catch (NotMaterializedException e) {
            // empty catch block
        }
        if (!iv.isInline()) {
            val = given;
            ((AbstractIV)iv).setValue(val);
        } else {
            val = iv.asValue(lex);
        }
        TestIVCache.assertTrue((val == iv.getValue() ? 1 : 0) != 0);
        IV iv2 = (IV)SerializerUtil.deserialize((byte[])SerializerUtil.serialize((Object)iv));
        TestIVCache.assertTrue((iv != iv2 ? 1 : 0) != 0);
        BigdataValue val2 = iv2.getValue();
        TestIVCache.assertNotNull((Object)val2);
        TestIVCache.assertTrue((val != val2 ? 1 : 0) != 0);
        TestIVCache.assertTrue((val.getValueFactory() == val2.getValueFactory() ? 1 : 0) != 0);
        TestIVCache.assertTrue((boolean)val.equals(val2));
        if (iv.isInline()) {
            TestIVCache.assertTrue((val == iv.asValue(lex) ? 1 : 0) != 0);
            TestIVCache.assertTrue((val == iv.getValue() ? 1 : 0) != 0);
        }
    }
}

