/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.lexicon;

import com.bigdata.io.SerializerUtil;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.lexicon.Id2TermTupleSerializer;
import com.bigdata.rdf.model.BigdataValueFactoryImpl;
import com.bigdata.util.BytesUtil;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import junit.framework.TestCase2;

public class TestId2TermTupleSerializer
extends TestCase2 {
    public TestId2TermTupleSerializer() {
    }

    public TestId2TermTupleSerializer(String arg0) {
        super(arg0);
    }

    public void test_id2key() {
        String namespace = "lexicon";
        Id2TermTupleSerializer fixture = new Id2TermTupleSerializer("lexicon", BigdataValueFactoryImpl.getInstance((String)"lexicon"));
        TermId id1 = new TermId(VTE.URI, -1L);
        TermId id2 = new TermId(VTE.URI, 0L);
        TermId id3 = new TermId(VTE.URI, 1L);
        byte[] k1 = fixture.id2key(id1);
        byte[] k2 = fixture.id2key(id2);
        byte[] k3 = fixture.id2key(id3);
        if (log.isInfoEnabled()) {
            log.info((Object)("k1(termId:" + id1 + ") = " + BytesUtil.toString((byte[])k1)));
            log.info((Object)("k2(termId:" + id2 + ") = " + BytesUtil.toString((byte[])k2)));
            log.info((Object)("k3(termId:" + id3 + ") = " + BytesUtil.toString((byte[])k3)));
        }
        TestId2TermTupleSerializer.assertTrue((BytesUtil.compareBytes((byte[])k1, (byte[])k2) < 0 ? 1 : 0) != 0);
        TestId2TermTupleSerializer.assertTrue((BytesUtil.compareBytes((byte[])k2, (byte[])k3) < 0 ? 1 : 0) != 0);
    }

    public void test_versionedSerialization() {
        TestClass v0 = new TestClass(0, "namespace", BigdataValueFactoryImpl.class.getName());
        TestClass v1 = new TestClass(1, "namespace", "valueFactoryClass");
        this.assertEquals(v0, (TestClass)SerializerUtil.deserialize((byte[])SerializerUtil.serialize((Object)v0)));
        this.assertEquals(v1, (TestClass)SerializerUtil.deserialize((byte[])SerializerUtil.serialize((Object)v1)));
    }

    private void assertEquals(TestClass expected, TestClass actual) {
        TestId2TermTupleSerializer.assertEquals((String)"version", (short)expected.version, (short)actual.version);
        TestId2TermTupleSerializer.assertEquals((String)"namespace", (String)expected.namespace, (String)actual.namespace);
        TestId2TermTupleSerializer.assertEquals((String)"valueFactoryClass", (String)expected.valueFactoryClass, (String)actual.valueFactoryClass);
    }

    private static class TestClass
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        static final transient short VERSION0 = 0;
        static final transient short VERSION1 = 1;
        String namespace;
        String valueFactoryClass;
        short version;

        public TestClass() {
        }

        public TestClass(short version, String namespace, String valueFactoryClass) {
            this.version = version;
            this.namespace = namespace;
            this.valueFactoryClass = valueFactoryClass;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            short version = 0;
            String s1 = in.readUTF();
            String s2 = BigdataValueFactoryImpl.class.getName();
            if (s1.length() == 0) {
                version = in.readShort();
                s1 = in.readUTF();
                s2 = in.readUTF();
            }
            String namespace = s1;
            String valueFactoryClass = s2;
            this.version = version;
            this.namespace = namespace;
            this.valueFactoryClass = valueFactoryClass;
            if (log.isInfoEnabled()) {
                log.info((Object)("read: " + this));
            }
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            switch (this.version) {
                case 0: {
                    out.writeUTF(this.namespace);
                    break;
                }
                case 1: {
                    out.writeUTF("");
                    out.writeShort(this.version);
                    out.writeUTF(this.namespace);
                    out.writeUTF(this.valueFactoryClass);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("wrote: " + this));
            }
        }

        public String toString() {
            return "{version=" + this.version + ",namespace=" + this.namespace + ",valueFactoryClass=" + this.valueFactoryClass + "}";
        }
    }

    private static class V1
    implements Externalizable {
        private V1() {
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
        }
    }
}

