/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.lexicon;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.internal.ColorsEnumExtension;
import com.bigdata.rdf.internal.EpochExtension;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.SampleExtensionFactory;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.internal.impl.literal.LiteralExtensionIV;
import com.bigdata.rdf.model.BigdataBNode;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.AbstractTripleStoreTestCase;
import com.bigdata.rdf.vocab.BaseVocabulary;
import com.bigdata.rdf.vocab.NoVocabulary;
import com.bigdata.rdf.vocab.VocabularyDecl;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.openrdf.model.URI;

public class TestInlining
extends AbstractTripleStoreTestCase {
    private static final transient Logger log = Logger.getLogger(TestInlining.class);

    public TestInlining() {
    }

    public TestInlining(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_unsigned() {
        Properties properties = this.getProperties();
        properties.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        properties.setProperty(AbstractTripleStore.Options.TEXT_INDEX, "false");
        AbstractTripleStore store = this.getStore(properties);
        try {
            HashSet<BigdataValue> terms = new HashSet<BigdataValue>();
            BigdataValueFactory f = store.getValueFactory();
            terms.add((BigdataValue)f.createLiteral("135", (URI)f.createURI(XSD.UNSIGNED_BYTE.toString())));
            terms.add((BigdataValue)f.createLiteral("2147483657", (URI)f.createURI(XSD.UNSIGNED_INT.toString())));
            terms.add((BigdataValue)f.createLiteral("32777", (URI)f.createURI(XSD.UNSIGNED_SHORT.toString())));
            terms.add((BigdataValue)f.createLiteral(BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.valueOf(10L)).toString(), (URI)f.createURI(XSD.UNSIGNED_LONG.toString())));
            Map<IV<?, ?>, BigdataValue> ids = this.doAddTermsTest(store, terms);
            if (store.isStable()) {
                store.commit();
                store = this.reopenStore(store);
                Map ids2 = store.getLexiconRelation().getTerms(ids.keySet());
                TestInlining.assertEquals((int)ids.size(), (int)ids2.size());
                for (Map.Entry<IV<?, ?>, BigdataValue> e : ids.entrySet()) {
                    IV<?, ?> id = e.getKey();
                    TestInlining.assertTrue((store.isInlineLiterals() == id.isInline() ? 1 : 0) != 0);
                    TestInlining.assertEquals((String)("Id mapped to a different term? : termId=" + id), (Object)ids.get(id), ids2.get(id));
                }
            }
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_verifyunsigned() {
        Properties properties = this.getProperties();
        properties.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        properties.setProperty(AbstractTripleStore.Options.TEXT_INDEX, "false");
        AbstractTripleStore store = this.getStore(properties);
        try {
            HashSet terms = new HashSet();
            BigdataValueFactory f = store.getValueFactory();
            TestInlining.assertTrue((f.createLiteral("198", (URI)f.createURI(XSD.UNSIGNED_BYTE.toString())).intValue() == 198 ? 1 : 0) != 0);
            TestInlining.assertTrue((f.createLiteral("0", (URI)f.createURI(XSD.UNSIGNED_BYTE.toString())).intValue() == 0 ? 1 : 0) != 0);
            TestInlining.assertTrue((f.createLiteral("50", (URI)f.createURI(XSD.UNSIGNED_BYTE.toString())).intValue() == 50 ? 1 : 0) != 0);
            TestInlining.assertTrue((f.createLiteral("32777", (URI)f.createURI(XSD.UNSIGNED_SHORT.toString())).intValue() == 32777 ? 1 : 0) != 0);
            TestInlining.assertTrue((f.createLiteral("0", (URI)f.createURI(XSD.UNSIGNED_SHORT.toString())).intValue() == 0 ? 1 : 0) != 0);
            TestInlining.assertTrue((f.createLiteral("2147483657", (URI)f.createURI(XSD.UNSIGNED_INT.toString())).longValue() == 0x80000009L ? 1 : 0) != 0);
            TestInlining.assertTrue((f.createLiteral("0", (URI)f.createURI(XSD.UNSIGNED_INT.toString())).longValue() == 0L ? 1 : 0) != 0);
            BigInteger bi = BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.valueOf(10L));
            TestInlining.assertTrue((boolean)f.createLiteral(bi.toString(), (URI)f.createURI(XSD.UNSIGNED_LONG.toString())).integerValue().equals(bi));
            BigInteger biz = BigInteger.valueOf(0L);
            TestInlining.assertTrue((boolean)f.createLiteral("0", (URI)f.createURI(XSD.UNSIGNED_LONG.toString())).integerValue().equals(biz));
            BigInteger bi100 = BigInteger.valueOf(100L);
            TestInlining.assertTrue((boolean)f.createLiteral("100", (URI)f.createURI(XSD.UNSIGNED_LONG.toString())).integerValue().equals(bi100));
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_badrangeUnsigned() {
        Properties properties = this.getProperties();
        properties.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        properties.setProperty(AbstractTripleStore.Options.TEXT_INDEX, "false");
        AbstractTripleStore store = this.getStore(properties);
        try {
            HashSet<BigdataValue> terms = new HashSet<BigdataValue>();
            BigdataValueFactory f = store.getValueFactory();
            terms.add((BigdataValue)f.createLiteral("-12", (URI)f.createURI(XSD.UNSIGNED_BYTE.toString())));
            terms.add((BigdataValue)f.createLiteral("1024", (URI)f.createURI(XSD.UNSIGNED_BYTE.toString())));
            terms.add((BigdataValue)f.createLiteral("2147483647", (URI)f.createURI(XSD.UNSIGNED_SHORT.toString())));
            terms.add((BigdataValue)f.createLiteral("9223372036854775807", (URI)f.createURI(XSD.UNSIGNED_INT.toString())));
            terms.add((BigdataValue)f.createLiteral(BigInteger.valueOf(Long.MAX_VALUE).multiply(BigInteger.valueOf(10L)).toString(), (URI)f.createURI(XSD.UNSIGNED_LONG.toString())));
            Map<IV<?, ?>, BigdataValue> ids = this.doAddTermsTest(store, terms);
            if (store.isStable()) {
                store.commit();
                store = this.reopenStore(store);
                Map ids2 = store.getLexiconRelation().getTerms(ids.keySet());
                TestInlining.assertEquals((int)ids.size(), (int)ids2.size());
                for (Map.Entry<IV<?, ?>, BigdataValue> e : ids.entrySet()) {
                    IV<?, ?> id = e.getKey();
                    TestInlining.assertFalse((boolean)id.isInline());
                    TestInlining.assertEquals((String)("Id mapped to a different term? : termId=" + id), (Object)ids.get(id), ids2.get(id));
                }
            }
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_inlineBNodes() {
        Properties properties = this.getProperties();
        properties.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        properties.setProperty(AbstractTripleStore.Options.TEXT_INDEX, "false");
        properties.setProperty(AbstractTripleStore.Options.STORE_BLANK_NODES, "true");
        properties.setProperty(AbstractTripleStore.Options.INLINE_BNODES, "true");
        properties.setProperty(AbstractTripleStore.Options.MAX_INLINE_TEXT_LENGTH, "0");
        AbstractTripleStore store = this.getStore(properties);
        try {
            if (!store.isStable()) {
                return;
            }
            HashSet<BigdataValue> terms = new HashSet<BigdataValue>();
            BigdataValueFactory f = store.getValueFactory();
            BigdataBNode b1 = f.createBNode("i1");
            BigdataBNode b01 = f.createBNode("i01");
            BigdataBNode b2 = f.createBNode("u" + UUID.randomUUID().toString());
            BigdataBNode b3 = f.createBNode("foo");
            BigdataBNode b4 = f.createBNode("foo12345");
            BigdataBNode b5 = f.createBNode("12345");
            terms.add((BigdataValue)b1);
            terms.add((BigdataValue)b01);
            terms.add((BigdataValue)b2);
            terms.add((BigdataValue)b3);
            terms.add((BigdataValue)b4);
            terms.add((BigdataValue)b5);
            Map<IV<?, ?>, BigdataValue> ids = this.doAddTermsTest(store, terms);
            TestInlining.assertTrue((boolean)b1.getIV().isInline());
            TestInlining.assertFalse((boolean)b01.getIV().isInline());
            TestInlining.assertTrue((boolean)b2.getIV().isInline());
            TestInlining.assertFalse((boolean)b3.getIV().isInline());
            TestInlining.assertFalse((boolean)b4.getIV().isInline());
            TestInlining.assertFalse((boolean)b5.getIV().isInline());
            if (store.isStable()) {
                store.commit();
                store = this.reopenStore(store);
                Map ids2 = store.getLexiconRelation().getTerms(ids.keySet());
                TestInlining.assertEquals((int)ids.size(), (int)ids2.size());
                for (Map.Entry<IV<?, ?>, BigdataValue> e : ids.entrySet()) {
                    IV<?, ?> iv = e.getKey();
                    if (log.isInfoEnabled()) {
                        log.info(iv);
                    }
                    TestInlining.assertEquals((String)("Id mapped to a different term? : iv=" + iv), (Object)ids.get(iv), ids2.get(iv));
                }
            }
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_epoch() {
        Properties properties = this.getProperties();
        properties.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, MyVocabulary.class.getName());
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        properties.setProperty(AbstractTripleStore.Options.TEXT_INDEX, "false");
        properties.setProperty(AbstractTripleStore.Options.MAX_INLINE_TEXT_LENGTH, "0");
        properties.setProperty(AbstractTripleStore.Options.EXTENSION_FACTORY_CLASS, SampleExtensionFactory.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            if (!store.isStable()) {
                return;
            }
            HashSet<BigdataValue> terms = new HashSet<BigdataValue>();
            BigdataValueFactory f = store.getValueFactory();
            BigdataLiteral l1 = f.createLiteral("1", EpochExtension.EPOCH);
            BigdataLiteral l2 = f.createLiteral(String.valueOf(System.currentTimeMillis()), EpochExtension.EPOCH);
            BigdataURI datatype = f.createURI(EpochExtension.EPOCH.stringValue());
            terms.add((BigdataValue)l1);
            terms.add((BigdataValue)l2);
            terms.add((BigdataValue)datatype);
            Map<IV<?, ?>, BigdataValue> ids = this.doAddTermsTest(store, terms);
            TestInlining.assertTrue((boolean)l1.getIV().isInline());
            TestInlining.assertTrue((boolean)l2.getIV().isInline());
            LiteralExtensionIV iv1 = (LiteralExtensionIV)l1.getIV();
            LiteralExtensionIV iv2 = (LiteralExtensionIV)l2.getIV();
            TestInlining.assertEquals((Object)iv1.getExtensionIV(), (Object)datatype.getIV());
            TestInlining.assertEquals((Object)iv2.getExtensionIV(), (Object)datatype.getIV());
            if (store.isStable()) {
                store.commit();
                store = this.reopenStore(store);
                Map ids2 = store.getLexiconRelation().getTerms(ids.keySet());
                TestInlining.assertEquals((int)ids.size(), (int)ids2.size());
                for (Map.Entry<IV<?, ?>, BigdataValue> e : ids.entrySet()) {
                    IV<?, ?> iv = e.getKey();
                    if (log.isInfoEnabled()) {
                        log.info(iv);
                    }
                    TestInlining.assertEquals((String)("Id mapped to a different term? : iv=" + iv), (Object)ids.get(iv), ids2.get(iv));
                }
            }
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_colorsEnum() {
        Properties properties = this.getProperties();
        properties.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, MyVocabulary.class.getName());
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        properties.setProperty(AbstractTripleStore.Options.TEXT_INDEX, "false");
        properties.setProperty(AbstractTripleStore.Options.MAX_INLINE_TEXT_LENGTH, "0");
        properties.setProperty(AbstractTripleStore.Options.EXTENSION_FACTORY_CLASS, SampleExtensionFactory.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            if (!store.isStable()) {
                return;
            }
            HashSet<BigdataValue> terms = new HashSet<BigdataValue>();
            BigdataValueFactory f = store.getValueFactory();
            BigdataLiteral l1 = f.createLiteral("Blue", ColorsEnumExtension.COLOR);
            BigdataLiteral l2 = f.createLiteral("Brown", ColorsEnumExtension.COLOR);
            BigdataLiteral l3 = f.createLiteral("Yellow", ColorsEnumExtension.COLOR);
            BigdataLiteral l4 = f.createLiteral("Dog", ColorsEnumExtension.COLOR);
            BigdataLiteral l5 = f.createLiteral("yellow", ColorsEnumExtension.COLOR);
            BigdataURI datatype = f.createURI(ColorsEnumExtension.COLOR.stringValue());
            terms.add((BigdataValue)l1);
            terms.add((BigdataValue)l2);
            terms.add((BigdataValue)l3);
            terms.add((BigdataValue)l4);
            terms.add((BigdataValue)l5);
            terms.add((BigdataValue)datatype);
            Map<IV<?, ?>, BigdataValue> ids = this.doAddTermsTest(store, terms);
            TestInlining.assertTrue((boolean)l1.getIV().isInline());
            TestInlining.assertTrue((boolean)l2.getIV().isInline());
            TestInlining.assertTrue((boolean)l3.getIV().isInline());
            TestInlining.assertFalse((boolean)l4.getIV().isInline());
            TestInlining.assertFalse((boolean)l5.getIV().isInline());
            LiteralExtensionIV iv1 = (LiteralExtensionIV)l1.getIV();
            LiteralExtensionIV iv2 = (LiteralExtensionIV)l2.getIV();
            LiteralExtensionIV iv3 = (LiteralExtensionIV)l3.getIV();
            if (log.isInfoEnabled()) {
                log.info((Object)(l1.getLabel() + ": " + iv1.getDelegate().byteValue()));
            }
            if (log.isInfoEnabled()) {
                log.info((Object)(l2.getLabel() + ": " + iv2.getDelegate().byteValue()));
            }
            if (log.isInfoEnabled()) {
                log.info((Object)(l3.getLabel() + ": " + iv3.getDelegate().byteValue()));
            }
            TestInlining.assertEquals((Object)iv1.getExtensionIV(), (Object)datatype.getIV());
            TestInlining.assertEquals((Object)iv2.getExtensionIV(), (Object)datatype.getIV());
            TestInlining.assertEquals((Object)iv3.getExtensionIV(), (Object)datatype.getIV());
            if (store.isStable()) {
                store.commit();
                store = this.reopenStore(store);
                Map ids2 = store.getLexiconRelation().getTerms(ids.keySet());
                TestInlining.assertEquals((int)ids.size(), (int)ids2.size());
                for (Map.Entry<IV<?, ?>, BigdataValue> e : ids.entrySet()) {
                    IV<?, ?> iv = e.getKey();
                    if (log.isInfoEnabled()) {
                        log.info(iv);
                    }
                    TestInlining.assertEquals((String)("Id mapped to a different term? : iv=" + iv), (Object)ids.get(iv), ids2.get(iv));
                }
            }
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    private Map<IV<?, ?>, BigdataValue> doAddTermsTest(AbstractTripleStore store, Collection<BigdataValue> terms) {
        int size = terms.size();
        BigdataValue[] a = terms.toArray(new BigdataValue[size]);
        store.getLexiconRelation().addTerms(a, size, false);
        ArrayList<IV> ids = new ArrayList<IV>();
        for (BigdataValue t : a) {
            ids.add(t.getIV());
        }
        Map tmp = store.getLexiconRelation().getTerms(ids);
        TestInlining.assertEquals((int)size, (int)tmp.size());
        for (BigdataValue expected : a) {
            TestInlining.assertNotSame((String)("Did not assign internal value? : " + expected), null, (Object)expected.getIV());
            BigdataValue actual = (BigdataValue)tmp.get(expected.getIV());
            if (actual == null) {
                TestInlining.fail((String)("Lexicon does not have value: iv=" + expected.getIV() + ", term=" + expected));
            }
            TestInlining.assertEquals((String)("IV mapped to a different term? iv=" + expected.getIV()), (Object)expected, (Object)actual);
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_inlinedatetimes() {
        Properties properties = this.getProperties();
        properties.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        properties.setProperty(AbstractTripleStore.Options.TEXT_INDEX, "false");
        properties.setProperty(AbstractTripleStore.Options.INLINE_DATE_TIMES, "true");
        AbstractTripleStore store = this.getStore(properties);
        try {
            LinkedHashSet<BigdataValue> terms = new LinkedHashSet<BigdataValue>();
            BigdataValueFactory f = store.getValueFactory();
            terms.add((BigdataValue)f.createLiteral("2008-03-22T00:00:00", (URI)f.createURI(XSD.DATETIME.toString())));
            terms.add((BigdataValue)f.createLiteral("2007-12-25T00:00:00", (URI)f.createURI(XSD.DATETIME.toString())));
            terms.add((BigdataValue)f.createLiteral("2008-03-22", (URI)f.createURI(XSD.DATE.toString())));
            terms.add((BigdataValue)f.createLiteral("2007-12-25", (URI)f.createURI(XSD.DATE.toString())));
            terms.add((BigdataValue)f.createLiteral("00:00:00", (URI)f.createURI(XSD.TIME.toString())));
            terms.add((BigdataValue)f.createLiteral("13:15:42", (URI)f.createURI(XSD.TIME.toString())));
            terms.add((BigdataValue)f.createLiteral("---22", (URI)f.createURI(XSD.GDAY.toString())));
            terms.add((BigdataValue)f.createLiteral("---25", (URI)f.createURI(XSD.GDAY.toString())));
            terms.add((BigdataValue)f.createLiteral("--03", (URI)f.createURI(XSD.GMONTH.toString())));
            terms.add((BigdataValue)f.createLiteral("--12", (URI)f.createURI(XSD.GMONTH.toString())));
            terms.add((BigdataValue)f.createLiteral("--03-22", (URI)f.createURI(XSD.GMONTHDAY.toString())));
            terms.add((BigdataValue)f.createLiteral("--12-25", (URI)f.createURI(XSD.GMONTHDAY.toString())));
            terms.add((BigdataValue)f.createLiteral("2008", (URI)f.createURI(XSD.GYEAR.toString())));
            terms.add((BigdataValue)f.createLiteral("1976", (URI)f.createURI(XSD.GYEAR.toString())));
            terms.add((BigdataValue)f.createLiteral("2008-03", (URI)f.createURI(XSD.GYEARMONTH.toString())));
            terms.add((BigdataValue)f.createLiteral("1976-12", (URI)f.createURI(XSD.GYEARMONTH.toString())));
            Map<IV<?, ?>, BigdataValue> ids = this.doAddTermsTest(store, terms);
            if (store.isStable()) {
                store.commit();
                store = this.reopenStore(store);
                Map ids2 = store.getLexiconRelation().getTerms(ids.keySet());
                TestInlining.assertEquals((int)ids.size(), (int)ids2.size());
                for (Map.Entry<IV<?, ?>, BigdataValue> e : ids.entrySet()) {
                    IV<?, ?> id = e.getKey();
                    if (log.isInfoEnabled()) {
                        log.info((Object)ids.get(id));
                    }
                    if (log.isInfoEnabled()) {
                        log.info(ids2.get(id));
                    }
                    TestInlining.assertEquals((String)("Id mapped to a different term? : termId=" + id), (Object)ids.get(id), ids2.get(id));
                }
            }
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    public static class MyVocabulary
    extends BaseVocabulary {
        public MyVocabulary() {
        }

        public MyVocabulary(String namespace) {
            super(namespace);
        }

        protected void addValues() {
            this.addDecl(new MyVocabularyDecl());
        }
    }

    private static class MyVocabularyDecl
    implements VocabularyDecl {
        private static final URI[] myVocabURIs = new URI[]{ColorsEnumExtension.COLOR, EpochExtension.EPOCH};

        public Iterator<URI> values() {
            return Collections.unmodifiableList(Arrays.asList(myVocabURIs)).iterator();
        }
    }
}

