/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.lexicon;

import com.bigdata.btree.keys.DefaultKeyBuilderFactory;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.btree.keys.StrengthEnum;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.lexicon.LexiconKeyBuilder;
import com.bigdata.rdf.model.BigdataValueSerializer;
import com.bigdata.util.BytesUtil;
import java.util.Properties;
import junit.framework.TestCase2;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.XMLSchema;

public class TestLexiconKeyBuilder
extends TestCase2 {
    private LexiconKeyBuilder fixture = null;

    public TestLexiconKeyBuilder() {
    }

    public TestLexiconKeyBuilder(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        DefaultKeyBuilderFactory keyBuilderFactory = new DefaultKeyBuilderFactory(this.getProperties());
        IKeyBuilder keyBuilder = keyBuilderFactory.getKeyBuilder();
        this.fixture = new LexiconKeyBuilder(keyBuilder);
    }

    protected void tearDown() throws Exception {
        this.fixture = null;
        super.tearDown();
    }

    public void test_encodeDecodeCodeByte() {
        TestLexiconKeyBuilder.assertEquals((byte)1, (byte)this.fixture.value2Key((Value)RDF.TYPE)[0]);
        TestLexiconKeyBuilder.assertEquals((byte)5, (byte)this.fixture.value2Key((Value)new BNodeImpl("foo"))[0]);
        TestLexiconKeyBuilder.assertEquals((byte)2, (byte)this.fixture.value2Key((Value)new LiteralImpl("abc"))[0]);
        TestLexiconKeyBuilder.assertEquals((byte)3, (byte)this.fixture.value2Key((Value)new LiteralImpl("abc", "en"))[0]);
        TestLexiconKeyBuilder.assertEquals((byte)4, (byte)this.fixture.value2Key((Value)new LiteralImpl("abc", XSD.BOOLEAN))[0]);
    }

    public void test_keyOrder() {
        byte[] uri = this.fixture.value2Key((Value)RDF.TYPE);
        byte[] bnd = this.fixture.value2Key((Value)new BNodeImpl("foo"));
        byte[] lit = this.fixture.value2Key((Value)new LiteralImpl("abc"));
        byte[] lcl = this.fixture.value2Key((Value)new LiteralImpl("abc", "en"));
        byte[] dtl = this.fixture.value2Key((Value)new LiteralImpl("abc", XSD.BOOLEAN));
        TestLexiconKeyBuilder.assertTrue((BytesUtil.UnsignedByteArrayComparator.INSTANCE.compare(uri, lit) < 0 ? 1 : 0) != 0);
        TestLexiconKeyBuilder.assertTrue((BytesUtil.UnsignedByteArrayComparator.INSTANCE.compare(lit, lcl) < 0 ? 1 : 0) != 0);
        TestLexiconKeyBuilder.assertTrue((BytesUtil.UnsignedByteArrayComparator.INSTANCE.compare(lcl, dtl) < 0 ? 1 : 0) != 0);
        TestLexiconKeyBuilder.assertTrue((BytesUtil.UnsignedByteArrayComparator.INSTANCE.compare(dtl, bnd) < 0 ? 1 : 0) != 0);
    }

    public void test_uri() {
        String uri1 = "http://www.cognitiveweb.org";
        String uri2 = "http://www.cognitiveweb.org/a";
        String uri3 = "http://www.cognitiveweb.com/a";
        byte[] k1 = this.fixture.uri2key("http://www.cognitiveweb.org");
        byte[] k2 = this.fixture.uri2key("http://www.cognitiveweb.org/a");
        byte[] k3 = this.fixture.uri2key("http://www.cognitiveweb.com/a");
        if (log.isInfoEnabled()) {
            log.info((Object)("k1(http://www.cognitiveweb.org) = " + BytesUtil.toString((byte[])k1)));
            log.info((Object)("k2(http://www.cognitiveweb.org/a) = " + BytesUtil.toString((byte[])k2)));
            log.info((Object)("k3(http://www.cognitiveweb.com/a) = " + BytesUtil.toString((byte[])k3)));
        }
        TestLexiconKeyBuilder.assertTrue((BytesUtil.compareBytes((byte[])k1, (byte[])k2) < 0 ? 1 : 0) != 0);
        TestLexiconKeyBuilder.assertTrue((BytesUtil.compareBytes((byte[])k2, (byte[])k3) > 0 ? 1 : 0) != 0);
    }

    public void test_plainLiteral() {
        String lit1 = "abc";
        String lit2 = "abcd";
        String lit3 = "abcde";
        byte[] k1 = this.fixture.plainLiteral2key("abc");
        byte[] k2 = this.fixture.plainLiteral2key("abcd");
        byte[] k3 = this.fixture.plainLiteral2key("abcde");
        if (log.isInfoEnabled()) {
            log.info((Object)("k1(abc) = " + BytesUtil.toString((byte[])k1)));
            log.info((Object)("k2(abcd) = " + BytesUtil.toString((byte[])k2)));
            log.info((Object)("k3(abcde) = " + BytesUtil.toString((byte[])k3)));
        }
        TestLexiconKeyBuilder.assertTrue((BytesUtil.compareBytes((byte[])k1, (byte[])k2) < 0 ? 1 : 0) != 0);
        TestLexiconKeyBuilder.assertTrue((BytesUtil.compareBytes((byte[])k2, (byte[])k3) < 0 ? 1 : 0) != 0);
    }

    public void test_languageCodeLiteral() {
        String en = "en";
        String de = "de";
        String lit1 = "abc";
        String lit2 = "abc";
        String lit3 = "abce";
        byte[] k1 = this.fixture.languageCodeLiteral2key("en", "abc");
        byte[] k2 = this.fixture.languageCodeLiteral2key("de", "abc");
        byte[] k3 = this.fixture.languageCodeLiteral2key("de", "abce");
        if (log.isInfoEnabled()) {
            log.info((Object)("k1(en:abc) = " + BytesUtil.toString((byte[])k1)));
            log.info((Object)("k2(de:abc) = " + BytesUtil.toString((byte[])k2)));
            log.info((Object)("k3(de:abce) = " + BytesUtil.toString((byte[])k3)));
        }
        TestLexiconKeyBuilder.assertTrue((BytesUtil.compareBytes((byte[])k1, (byte[])k2) > 0 ? 1 : 0) != 0);
        TestLexiconKeyBuilder.assertTrue((BytesUtil.compareBytes((byte[])k1, (byte[])k2) != 0 ? 1 : 0) != 0);
        TestLexiconKeyBuilder.assertTrue((BytesUtil.compareBytes((byte[])k2, (byte[])k3) < 0 ? 1 : 0) != 0);
    }

    public void test_plain_vs_languageCode_literal() {
        String en = "en";
        String lit1 = "abc";
        byte[] k1 = this.fixture.plainLiteral2key("abc");
        byte[] k2 = this.fixture.languageCodeLiteral2key("en", "abc");
        TestLexiconKeyBuilder.assertFalse((boolean)BytesUtil.bytesEqual((byte[])k1, (byte[])k2));
        TestLexiconKeyBuilder.assertTrue((BytesUtil.compareBytes((byte[])k1, (byte[])k2) < 0 ? 1 : 0) != 0);
    }

    public void test_datatype_unknown() {
        this.fixture.datatypeLiteral2key((URI)new URIImpl("http://www.bigdata.com/foo"), "foo");
    }

    public void test_datatypeLiteral_xsd_boolean() {
        URI datatype = XMLSchema.BOOLEAN;
        String lit1 = "true";
        String lit2 = "false";
        String lit3 = "1";
        String lit4 = "0";
        byte[] k1 = this.fixture.datatypeLiteral2key(datatype, "true");
        byte[] k2 = this.fixture.datatypeLiteral2key(datatype, "false");
        byte[] k3 = this.fixture.datatypeLiteral2key(datatype, "1");
        byte[] k4 = this.fixture.datatypeLiteral2key(datatype, "0");
        if (log.isInfoEnabled()) {
            log.info((Object)("k1(boolean:true) = " + BytesUtil.toString((byte[])k1)));
            log.info((Object)("k2(boolean:false) = " + BytesUtil.toString((byte[])k2)));
            log.info((Object)("k3(boolean:1) = " + BytesUtil.toString((byte[])k3)));
            log.info((Object)("k4(boolean:0) = " + BytesUtil.toString((byte[])k4)));
        }
        TestLexiconKeyBuilder.assertTrue((BytesUtil.compareBytes((byte[])k1, (byte[])k2) != 0 ? 1 : 0) != 0);
        TestLexiconKeyBuilder.assertTrue((BytesUtil.compareBytes((byte[])k1, (byte[])k2) > 0 ? 1 : 0) != 0);
        TestLexiconKeyBuilder.assertTrue((BytesUtil.compareBytes((byte[])k1, (byte[])k3) != 0 ? 1 : 0) != 0);
        TestLexiconKeyBuilder.assertTrue((BytesUtil.compareBytes((byte[])k2, (byte[])k4) != 0 ? 1 : 0) != 0);
    }

    public void test_datatypeLiteral_xsd_int() {
        URI datatype = XMLSchema.INT;
        String lit1 = "-4";
        String lit2 = "005";
        String lit3 = "5";
        String lit4 = "6";
        byte[] k1 = this.fixture.datatypeLiteral2key(datatype, "-4");
        byte[] k2 = this.fixture.datatypeLiteral2key(datatype, "005");
        byte[] k3 = this.fixture.datatypeLiteral2key(datatype, "5");
        byte[] k4 = this.fixture.datatypeLiteral2key(datatype, "6");
        if (log.isInfoEnabled()) {
            log.info((Object)("k1(int:-4) = " + BytesUtil.toString((byte[])k1)));
            log.info((Object)("k2(int:005) = " + BytesUtil.toString((byte[])k2)));
            log.info((Object)("k2(int:5) = " + BytesUtil.toString((byte[])k3)));
            log.info((Object)("k4(int:6) = " + BytesUtil.toString((byte[])k4)));
        }
        TestLexiconKeyBuilder.assertTrue((BytesUtil.compareBytes((byte[])k1, (byte[])k2) < 0 ? 1 : 0) != 0);
        TestLexiconKeyBuilder.assertTrue((BytesUtil.compareBytes((byte[])k3, (byte[])k4) < 0 ? 1 : 0) != 0);
        TestLexiconKeyBuilder.assertTrue((BytesUtil.compareBytes((byte[])k2, (byte[])k3) != 0 ? 1 : 0) != 0);
    }

    public void test_disjoint_value_space() {
        TestLexiconKeyBuilder.assertFalse((boolean)BytesUtil.bytesEqual((byte[])this.fixture.datatypeLiteral2key(XMLSchema.LONG, "-1"), (byte[])this.fixture.datatypeLiteral2key(XMLSchema.INT, "-1")));
        TestLexiconKeyBuilder.assertFalse((boolean)BytesUtil.bytesEqual((byte[])this.fixture.datatypeLiteral2key(XMLSchema.LONG, "-1"), (byte[])this.fixture.datatypeLiteral2key(XMLSchema.SHORT, "-1")));
        TestLexiconKeyBuilder.assertFalse((boolean)BytesUtil.bytesEqual((byte[])this.fixture.datatypeLiteral2key(XMLSchema.LONG, "-1"), (byte[])this.fixture.datatypeLiteral2key(XMLSchema.BYTE, "-1")));
        TestLexiconKeyBuilder.assertFalse((boolean)BytesUtil.bytesEqual((byte[])this.fixture.datatypeLiteral2key(XMLSchema.INT, "-1"), (byte[])this.fixture.datatypeLiteral2key(XMLSchema.SHORT, "-1")));
        TestLexiconKeyBuilder.assertFalse((boolean)BytesUtil.bytesEqual((byte[])this.fixture.datatypeLiteral2key(XMLSchema.INT, "-1"), (byte[])this.fixture.datatypeLiteral2key(XMLSchema.BYTE, "-1")));
        TestLexiconKeyBuilder.assertFalse((boolean)BytesUtil.bytesEqual((byte[])this.fixture.datatypeLiteral2key(XMLSchema.SHORT, "-1"), (byte[])this.fixture.datatypeLiteral2key(XMLSchema.BYTE, "-1")));
    }

    public void test_datatypeLiteral_xsd_float() {
        URI datatype = XMLSchema.FLOAT;
        String lit1 = "-4.0";
        String lit2 = "005";
        String lit3 = "5.";
        String lit4 = "5.0";
        String lit5 = "6";
        byte[] k1 = this.fixture.datatypeLiteral2key(datatype, "-4.0");
        byte[] k2 = this.fixture.datatypeLiteral2key(datatype, "005");
        byte[] k3 = this.fixture.datatypeLiteral2key(datatype, "5.");
        byte[] k4 = this.fixture.datatypeLiteral2key(datatype, "5.0");
        byte[] k5 = this.fixture.datatypeLiteral2key(datatype, "6");
        if (log.isInfoEnabled()) {
            log.info((Object)("k1(float:-4.0) = " + BytesUtil.toString((byte[])k1)));
            log.info((Object)("k2(float:005) = " + BytesUtil.toString((byte[])k2)));
            log.info((Object)("k3(float:5.) = " + BytesUtil.toString((byte[])k3)));
            log.info((Object)("k4(float:5.) = " + BytesUtil.toString((byte[])k4)));
            log.info((Object)("k5(float:6) = " + BytesUtil.toString((byte[])k5)));
        }
        TestLexiconKeyBuilder.assertTrue((BytesUtil.compareBytes((byte[])k1, (byte[])k2) < 0 ? 1 : 0) != 0);
        TestLexiconKeyBuilder.assertTrue((BytesUtil.compareBytes((byte[])k4, (byte[])k5) < 0 ? 1 : 0) != 0);
        TestLexiconKeyBuilder.assertTrue((BytesUtil.compareBytes((byte[])k2, (byte[])k3) != 0 ? 1 : 0) != 0);
        TestLexiconKeyBuilder.assertTrue((BytesUtil.compareBytes((byte[])k3, (byte[])k4) != 0 ? 1 : 0) != 0);
    }

    public void test_datatypeLiteral_xsd_double() {
        URI datatype = XMLSchema.DOUBLE;
        String lit1 = "-4.0";
        String lit2 = "005";
        String lit3 = "5.";
        String lit4 = "5.0";
        String lit5 = "6";
        byte[] k1 = this.fixture.datatypeLiteral2key(datatype, "-4.0");
        byte[] k2 = this.fixture.datatypeLiteral2key(datatype, "005");
        byte[] k3 = this.fixture.datatypeLiteral2key(datatype, "5.");
        byte[] k4 = this.fixture.datatypeLiteral2key(datatype, "5.0");
        byte[] k5 = this.fixture.datatypeLiteral2key(datatype, "6");
        if (log.isInfoEnabled()) {
            log.info((Object)("k1(double:-4.0) = " + BytesUtil.toString((byte[])k1)));
            log.info((Object)("k2(double:005) = " + BytesUtil.toString((byte[])k2)));
            log.info((Object)("k3(double:5.) = " + BytesUtil.toString((byte[])k3)));
            log.info((Object)("k4(double:5.) = " + BytesUtil.toString((byte[])k4)));
            log.info((Object)("k5(double:6) = " + BytesUtil.toString((byte[])k5)));
        }
        TestLexiconKeyBuilder.assertTrue((BytesUtil.compareBytes((byte[])k1, (byte[])k2) < 0 ? 1 : 0) != 0);
        TestLexiconKeyBuilder.assertTrue((BytesUtil.compareBytes((byte[])k4, (byte[])k5) < 0 ? 1 : 0) != 0);
        TestLexiconKeyBuilder.assertTrue((BytesUtil.compareBytes((byte[])k2, (byte[])k3) != 0 ? 1 : 0) != 0);
        TestLexiconKeyBuilder.assertTrue((BytesUtil.compareBytes((byte[])k3, (byte[])k4) != 0 ? 1 : 0) != 0);
    }

    public void test_datatypeLiteral_xsd_int_not_double_or_float() {
        String lit1 = "4";
        byte[] k0 = this.fixture.datatypeLiteral2key(XMLSchema.INT, "4");
        byte[] k1 = this.fixture.datatypeLiteral2key(XMLSchema.FLOAT, "4");
        byte[] k2 = this.fixture.datatypeLiteral2key(XMLSchema.DOUBLE, "4");
        if (log.isInfoEnabled()) {
            log.info((Object)("k0(float:4) = " + BytesUtil.toString((byte[])k0)));
            log.info((Object)("k1(float:4) = " + BytesUtil.toString((byte[])k1)));
            log.info((Object)("k2(double:4) = " + BytesUtil.toString((byte[])k2)));
        }
        TestLexiconKeyBuilder.assertTrue((BytesUtil.compareBytes((byte[])k0, (byte[])k1) != 0 ? 1 : 0) != 0);
        TestLexiconKeyBuilder.assertTrue((BytesUtil.compareBytes((byte[])k0, (byte[])k2) != 0 ? 1 : 0) != 0);
    }

    public void test_datatypeLiteral_xsd_float_not_double() {
        String lit1 = "04.21";
        byte[] k1 = this.fixture.datatypeLiteral2key(XMLSchema.FLOAT, "04.21");
        byte[] k2 = this.fixture.datatypeLiteral2key(XMLSchema.DOUBLE, "04.21");
        if (log.isInfoEnabled()) {
            log.info((Object)("k1(float:04.21) = " + BytesUtil.toString((byte[])k1)));
            log.info((Object)("k2(double:04.21) = " + BytesUtil.toString((byte[])k2)));
        }
        TestLexiconKeyBuilder.assertTrue((BytesUtil.compareBytes((byte[])k1, (byte[])k2) != 0 ? 1 : 0) != 0);
    }

    public void test_blankNode() {
        String id1 = "_12";
        String id2 = "_abc";
        String id3 = "abc";
        byte[] k1 = this.fixture.blankNode2Key("_12");
        byte[] k2 = this.fixture.blankNode2Key("_abc");
        byte[] k3 = this.fixture.blankNode2Key("abc");
        if (log.isInfoEnabled()) {
            log.info((Object)("k1(bnodeId:_12) = " + BytesUtil.toString((byte[])k1)));
            log.info((Object)("k2(bnodeId:_abc) = " + BytesUtil.toString((byte[])k2)));
            log.info((Object)("k3(bnodeId:abc) = " + BytesUtil.toString((byte[])k3)));
        }
        TestLexiconKeyBuilder.assertTrue((BytesUtil.compareBytes((byte[])k1, (byte[])k2) < 0 ? 1 : 0) != 0);
        TestLexiconKeyBuilder.assertTrue((BytesUtil.compareBytes((byte[])k2, (byte[])k3) < 0 ? 1 : 0) != 0);
    }

    public void test_termTypeOrder() {
        byte[] k1 = this.fixture.uri2key("http://www.cognitiveweb.org");
        byte[] k2 = this.fixture.plainLiteral2key("hello world!");
        byte[] k3 = this.fixture.blankNode2Key("a12");
        TestLexiconKeyBuilder.assertTrue((BytesUtil.compareBytes((byte[])k1, (byte[])k2) < 0 ? 1 : 0) != 0);
        TestLexiconKeyBuilder.assertTrue((BytesUtil.compareBytes((byte[])k2, (byte[])k3) < 0 ? 1 : 0) != 0);
    }

    public void test_consistencyIssue() {
        BigdataValueSerializer fixture = new BigdataValueSerializer((ValueFactory)ValueFactoryImpl.getInstance());
        byte[] newValBytes = new byte[]{0, 2, 0, 14, 66, 114, 105, 97, 110, 32, 77, 99, 67, 97, 114, 116, 104, 121};
        byte[] oldValBytes = new byte[]{0, 2, 0, 15, 127, 66, 114, 105, 97, 110, 32, 77, 99, 67, 97, 114, 116, 104, 121};
        Value newValue = fixture.deserialize(newValBytes);
        Value oldValue = fixture.deserialize(oldValBytes);
        if (log.isInfoEnabled()) {
            log.info((Object)("new=" + newValue));
            log.info((Object)("old=" + oldValue));
        }
        Properties properties = new Properties();
        properties.setProperty(KeyBuilder.Options.STRENGTH, StrengthEnum.Identical.toString());
        IKeyBuilder keyBuilder = KeyBuilder.newUnicodeInstance((Properties)properties);
        LexiconKeyBuilder lexKeyBuilder = new LexiconKeyBuilder(keyBuilder);
        byte[] newValKey = lexKeyBuilder.value2Key(newValue);
        byte[] oldValKey = lexKeyBuilder.value2Key(oldValue);
        if (log.isInfoEnabled()) {
            log.info((Object)("newValKey=" + BytesUtil.toString((byte[])newValKey)));
            log.info((Object)("oldValKey=" + BytesUtil.toString((byte[])oldValKey)));
        }
        TestLexiconKeyBuilder.assertFalse((boolean)BytesUtil.bytesEqual((byte[])newValKey, (byte[])oldValKey));
    }
}

