/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.lexicon;

import com.bigdata.rdf.lexicon.ITextIndexer;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.spo.TestSPOKeyOrder;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.AbstractTripleStoreTestCase;
import com.bigdata.rdf.store.BigdataValueIteratorImpl;
import com.bigdata.search.Hit;
import com.bigdata.search.Hiterator;
import com.bigdata.striterator.ChunkedWrappedIterator;
import com.bigdata.striterator.IChunkedIterator;
import com.bigdata.striterator.IFilter;
import com.bigdata.striterator.Resolver;
import com.bigdata.striterator.Striterator;
import java.util.Iterator;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.model.vocabulary.XMLSchema;

@Deprecated
public class TestSubjectCentricFullTextIndex
extends AbstractTripleStoreTestCase {
    private static final transient Logger log = Logger.getLogger(TestSubjectCentricFullTextIndex.class);

    public TestSubjectCentricFullTextIndex() {
    }

    public TestSubjectCentricFullTextIndex(String name) {
        super(name);
    }

    @Override
    public Properties getProperties() {
        Properties properties = new Properties(super.getProperties());
        properties.setProperty(AbstractTripleStore.Options.TEXT_INDEX, "true");
        properties.setProperty(AbstractTripleStore.Options.SUBJECT_CENTRIC_TEXT_INDEX, "true");
        return properties;
    }

    private void assertExpectedHits(AbstractTripleStore store, String query, String languageCode, BigdataValue[] expected) {
        this.assertExpectedHits(store, query, languageCode, 0.0f, expected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertExpectedHits(AbstractTripleStore store, String query, String languageCode, float minCosine, BigdataValue[] expected) {
        Hiterator hitr = store.getLexiconRelation().getSubjectCentricSearchEngine().search(new ITextIndexer.FullTextQuery(query, languageCode, false, null, false, false, (double)minCosine, 1.0, 1, Integer.MAX_VALUE, Long.MAX_VALUE, TimeUnit.MILLISECONDS));
        try (BigdataValueIteratorImpl itr2 = new BigdataValueIteratorImpl(store, (IChunkedIterator)new ChunkedWrappedIterator((Iterator)new Striterator((Iterator)hitr).addFilter((IFilter)new Resolver(){
            private static final long serialVersionUID = 1L;

            protected Object resolve(Object e) {
                Hit hit = (Hit)e;
                if (log.isDebugEnabled()) {
                    log.debug((Object)hit);
                }
                return hit.getDocId();
            }
        })));){
            TestSPOKeyOrder.assertSameIteratorAnyOrder(expected, (Iterator)itr2);
        }
    }

    private LiteralImpl getLargeLiteral(AbstractTripleStore store) {
        int len = store.getLexiconRelation().getLexiconConfiguration().getBlobsThreshold();
        StringBuilder sb = new StringBuilder(len);
        String[] tokens = new String[]{"apple", "mary", "john", "barley", "mellow", "pudding", "fries", "peal", "gadzooks"};
        int i = 0;
        while (sb.length() < len) {
            sb.append(tokens[i % tokens.length]);
            sb.append(" ");
            ++i;
        }
        String s = sb.toString();
        if (log.isInfoEnabled()) {
            log.info((Object)("length(s)=" + s.length()));
        }
        return new LiteralImpl(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_SingleSubject() {
        AbstractTripleStore store = this.getStore();
        try {
            BigdataValue[] terms;
            TestSubjectCentricFullTextIndex.assertNotNull((Object)store.getLexiconRelation().getSearchEngine());
            BigdataValueFactory f = store.getValueFactory();
            BigdataURI s = f.createURI("http://www.bigdata.com/rdf#s");
            BigdataURI p = f.createURI("http://www.bigdata.com/rdf#p");
            LiteralImpl largeLiteral = this.getLargeLiteral(store);
            for (BigdataValue o : terms = new BigdataValue[]{f.createLiteral("abc"), f.createLiteral("abc", "en"), f.createLiteral("good day", "en"), f.createLiteral("gutten tag", "de"), f.createLiteral("tag team", "en"), f.createLiteral("the first day", "en"), f.createURI("http://www.bigdata.com"), f.asValue(RDF.TYPE), f.asValue(RDFS.SUBCLASSOF), f.asValue(XMLSchema.DECIMAL), f.createBNode(UUID.randomUUID().toString()), f.createBNode("a12"), f.asValue((Literal)largeLiteral)}) {
                store.addStatement((Resource)s, (URI)p, (Value)o);
            }
            store.commit();
            store.getLexiconRelation().buildSubjectCentricTextIndex();
            if (log.isInfoEnabled()) {
                log.info((Object)("\n" + store.dumpStore(true, false, false)));
            }
            this.assertExpectedHits(store, "abc", null, new BigdataValue[]{s});
            this.assertExpectedHits(store, "tag", "en", new BigdataValue[]{s});
            this.assertExpectedHits(store, "tag", "de", new BigdataValue[]{s});
            this.assertExpectedHits(store, "GOOD DAY", "en", 0.0f, new BigdataValue[]{s});
            this.assertExpectedHits(store, "GOOD DAY", "en", 0.0f, new BigdataValue[]{s});
            this.assertExpectedHits(store, "day", "en", 0.0f, new BigdataValue[]{s});
            this.assertExpectedHits(store, "the", "en", new BigdataValue[0]);
            this.assertExpectedHits(store, largeLiteral.getLabel(), null, 0.0f, new BigdataValue[]{s});
            if (store.isStable()) {
                store.commit();
                store = this.reopenStore(store);
            }
            TestSubjectCentricFullTextIndex.assertNotNull((Object)store.getLexiconRelation().getSubjectCentricSearchEngine());
            this.assertExpectedHits(store, "abc", null, new BigdataValue[]{s});
            this.assertExpectedHits(store, "tag", "en", new BigdataValue[]{s});
            this.assertExpectedHits(store, "tag", "de", new BigdataValue[]{s});
            this.assertExpectedHits(store, "GOOD DAY", "en", 0.0f, new BigdataValue[]{s});
            this.assertExpectedHits(store, "GOOD DAY", "en", 0.0f, new BigdataValue[]{s});
            this.assertExpectedHits(store, "day", "en", 0.0f, new BigdataValue[]{s});
            this.assertExpectedHits(store, largeLiteral.getLabel(), null, 0.0f, new BigdataValue[]{s});
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_MultiSubject() {
        AbstractTripleStore store = this.getStore();
        try {
            int i;
            BigdataValue[] terms;
            TestSubjectCentricFullTextIndex.assertNotNull((Object)store.getLexiconRelation().getSearchEngine());
            BigdataValueFactory f = store.getValueFactory();
            BigdataURI s1 = f.createURI("http://www.bigdata.com/rdf#s1");
            BigdataURI s2 = f.createURI("http://www.bigdata.com/rdf#s2");
            BigdataURI s3 = f.createURI("http://www.bigdata.com/rdf#s3");
            BigdataURI p = f.createURI("http://www.bigdata.com/rdf#p");
            LiteralImpl largeLiteral = this.getLargeLiteral(store);
            for (BigdataValue o : terms = new BigdataValue[]{f.createLiteral("abc"), f.createLiteral("abc", "en"), f.createLiteral("good day", "en"), f.createLiteral("gutten tag", "de"), f.createLiteral("tag team", "en"), f.createLiteral("the first day", "en"), f.createURI("http://www.bigdata.com"), f.asValue(RDF.TYPE), f.asValue(RDFS.SUBCLASSOF), f.asValue(XMLSchema.DECIMAL), f.createBNode(UUID.randomUUID().toString()), f.createBNode("a12"), f.asValue((Literal)largeLiteral)}) {
                store.addStatement((Resource)s1, (URI)p, (Value)o);
            }
            for (i = 0; i < 3; ++i) {
                store.addStatement((Resource)s2, (URI)p, (Value)terms[i]);
            }
            for (i = 3; i < 6; ++i) {
                store.addStatement((Resource)s3, (URI)p, (Value)terms[i]);
            }
            store.commit();
            store.getLexiconRelation().buildSubjectCentricTextIndex();
            if (log.isInfoEnabled()) {
                log.info((Object)("\n" + store.dumpStore(true, false, false)));
            }
            this.assertExpectedHits(store, "abc", null, new BigdataValue[]{s1, s2});
            this.assertExpectedHits(store, "tag", "en", new BigdataValue[]{s1, s3});
            this.assertExpectedHits(store, "tag", "de", new BigdataValue[]{s1, s3});
            this.assertExpectedHits(store, "GOOD DAY", "en", 0.0f, new BigdataValue[]{s1, s2, s3});
            this.assertExpectedHits(store, "day", "en", 0.0f, new BigdataValue[]{s1, s2, s3});
            this.assertExpectedHits(store, "the", "en", new BigdataValue[0]);
            this.assertExpectedHits(store, largeLiteral.getLabel(), null, 0.0f, new BigdataValue[]{s1});
            if (store.isStable()) {
                store.commit();
                store = this.reopenStore(store);
            }
            TestSubjectCentricFullTextIndex.assertNotNull((Object)store.getLexiconRelation().getSubjectCentricSearchEngine());
            this.assertExpectedHits(store, "abc", null, new BigdataValue[]{s1, s2});
            this.assertExpectedHits(store, "tag", "en", new BigdataValue[]{s1, s3});
            this.assertExpectedHits(store, "tag", "de", new BigdataValue[]{s1, s3});
            this.assertExpectedHits(store, "GOOD DAY", "en", 0.0f, new BigdataValue[]{s1, s2, s3});
            this.assertExpectedHits(store, "day", "en", 0.0f, new BigdataValue[]{s1, s2, s3});
            this.assertExpectedHits(store, largeLiteral.getLabel(), null, 0.0f, new BigdataValue[]{s1});
        }
        finally {
            store.__tearDownUnitTest();
        }
    }
}

