/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.lexicon;

import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.TermIVComparator;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.BigdataValueFactoryImpl;
import com.bigdata.util.BytesUtil;
import java.util.Arrays;
import java.util.Comparator;
import junit.framework.TestCase2;

public class TestTermIVComparator
extends TestCase2 {
    public TestTermIVComparator() {
    }

    public TestTermIVComparator(String name) {
        super(name);
    }

    public void test_termIdComparator() {
        int i;
        TermId lmin = new TermId(VTE.URI, Long.MIN_VALUE);
        TermId lm1 = new TermId(VTE.URI, -1L);
        TermId l0 = new TermId(VTE.URI, 0L);
        TermId lp1 = new TermId(VTE.URI, 1L);
        TermId lmax = new TermId(VTE.URI, Long.MAX_VALUE);
        BigdataValueFactory f = BigdataValueFactoryImpl.getInstance((String)this.getName());
        BigdataLiteral vmin = f.createLiteral("a");
        vmin.setIV((IV)lmin);
        BigdataLiteral vm1 = f.createLiteral("b");
        vm1.setIV((IV)lm1);
        BigdataLiteral v0 = f.createLiteral("c");
        v0.setIV((IV)l0);
        BigdataLiteral vp1 = f.createLiteral("d");
        vp1.setIV((IV)lp1);
        BigdataLiteral vmax = f.createLiteral("e");
        vmax.setIV((IV)lmax);
        Object[] actualIds = new TermId[]{lm1, lmax, l0, lp1, lmin};
        Object[] expectedIds = new TermId[]{lmin, lm1, l0, lp1, lmax};
        Object[] terms = new BigdataValue[]{vmax, vm1, vmin, v0, vp1};
        byte[][] keys = new byte[actualIds.length][];
        KeyBuilder keyBuilder = new KeyBuilder(8);
        for (i = 0; i < actualIds.length; ++i) {
            keys[i] = keyBuilder.reset().append(actualIds[i].getTermId()).getKey();
        }
        Arrays.sort(keys, BytesUtil.UnsignedByteArrayComparator.INSTANCE);
        for (i = 0; i < actualIds.length; ++i) {
            if (log.isInfoEnabled()) {
                log.info((Object)BytesUtil.toString((byte[])keys[i]));
            }
            TestTermIVComparator.assertEquals((long)expectedIds[i].getTermId(), (long)KeyBuilder.decodeLong((byte[])keys[i], (int)0));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("unsorted ids  : " + Arrays.toString(actualIds)));
        }
        Arrays.sort(actualIds);
        if (log.isInfoEnabled()) {
            log.info((Object)("sorted ids    : " + Arrays.toString(actualIds)));
            log.info((Object)("expected ids  : " + Arrays.toString(expectedIds)));
        }
        TestTermIVComparator.assertEquals((String)"ids order", (Object[])expectedIds, (Object[])actualIds);
        Comparator c = TermIVComparator.INSTANCE;
        if (log.isInfoEnabled()) {
            log.info((Object)("unsorted terms: " + Arrays.toString(terms)));
        }
        Arrays.sort(terms, c);
        if (log.isInfoEnabled()) {
            log.info((Object)("sorted terms  : " + Arrays.toString(terms)));
        }
        TestTermIVComparator.assertTrue((String)"kmin<km1", (c.compare(vmin, vm1) < 0 ? 1 : 0) != 0);
        TestTermIVComparator.assertTrue((String)"km1<k0", (c.compare(vm1, v0) < 0 ? 1 : 0) != 0);
        TestTermIVComparator.assertTrue((String)"k0<kp1", (c.compare(v0, vp1) < 0 ? 1 : 0) != 0);
        TestTermIVComparator.assertTrue((String)"kp1<kmax", (c.compare(vp1, vmax) < 0 ? 1 : 0) != 0);
        TestTermIVComparator.assertTrue((String)"kmin<kmax", (c.compare(vmin, vmax) < 0 ? 1 : 0) != 0);
    }
}

