/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.lexicon;

import com.bigdata.rdf.lexicon.TermIdEncoder;
import java.util.Random;
import junit.framework.TestCase2;

public class TestTermIdEncoder
extends TestCase2 {
    public TestTermIdEncoder() {
    }

    public TestTermIdEncoder(String s) {
        super(s);
    }

    public void test_ctor_correctRejection() {
        block5: {
            block4: {
                new TermIdEncoder(0);
                new TermIdEncoder(1);
                new TermIdEncoder(30);
                new TermIdEncoder(31);
                try {
                    new TermIdEncoder(-1);
                    TestTermIdEncoder.fail((String)("Expecting: " + IllegalArgumentException.class));
                }
                catch (IllegalArgumentException ex) {
                    if (!log.isInfoEnabled()) break block4;
                    log.info((Object)("Ignoring expected exception: " + ex));
                }
            }
            try {
                new TermIdEncoder(32);
                TestTermIdEncoder.fail((String)("Expecting: " + IllegalArgumentException.class));
            }
            catch (IllegalArgumentException ex) {
                if (!log.isInfoEnabled()) break block5;
                log.info((Object)("Ignoring expected exception: " + ex));
            }
        }
    }

    public void test_encode_correctRejection() {
        block2: {
            TermIdEncoder encoder = new TermIdEncoder(1);
            try {
                encoder.encode(0L);
                TestTermIdEncoder.fail((String)("Expecting: " + IllegalArgumentException.class));
            }
            catch (IllegalArgumentException ex) {
                if (!log.isInfoEnabled()) break block2;
                log.info((Object)("Ignoring expected exception: " + ex));
            }
        }
    }

    public void test_encode_decode_0bits_pid1_ctr1() {
        TermIdEncoder encoder = new TermIdEncoder(0);
        boolean pid = true;
        boolean ctr = true;
        this.doEncodeDecodeTest(encoder, 1, 1);
    }

    public void test_encode_decode_0bits_stress() {
        Random r = new Random();
        TermIdEncoder encoder = new TermIdEncoder(0);
        for (int i = 0; i < 1000000; ++i) {
            long v2;
            long v0 = r.nextLong();
            if (v0 == 0L) continue;
            long v1 = encoder.encode(v0);
            TestTermIdEncoder.assertTrue((v1 == (v2 = encoder.encode2(v0)) ? 1 : 0) != 0);
            if (v0 == v1) continue;
            TestTermIdEncoder.fail(encoder, v0, v1);
        }
    }

    public void test_encode_decode_1bits_pid1_ctr1() {
        this.doEncodeDecodeTest(new TermIdEncoder(1), 1, 1);
    }

    public void test_encode_decode_1bits_pidMAX_ctrMAX() {
        this.doEncodeDecodeTest(new TermIdEncoder(1), Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void test_encode_decode_1bits_pidMIN_ctr0() {
        this.doEncodeDecodeTest(new TermIdEncoder(1), Integer.MIN_VALUE, 0);
    }

    public void test_encode_decode_1bits_pidm1_ctr0() {
        this.doEncodeDecodeTest(new TermIdEncoder(1), -1, 0);
    }

    public void test_encode_decode_1bits_pid0_ctrm1() {
        this.doEncodeDecodeTest(new TermIdEncoder(1), 0, -1);
    }

    public void test_encode_decode_1bits_pid0_ctrMIN() {
        this.doEncodeDecodeTest(new TermIdEncoder(1), 0, Integer.MIN_VALUE);
    }

    public void test_encode_decode_1bits_pid0_ctrMAX() {
        this.doEncodeDecodeTest(new TermIdEncoder(1), 0, Integer.MAX_VALUE);
    }

    public void test_encode_decode_1bits_pidMIN_ctrMAX() {
        this.doEncodeDecodeTest(new TermIdEncoder(1), Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public void test_encode_decode_1bits_pidMAX_ctrMIN() {
        this.doEncodeDecodeTest(new TermIdEncoder(1), Integer.MAX_VALUE, Integer.MIN_VALUE);
    }

    public void test_encode_decode_1bits_pidMIN_ctrMIN() {
        this.doEncodeDecodeTest(new TermIdEncoder(1), Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public void test_encode_decode_randomBits_stress() {
        Random r = new Random();
        for (int i = 0; i < 10000000; ++i) {
            int nbits = r.nextInt(32);
            int pid = r.nextInt();
            int ctr = r.nextInt();
            if (pid == 0 && ctr == 0) continue;
            TermIdEncoder encoder = new TermIdEncoder(nbits);
            this.doEncodeDecodeTest(encoder, pid, ctr);
        }
    }

    private void doEncodeDecodeTest(TermIdEncoder encoder, int pid, int ctr) {
        long v0 = TermIdEncoder.combine((int)pid, (int)ctr);
        TestTermIdEncoder.assertEquals((String)"pid", (int)pid, (int)TermIdEncoder.getPartitionId((long)v0));
        TestTermIdEncoder.assertEquals((String)"ctr", (int)ctr, (int)TermIdEncoder.getLocalCounter((long)v0));
        long u = encoder.encode(v0);
        long u1 = encoder.encode2(v0);
        TestTermIdEncoder.assertTrue((u == u1 ? 1 : 0) != 0);
        long v1 = encoder.decode(u);
        long v2 = encoder.decode2(u);
        TestTermIdEncoder.assertTrue((v1 == v2 ? 1 : 0) != 0);
        if (v0 != v1) {
            TestTermIdEncoder.fail(encoder, v0, v1);
        }
    }

    private static void fail(TermIdEncoder encoder, long v0, long v1) {
        String msg = encoder + "\n" + ", expected=" + v0 + " (0x" + Long.toHexString(v0) + ")\n" + ", actual=" + v1 + " (0x" + Long.toHexString(v1) + ")\n" + Long.toBinaryString(v0) + "\n" + Long.toBinaryString(v1);
        log.error((Object)msg);
        TestTermIdEncoder.fail((String)msg);
    }

    public static void main(String[] args) {
        Random r = new Random();
        long start = System.currentTimeMillis();
        for (int i = 0; i < 100000000; ++i) {
            long ev;
            int nbits = r.nextInt(32);
            int pid = r.nextInt();
            int ctr = r.nextInt();
            if (pid == 0 && ctr == 0) continue;
            TermIdEncoder encoder = new TermIdEncoder(nbits);
            long v0 = TermIdEncoder.combine((int)pid, (int)ctr);
            TestTermIdEncoder.assertTrue((v0 == encoder.decode(ev = encoder.encode(v0)) ? 1 : 0) != 0);
        }
        long split = System.currentTimeMillis();
        for (int i = 0; i < 100000000; ++i) {
            long ev;
            int nbits = r.nextInt(4);
            int pid = r.nextInt();
            int ctr = r.nextInt();
            if (pid == 0 && ctr == 0) continue;
            TermIdEncoder encoder = new TermIdEncoder(nbits);
            long v0 = TermIdEncoder.combine((int)pid, (int)ctr);
            TestTermIdEncoder.assertTrue((v0 == encoder.decode2(ev = encoder.encode2(v0)) ? 1 : 0) != 0);
        }
        long end = System.currentTimeMillis();
        System.out.println("Old code " + (split - start) + "ms vs New code " + (end - split) + "ms");
    }
}

