/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.lexicon;

import com.bigdata.io.SerializerUtil;
import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.AbstractTripleStoreTestCase;
import com.bigdata.rdf.vocab.NoVocabulary;
import com.bigdata.rdf.vocab.RDFSVocabulary;
import com.bigdata.rdf.vocab.Vocabulary;
import java.util.Properties;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;

public class TestVocabulary
extends AbstractTripleStoreTestCase {
    public TestVocabulary() {
    }

    public TestVocabulary(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_NoVocabulary() {
        Properties properties = this.getProperties();
        properties.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            Vocabulary vocab = store.getVocabulary();
            TestVocabulary.assertTrue((boolean)(vocab instanceof NoVocabulary));
            int nvalues = vocab.size();
            TestVocabulary.assertEquals((int)0, (int)nvalues);
            TestVocabulary.doRoundTripTest(vocab);
            BigdataValueFactory f = store.getValueFactory();
            TestVocabulary.assertTrue((vocab.getNamespace() == f.getNamespace() ? 1 : 0) != 0);
            BigdataURI rdfType = f.asValue(RDF.TYPE);
            BigdataURI rdfProperty = f.asValue(RDF.PROPERTY);
            BigdataURI unknownURI = f.createURI("http://www.bigdata.com/unknown");
            store.addTerms(new BigdataValue[]{rdfType, rdfProperty, unknownURI});
            TestVocabulary.assertNull((Object)vocab.get((Value)RDF.TYPE));
            TestVocabulary.assertNull((Object)vocab.get((Value)RDF.PROPERTY));
            TestVocabulary.assertNull((Object)vocab.get((Value)unknownURI));
            if (store.isStable()) {
                store = this.reopenStore(store);
                Vocabulary vocab2 = store.getVocabulary();
                TestVocabulary.assertSameVocabulary(vocab, vocab2);
            }
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_RdfsVocabulary() {
        Properties properties = this.getProperties();
        properties.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, RDFSVocabulary.class.getName());
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            Vocabulary vocab = store.getVocabulary();
            TestVocabulary.assertTrue((boolean)(vocab instanceof RDFSVocabulary));
            TestVocabulary.doRoundTripTest(vocab);
            BigdataValueFactory f = store.getValueFactory();
            BigdataURI rdfType = f.asValue(RDF.TYPE);
            BigdataURI rdfProperty = f.asValue(RDF.PROPERTY);
            BigdataURI unknownURI = f.createURI("http://www.bigdata.com/unknown");
            store.addTerms(new BigdataValue[]{rdfType, rdfProperty, unknownURI});
            TestVocabulary.assertEquals((Object)rdfType.getIV(), (Object)vocab.get((Value)RDF.TYPE));
            TestVocabulary.assertEquals((Object)rdfProperty.getIV(), (Object)vocab.get((Value)RDF.PROPERTY));
            TestVocabulary.assertNull((Object)vocab.get((Value)unknownURI));
            if (store.isStable()) {
                store = this.reopenStore(store);
                Vocabulary vocab2 = store.getVocabulary();
                TestVocabulary.assertSameVocabulary(vocab, vocab2);
            }
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    static void doRoundTripTest(Vocabulary expected) {
        byte[] data = SerializerUtil.serialize((Object)expected);
        Vocabulary actual = (Vocabulary)SerializerUtil.deserialize((byte[])data);
        TestVocabulary.assertSameVocabulary(expected, actual);
    }

    protected static void assertSameVocabulary(Vocabulary expected, Vocabulary actual) {
        com.bigdata.rdf.vocab.TestVocabulary.assertSameVocabulary(expected, actual);
    }
}

