/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.load;

import com.bigdata.io.SerializerUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import junit.framework.TestCase2;

public class TestLockDeserialization
extends TestCase2 {
    public TestLockDeserialization() {
    }

    public TestLockDeserialization(String name) {
        super(name);
    }

    public void test_serialization() {
        C expected = new C(1);
        C actual = (C)SerializerUtil.deserialize((byte[])SerializerUtil.serialize((Object)expected));
        TestLockDeserialization.assertTrue((expected != actual ? 1 : 0) != 0);
        TestLockDeserialization.assertEquals((String)"state", (int)expected.state, (int)actual.state);
        TestLockDeserialization.assertEquals((String)"condVar", (boolean)expected.condVar, (boolean)actual.condVar);
        TestLockDeserialization.assertNotNull((Object)actual.lock);
        TestLockDeserialization.assertNotNull((Object)actual.cond);
        TestLockDeserialization.assertTrue((expected.lock != actual.lock ? 1 : 0) != 0);
    }

    private static class C
    implements Serializable {
        private final int state;
        private transient Lock lock;
        private transient Condition cond;
        private boolean condVar = false;

        public C(int state) {
            this.state = state;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            log.info((Object)"Overriding readObject.");
            in.defaultReadObject();
            this.lock = new ReentrantLock();
            this.cond = this.lock.newCondition();
        }
    }
}

