/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.model;

import com.bigdata.io.SerializerUtil;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.BigdataValueFactoryImpl;
import com.bigdata.rdf.model.BigdataValueSerializer;
import java.util.UUID;
import junit.framework.TestCase2;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.vocabulary.XMLSchema;

public class TestBigdataValueSerialization
extends TestCase2 {
    private BigdataValueSerializer<Value> fixture = null;

    public TestBigdataValueSerialization() {
    }

    public TestBigdataValueSerialization(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fixture = new BigdataValueSerializer((ValueFactory)ValueFactoryImpl.getInstance());
    }

    protected void tearDown() throws Exception {
        this.fixture = null;
        super.tearDown();
    }

    private Value roundTrip_tuned(Value o) {
        return this.fixture.deserialize(this.fixture.serialize(o));
    }

    public void test_URIs() {
        URIImpl a = new URIImpl("http://www.bigdata.com");
        TestBigdataValueSerialization.assertEquals((Object)a, (Object)this.roundTrip_tuned((Value)a));
    }

    public void test_plainLiterals() {
        LiteralImpl a = new LiteralImpl("bigdata");
        TestBigdataValueSerialization.assertEquals((Object)a, (Object)this.roundTrip_tuned((Value)a));
    }

    public void test_langCodeLiterals() {
        LiteralImpl a = new LiteralImpl("bigdata", "en");
        TestBigdataValueSerialization.assertEquals((Object)a, (Object)this.roundTrip_tuned((Value)a));
    }

    public void test_dataTypeLiterals() {
        LiteralImpl a = new LiteralImpl("bigdata", XMLSchema.INT);
        TestBigdataValueSerialization.assertEquals((Object)a, (Object)this.roundTrip_tuned((Value)a));
    }

    public void test_bnodes() {
        BNodeImpl a = new BNodeImpl(UUID.randomUUID().toString());
        TestBigdataValueSerialization.assertEquals((Object)a, (Object)this.roundTrip_tuned((Value)a));
    }

    public void test_roundTrip_URI() {
        this.doRoundTripTest((Value)new URIImpl("http://www.bigdata.com"));
    }

    public void test_roundTrip_BNode() {
        this.doRoundTripTest((Value)new BNodeImpl("12"));
        this.doRoundTripTest((Value)new BNodeImpl(UUID.randomUUID().toString()));
    }

    public void test_roundTrip_plainLiteral() {
        this.doRoundTripTest((Value)new LiteralImpl("bigdata"));
    }

    public void test_roundTrip_langCodeLiterals() {
        this.doRoundTripTest((Value)new LiteralImpl("bigdata", "en"));
    }

    public void test_roundTrip_xsd_string() {
        this.doRoundTripTest((Value)new LiteralImpl("bigdata", XMLSchema.STRING));
    }

    public void test_roundTrip_xsd_int() {
        this.doRoundTripTest((Value)new LiteralImpl("12", XMLSchema.INT));
    }

    public void test_roundTrip_veryLargeLiteral() {
        int len = 1024000;
        StringBuilder sb = new StringBuilder(1024000);
        for (int i = 0; i < 1024000; ++i) {
            sb.append(Character.toChars(65 + i % 26));
        }
        String s = sb.toString();
        if (log.isInfoEnabled()) {
            log.info((Object)("length(s)=" + s.length()));
        }
        this.doRoundTripTest((Value)new LiteralImpl(s));
    }

    private void doRoundTripTest(Value v) {
        String namespace = this.getName();
        BigdataValueFactory f = BigdataValueFactoryImpl.getInstance((String)namespace);
        TestBigdataValueSerialization.assertTrue((f == BigdataValueFactoryImpl.getInstance((String)namespace) ? 1 : 0) != 0);
        BigdataValue expected = f.asValue(v);
        TestBigdataValueSerialization.assertTrue((f == expected.getValueFactory() ? 1 : 0) != 0);
        BigdataValue actual1 = this.doDefaultJavaSerializationTest(expected);
        TestBigdataValueSerialization.assertTrue((f == actual1.getValueFactory() ? 1 : 0) != 0);
        BigdataValue actual2 = this.doBigdataValueSerializationTest(expected);
        TestBigdataValueSerialization.assertTrue((f == actual2.getValueFactory() ? 1 : 0) != 0);
    }

    private BigdataValue doDefaultJavaSerializationTest(BigdataValue expected) {
        byte[] data = SerializerUtil.serialize((Object)expected);
        BigdataValue actual = (BigdataValue)SerializerUtil.deserialize((byte[])data);
        TestBigdataValueSerialization.assertTrue((boolean)expected.equals(actual));
        return actual;
    }

    private BigdataValue doBigdataValueSerializationTest(BigdataValue expected) {
        BigdataValueSerializer ser = expected.getValueFactory().getValueSerializer();
        byte[] data = ser.serialize((Value)expected);
        BigdataValue actual = (BigdataValue)ser.deserialize(data);
        TestBigdataValueSerialization.assertTrue((boolean)expected.equals(actual));
        return actual;
    }
}

