/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.model;

import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.model.BigdataBNode;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.BigdataValueFactoryImpl;
import junit.framework.TestCase;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.vocabulary.XMLSchema;

public class TestEquals
extends TestCase {
    public TestEquals() {
    }

    public TestEquals(String name) {
        super(name);
    }

    public void test_equalsURI() {
        BigdataValueFactory vf = BigdataValueFactoryImpl.getInstance((String)this.getName());
        BigdataValueFactory vf2 = BigdataValueFactoryImpl.getInstance((String)(this.getName() + "2"));
        BigdataURI v1 = vf.createURI("http://www.bigdata.com");
        BigdataURI v2 = vf.createURI("http://www.bigdata.com");
        URIImpl v3 = new URIImpl("http://www.bigdata.com");
        BigdataURI v4 = vf2.createURI("http://www.bigdata.com");
        TestEquals.assertTrue((v1 != v2 ? 1 : 0) != 0);
        TestEquals.assertTrue((boolean)v1.equals(v2));
        TestEquals.assertTrue((boolean)v2.equals(v1));
        TestEquals.assertTrue((boolean)v3.equals((Object)v1));
        TestEquals.assertTrue((boolean)v3.equals((Object)v2));
        TestEquals.assertTrue((boolean)v1.equals(v3));
        TestEquals.assertTrue((boolean)v2.equals(v3));
        TestEquals.assertTrue((boolean)v1.equals(v4));
        TestEquals.assertTrue((boolean)v4.equals(v1));
        TestEquals.assertTrue((boolean)v2.equals(v4));
        TestEquals.assertTrue((boolean)v4.equals(v2));
        v2.setIV((IV)TermId.mockIV((VTE)VTE.URI));
        TestEquals.assertTrue((boolean)v1.equals(v2));
        TestEquals.assertTrue((boolean)v2.equals(v1));
        TestEquals.assertTrue((boolean)v3.equals((Object)v1));
        TestEquals.assertTrue((boolean)v3.equals((Object)v2));
        TestEquals.assertTrue((boolean)v1.equals(v3));
        TestEquals.assertTrue((boolean)v2.equals(v3));
        TestEquals.assertTrue((boolean)v1.equals(v4));
        TestEquals.assertTrue((boolean)v4.equals(v1));
        TestEquals.assertTrue((boolean)v2.equals(v4));
        TestEquals.assertTrue((boolean)v4.equals(v2));
        v1.setIV((IV)new TermId(VTE.URI, 1L));
        TestEquals.assertTrue((boolean)v1.equals(v2));
        TestEquals.assertTrue((boolean)v2.equals(v1));
        TestEquals.assertTrue((boolean)v3.equals((Object)v1));
        TestEquals.assertTrue((boolean)v3.equals((Object)v2));
        TestEquals.assertTrue((boolean)v1.equals(v3));
        TestEquals.assertTrue((boolean)v2.equals(v3));
        TestEquals.assertTrue((boolean)v1.equals(v4));
        TestEquals.assertTrue((boolean)v4.equals(v1));
        TestEquals.assertTrue((boolean)v2.equals(v4));
        TestEquals.assertTrue((boolean)v4.equals(v2));
    }

    public void test_equalsLiteral() {
        this.doLiteralTest("bigdata", null, null);
        this.doLiteralTest("bigdata", XMLSchema.STRING, null);
        this.doLiteralTest("bigdata", null, "en");
    }

    private Literal createLiteral(ValueFactory f, String label, URI datatype, String languageCode) {
        if (datatype == null && languageCode == null) {
            return f.createLiteral(label);
        }
        if (datatype == null) {
            return f.createLiteral(label, languageCode);
        }
        return f.createLiteral(label, datatype);
    }

    private void doLiteralTest(String label, URI datatype, String languageCode) {
        BigdataValueFactory vf = BigdataValueFactoryImpl.getInstance((String)this.getName());
        BigdataValueFactory vf2 = BigdataValueFactoryImpl.getInstance((String)(this.getName() + "2"));
        BigdataLiteral v1 = (BigdataLiteral)this.createLiteral((ValueFactory)vf, label, datatype, languageCode);
        BigdataLiteral v2 = (BigdataLiteral)this.createLiteral((ValueFactory)vf, label, datatype, languageCode);
        Literal v3 = this.createLiteral((ValueFactory)new ValueFactoryImpl(), label, datatype, languageCode);
        BigdataLiteral v4 = (BigdataLiteral)this.createLiteral((ValueFactory)vf2, label, datatype, languageCode);
        TestEquals.assertTrue((v1 != v2 ? 1 : 0) != 0);
        TestEquals.assertTrue((boolean)v1.equals(v2));
        TestEquals.assertTrue((boolean)v2.equals(v1));
        TestEquals.assertTrue((boolean)v3.equals((Object)v1));
        TestEquals.assertTrue((boolean)v3.equals((Object)v2));
        TestEquals.assertTrue((boolean)v1.equals(v3));
        TestEquals.assertTrue((boolean)v2.equals(v3));
        TestEquals.assertTrue((boolean)v1.equals(v4));
        TestEquals.assertTrue((boolean)v4.equals(v1));
        TestEquals.assertTrue((boolean)v2.equals(v4));
        TestEquals.assertTrue((boolean)v4.equals(v2));
        v2.setIV((IV)TermId.mockIV((VTE)VTE.LITERAL));
        TestEquals.assertTrue((boolean)v1.equals(v2));
        TestEquals.assertTrue((boolean)v2.equals(v1));
        TestEquals.assertTrue((boolean)v3.equals((Object)v1));
        TestEquals.assertTrue((boolean)v3.equals((Object)v2));
        TestEquals.assertTrue((boolean)v1.equals(v3));
        TestEquals.assertTrue((boolean)v2.equals(v3));
        TestEquals.assertTrue((boolean)v1.equals(v4));
        TestEquals.assertTrue((boolean)v4.equals(v1));
        TestEquals.assertTrue((boolean)v2.equals(v4));
        TestEquals.assertTrue((boolean)v4.equals(v2));
        v1.setIV((IV)new TermId(VTE.LITERAL, 1L));
        TestEquals.assertTrue((boolean)v1.equals(v2));
        TestEquals.assertTrue((boolean)v2.equals(v1));
        TestEquals.assertTrue((boolean)v3.equals((Object)v1));
        TestEquals.assertTrue((boolean)v3.equals((Object)v2));
        TestEquals.assertTrue((boolean)v1.equals(v3));
        TestEquals.assertTrue((boolean)v2.equals(v3));
        TestEquals.assertTrue((boolean)v1.equals(v4));
        TestEquals.assertTrue((boolean)v4.equals(v1));
        TestEquals.assertTrue((boolean)v2.equals(v4));
        TestEquals.assertTrue((boolean)v4.equals(v2));
    }

    public void test_equalsBNode() {
        BigdataValueFactory vf = BigdataValueFactoryImpl.getInstance((String)this.getName());
        BigdataValueFactory vf2 = BigdataValueFactoryImpl.getInstance((String)(this.getName() + "2"));
        BigdataBNode v1 = vf.createBNode("bigdata");
        BigdataBNode v2 = vf.createBNode("bigdata");
        BNodeImpl v3 = new BNodeImpl("bigdata");
        BigdataBNode v4 = vf2.createBNode("bigdata");
        TestEquals.assertTrue((v1 != v2 ? 1 : 0) != 0);
        TestEquals.assertTrue((boolean)v1.equals(v2));
        TestEquals.assertTrue((boolean)v2.equals(v1));
        TestEquals.assertTrue((boolean)v3.equals((Object)v1));
        TestEquals.assertTrue((boolean)v3.equals((Object)v2));
        TestEquals.assertTrue((boolean)v1.equals(v3));
        TestEquals.assertTrue((boolean)v2.equals(v3));
        TestEquals.assertTrue((boolean)v1.equals(v4));
        TestEquals.assertTrue((boolean)v4.equals(v1));
        TestEquals.assertTrue((boolean)v2.equals(v4));
        TestEquals.assertTrue((boolean)v4.equals(v2));
        v2.setIV((IV)TermId.mockIV((VTE)VTE.BNODE));
        TestEquals.assertTrue((boolean)v1.equals(v2));
        TestEquals.assertTrue((boolean)v2.equals(v1));
        TestEquals.assertTrue((boolean)v3.equals((Object)v1));
        TestEquals.assertTrue((boolean)v3.equals((Object)v2));
        TestEquals.assertTrue((boolean)v1.equals(v3));
        TestEquals.assertTrue((boolean)v2.equals(v3));
        TestEquals.assertTrue((boolean)v1.equals(v4));
        TestEquals.assertTrue((boolean)v4.equals(v1));
        TestEquals.assertTrue((boolean)v2.equals(v4));
        TestEquals.assertTrue((boolean)v4.equals(v2));
        v1.setIV((IV)new TermId(VTE.BNODE, 1L));
        TestEquals.assertTrue((boolean)v1.equals(v2));
        TestEquals.assertTrue((boolean)v2.equals(v1));
        TestEquals.assertTrue((boolean)v3.equals((Object)v1));
        TestEquals.assertTrue((boolean)v3.equals((Object)v2));
        TestEquals.assertTrue((boolean)v1.equals(v3));
        TestEquals.assertTrue((boolean)v2.equals(v3));
        TestEquals.assertTrue((boolean)v1.equals(v4));
        TestEquals.assertTrue((boolean)v4.equals(v1));
        TestEquals.assertTrue((boolean)v2.equals(v4));
        TestEquals.assertTrue((boolean)v4.equals(v2));
    }
}

