/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.model;

import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.BigdataValueFactoryImpl;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import junit.framework.TestCase2;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class TestFactory
extends TestCase2 {
    private BigdataValueFactory vf;

    public TestFactory() {
    }

    public TestFactory(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.vf = BigdataValueFactoryImpl.getInstance((String)this.getName());
    }

    protected void tearDown() throws Exception {
        this.vf = null;
        super.tearDown();
    }

    public void test_create_literal_xsdInt() {
        BigdataLiteral l1 = this.vf.createLiteral("12", XSD.INT);
        TestFactory.assertEquals((Object)XSD.INT, (Object)l1.getDatatype());
        TestFactory.assertEquals((int)12, (int)l1.intValue());
    }

    public void test_create_xsdInt_canonical() {
        BigdataURI v1 = this.vf.createURI(XSD.INT.stringValue());
        BigdataURI v2 = this.vf.createURI(XSD.INT.stringValue());
        TestFactory.assertEquals((String)v1.stringValue(), (String)XSD.INT.stringValue());
        TestFactory.assertTrue((v1 == v2 ? 1 : 0) != 0);
    }

    public void test_create_literal_datatypeIsNull() {
        BigdataLiteral l1 = this.vf.createLiteral("12", (URI)null);
        TestFactory.assertEquals(null, (Object)l1.getDatatype());
        TestFactory.assertEquals((int)12, (int)l1.intValue());
    }

    public void test_gregorian() throws DatatypeConfigurationException {
        XMLGregorianCalendar cal = DatatypeFactory.newInstance().newXMLGregorianCalendarDate(2010, 1, 13, 0);
        TestFactory.assertEquals((String)"http://www.w3.org/2001/XMLSchema#date", (String)this.vf.createLiteral(cal).getDatatype().stringValue());
    }

    public void test_asValue_mockIV() {
        BigdataURI v1 = this.vf.createURI("http://www.bigdata.com");
        BigdataValue v2 = this.vf.asValue((Value)v1);
        v1.setIV((IV)TermId.mockIV((VTE)VTE.URI));
        BigdataValue v3 = this.vf.asValue((Value)v1);
        TestFactory.assertTrue((v2 == v1 ? 1 : 0) != 0);
        TestFactory.assertTrue((v3 != v1 ? 1 : 0) != 0);
    }
}

