/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rio;

import com.bigdata.rdf.load.IStatementBufferFactory;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.rio.PresortRioLoader;
import com.bigdata.rdf.rio.RDFParserOptions;
import com.bigdata.rdf.rio.RioLoaderEvent;
import com.bigdata.rdf.rio.RioLoaderListener;
import com.bigdata.rdf.store.AbstractTestCase;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.AbstractTripleStoreTestCase;
import com.bigdata.service.IBigdataFederation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.openrdf.rio.RDFFormat;

public abstract class AbstractRIOTestCase
extends AbstractTripleStoreTestCase {
    public AbstractRIOTestCase() {
    }

    public AbstractRIOTestCase(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLoadAndVerifyTest(String resource, boolean parallel) throws Exception {
        AbstractTripleStore store = this.getStore();
        try {
            this.doLoad(store, resource, parallel);
            store.commit();
            if (store.isStable()) {
                store = this.reopenStore(store);
            }
            this.doVerify(store, resource, parallel);
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    protected abstract void doLoad(AbstractTripleStore var1, String var2, boolean var3) throws Exception;

    protected void doLoad(AbstractTripleStore store, String resource, boolean parallel, IStatementBufferFactory<BigdataStatement> factory) throws Exception {
        List<Callable<Void>> tasks = this.getLoadTasks(resource, factory);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will run " + tasks.size() + " load tasks."));
        }
        if (parallel) {
            List<Future<Void>> futures = store.getExecutorService().invokeAll(tasks);
            for (Future<Void> f : futures) {
                f.get();
            }
        } else {
            for (Callable<Void> t : tasks) {
                t.call();
            }
        }
    }

    protected List<Callable<Void>> getLoadTasks(String resource, IStatementBufferFactory<BigdataStatement> factory) {
        LinkedList<Callable<Void>> tasks = new LinkedList<Callable<Void>>();
        if (((Object)((Object)this)).getClass().getResource(resource) != null) {
            tasks.add(new LoadTask(resource, factory));
            return tasks;
        }
        URL u = ((Object)((Object)this)).getClass().getClassLoader().getResource(resource);
        if (u != null) {
            tasks.add(new LoadTask(u.getFile(), factory));
            return tasks;
        }
        File file = new File(resource);
        if (!file.exists()) {
            throw new AssertionFailedError("Resource not found: " + file + ", test skipped: " + this.getName());
        }
        this.addFileLoadTask(file, tasks, factory);
        return tasks;
    }

    private void addFileLoadTask(File file, List<Callable<Void>> tasks, IStatementBufferFactory<BigdataStatement> factory) {
        if (file.isHidden()) {
            log.warn((Object)("Skipping hidden file: " + file));
            return;
        }
        if (!file.canRead()) {
            log.warn((Object)("Can not read file: " + file));
            return;
        }
        if (file.isDirectory()) {
            File[] files;
            if (log.isInfoEnabled()) {
                log.info((Object)("Loading directory: " + file));
            }
            for (File t : files = file.listFiles()) {
                this.addFileLoadTask(t, tasks, factory);
            }
            return;
        }
        tasks.add(new LoadTask(file.toString(), factory));
    }

    protected void doVerify(AbstractTripleStore store, String resource, boolean parallel) {
        List<Callable<Void>> tasks = this.getVerifyTasks(resource, store);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will run " + tasks.size() + " verify tasks."));
        }
        try {
            if (parallel) {
                List<Future<Void>> futures = store.getExecutorService().invokeAll(tasks);
                for (Future<Void> f : futures) {
                    f.get();
                }
            } else {
                for (Callable<Void> t : tasks) {
                    t.call();
                }
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    protected List<Callable<Void>> getVerifyTasks(String resource, AbstractTripleStore store) {
        LinkedList<Callable<Void>> tasks = new LinkedList<Callable<Void>>();
        if (((Object)((Object)this)).getClass().getResource(resource) != null || ((Object)((Object)this)).getClass().getClassLoader().getResource(resource) != null) {
            tasks.add(new VerifyTask(resource, store));
            return tasks;
        }
        File file = new File(resource);
        if (!file.exists()) {
            throw new RuntimeException("No such resource/file: " + resource);
        }
        this.addFileVerifyTask(file, tasks, store);
        return tasks;
    }

    private void addFileVerifyTask(File file, List<Callable<Void>> tasks, AbstractTripleStore store) {
        if (file.isHidden()) {
            log.warn((Object)("Skipping hidden file: " + file));
            return;
        }
        if (!file.canRead()) {
            log.warn((Object)("Can not read file: " + file));
            return;
        }
        if (file.isDirectory()) {
            File[] files;
            if (log.isInfoEnabled()) {
                log.info((Object)("Loading directory: " + file));
            }
            for (File t : files = file.listFiles()) {
                this.addFileVerifyTask(t, tasks, store);
            }
            return;
        }
        tasks.add(new VerifyTask(file.toString(), store));
    }

    private static class VerifyTask
    implements Callable<Void> {
        private final String resource;
        private final AbstractTripleStore store;

        public VerifyTask(String resource, AbstractTripleStore store) {
            if (resource == null) {
                throw new IllegalArgumentException();
            }
            if (store == null) {
                throw new IllegalArgumentException();
            }
            this.resource = resource;
            this.store = store;
        }

        @Override
        public Void call() throws Exception {
            if (log.isInfoEnabled()) {
                log.info((Object)("Will verify: " + this.resource));
            }
            this.verify();
            return null;
        }

        private void verify() throws FileNotFoundException, Exception {
            String baseURI;
            if (log.isInfoEnabled()) {
                log.info((Object)"computing predicate usage...");
            }
            AtomicInteger nerrs = new AtomicInteger(0);
            int maxerrors = 20;
            if (log.isInfoEnabled()) {
                log.info((Object)("Verifying all statements found using reparse: file=" + this.resource));
            }
            InputStream is = null;
            if (this.getClass().getResource(this.resource) != null) {
                baseURI = this.getClass().getResource(this.resource).toURI().toString();
                is = this.getClass().getResourceAsStream(this.resource);
            } else if (this.getClass().getClassLoader().getResource(this.resource) != null) {
                baseURI = this.getClass().getClassLoader().getResource(this.resource).toURI().toString();
                is = this.getClass().getClassLoader().getResourceAsStream(this.resource);
            } else {
                baseURI = new File(this.resource).toURI().toString();
                is = new FileInputStream(this.resource);
            }
            int capacity = 100000;
            AbstractTestCase.StatementVerifier loader = new AbstractTestCase.StatementVerifier(this.store, 100000, nerrs, 20);
            RDFFormat rdfFormat = RDFFormat.forFileName((String)this.resource);
            RDFParserOptions options = new RDFParserOptions();
            options.setVerifyData(false);
            loader.loadRdf(new BufferedReader(new InputStreamReader(is)), baseURI, rdfFormat, null, options);
            if (log.isInfoEnabled()) {
                log.info((Object)("End of reparse: nerrors=" + nerrs + ", file=" + this.resource));
            }
            TestCase.assertEquals((String)"nerrors", (int)0, (int)nerrs.get());
            if (this.store.getIndexManager() instanceof IBigdataFederation) {
                log.warn((Object)"Not checking indices in scale-out : code is not efficient.");
            } else {
                AbstractTestCase.assertLexiconIndicesConsistent(this.store);
            }
            AbstractTestCase.assertStatementIndicesConsistent(this.store, 20);
        }
    }

    private static class LoadTask
    implements Callable<Void> {
        private final String resource;
        private final IStatementBufferFactory<BigdataStatement> factory;

        public LoadTask(String resource, IStatementBufferFactory<BigdataStatement> factory) {
            if (resource == null) {
                throw new IllegalArgumentException();
            }
            if (factory == null) {
                throw new IllegalArgumentException();
            }
            this.resource = resource;
            this.factory = factory;
        }

        @Override
        public Void call() throws Exception {
            this.loadOne(this.resource, this.factory);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void loadOne(String resource, IStatementBufferFactory<? extends BigdataStatement> factory) throws IOException, URISyntaxException {
            if (log.isInfoEnabled()) {
                log.info((Object)("Loading: " + resource + " using " + factory));
            }
            String baseURI = null;
            InputStream rdfStream = null;
            try {
                rdfStream = this.getClass().getResourceAsStream(resource);
                if (rdfStream == null) {
                    rdfStream = this.getClass().getClassLoader().getResourceAsStream(resource);
                }
                if (rdfStream != null) {
                    baseURI = this.getClass().getResource(resource).toURI().toString();
                } else {
                    File file = new File(resource);
                    if (file.exists()) {
                        rdfStream = new FileInputStream(file);
                        baseURI = file.toURI().toString();
                    } else {
                        TestCase.fail((String)("Could not locate resource: " + resource));
                    }
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(rdfStream));
                try {
                    RDFFormat rdfFormat = RDFFormat.forFileName((String)resource);
                    RDFParserOptions options = new RDFParserOptions();
                    options.setVerifyData(true);
                    PresortRioLoader loader = new PresortRioLoader(factory.newStatementBuffer());
                    loader.addRioLoaderListener(new RioLoaderListener(){

                        public void processingNotification(RioLoaderEvent e) {
                            if (log.isInfoEnabled()) {
                                log.info((Object)(e.getStatementsProcessed() + " stmts added in " + (double)e.getTimeElapsed() / 1000.0 + " secs, rate= " + e.getInsertRate()));
                            }
                        }
                    });
                    loader.loadRdf((Reader)reader, baseURI, rdfFormat, baseURI, options);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Done: " + resource));
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException("While loading: " + resource, ex);
                }
                finally {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable t) {
                        log.error((Object)t);
                    }
                }
            }
            finally {
                if (rdfStream != null) {
                    try {
                        rdfStream.close();
                    }
                    catch (Throwable t) {
                        log.error((Object)t);
                    }
                }
            }
        }
    }
}

