/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rio;

import com.bigdata.journal.IIndexManager;
import com.bigdata.rdf.load.RDFFilenameFilter;
import com.bigdata.rdf.rio.AsynchronousStatementBufferFactory;
import com.bigdata.rdf.rio.RDFParserOptions;
import com.bigdata.rdf.store.ScaleOutTripleStore;
import com.bigdata.service.EmbeddedClient;
import com.bigdata.service.EmbeddedFederation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Properties;
import org.openrdf.rio.RDFFormat;

public class EDSAsyncLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            System.err.println("usage: propertyFile  namespace fileOrDirectory");
            System.exit(1);
        }
        File propertyFile = new File(args[0]);
        String namespace = args[1];
        File resource = new File(args[2]);
        if (!resource.exists()) {
            throw new FileNotFoundException(resource.toString());
        }
        Properties properties = new Properties();
        try (FileInputStream is = new FileInputStream(propertyFile);){
            properties.load(is);
            properties.list(System.out);
        }
        int producerChunkSize = 20000;
        int valuesInitialCapacity = 10000;
        int bnodesInitialCapacity = 16;
        long unbufferedStatementThreshold = 5000L;
        long rejectedExecutionDelay = 250L;
        int poolSize = 5;
        EmbeddedClient client = new EmbeddedClient(properties);
        EmbeddedFederation fed = client.connect();
        try {
            System.out.println("Opening KB: namespace=" + namespace);
            ScaleOutTripleStore tripleStore = (ScaleOutTripleStore)fed.getResourceLocator().locate(namespace, 0L);
            if (tripleStore == null) {
                System.out.println("Creating new KB: namespace=" + namespace);
                tripleStore = new ScaleOutTripleStore((IIndexManager)fed, namespace, Long.valueOf(0L), properties);
                tripleStore.create();
            }
            RDFParserOptions parserOptions = new RDFParserOptions();
            if (tripleStore.getLexiconRelation().isStoreBlankNodes()) {
                parserOptions.setPreserveBNodeIDs(true);
            }
            AsynchronousStatementBufferFactory statementBufferFactory = new AsynchronousStatementBufferFactory(tripleStore, 20000, 10000, 16, RDFFormat.RDFXML, null, parserOptions, false, 5, 20, 5, 5, 5, 5000L);
            try {
                System.out.println("Loading: " + resource);
                if (resource.isDirectory()) {
                    statementBufferFactory.submitAll(resource, (FilenameFilter)new RDFFilenameFilter(), 250L);
                } else {
                    statementBufferFactory.submitOne((Object)resource);
                }
                System.out.println("Awaiting completion.");
                statementBufferFactory.awaitAll();
                System.err.println(fed.getServiceCounterSet().getPath("Indices").toString());
                System.err.println(statementBufferFactory.getCounters().toString());
                System.out.println("Done.");
            }
            catch (Throwable t) {
                statementBufferFactory.cancelAll(true);
                throw new RuntimeException(t);
            }
        }
        finally {
            client.disconnect(true);
        }
        System.exit(0);
    }
}

