/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rio;

import com.bigdata.btree.IndexMetadata;
import com.bigdata.config.Configuration;
import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.lexicon.BigdataValueCentricFullTextIndex;
import com.bigdata.rdf.lexicon.LexiconKeyOrder;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.load.RDFFilenameFilter;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.rio.AbstractRIOTestCase;
import com.bigdata.rdf.rio.AsynchronousStatementBufferFactory;
import com.bigdata.rdf.rio.RDFParserOptions;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.ScaleOutTripleStore;
import com.bigdata.rdf.util.DumpLexicon;
import com.bigdata.service.AbstractScaleOutFederation;
import com.bigdata.service.EmbeddedClient;
import com.bigdata.service.IBigdataClient;
import com.bigdata.striterator.IKeyOrder;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.openrdf.rio.RDFFormat;

public class TestAsynchronousStatementBufferFactory
extends AbstractRIOTestCase {
    private static final int chunkSize = 20000;
    private static final int valuesInitialCapacity = 10000;
    private static final int bnodesInitialCapacity = 16;
    private static final long unbufferedStatementThreshold = 5000L;
    private static final long rejectedExecutionDelay = 250L;
    private static final boolean parallel = true;

    public TestAsynchronousStatementBufferFactory() {
    }

    public TestAsynchronousStatementBufferFactory(String name) {
        super(name);
    }

    @Override
    public Properties getProperties() {
        Properties properties = new Properties(super.getProperties());
        properties.setProperty(IBigdataClient.Options.REPORT_DELAY, "0");
        properties.setProperty(IBigdataClient.Options.COLLECT_QUEUE_STATISTICS, "false");
        properties.setProperty(IBigdataClient.Options.COLLECT_PLATFORM_STATISTICS, "false");
        properties.setProperty(EmbeddedClient.Options.NDATA_SERVICES, "1");
        properties.setProperty("10", "0");
        properties.setProperty(AbstractTripleStore.Options.TEXT_INDEX, "true");
        properties.setProperty(AbstractTripleStore.Options.STATEMENT_IDENTIFIERS, "false");
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        properties.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, AbstractTripleStore.Options.DEFAULT_VOCABULARY_CLASS);
        String namespace = "test1";
        String pname = Configuration.getOverrideProperty((String)("test1.lex." + LexiconKeyOrder.TERM2ID), (String)IndexMetadata.Options.SINK_IDLE_TIMEOUT_NANOS);
        String pval = "" + TimeUnit.SECONDS.toNanos(1L);
        if (log.isInfoEnabled()) {
            log.info((Object)("Override: " + pname + "=" + pval));
        }
        properties.setProperty(pname, pval);
        pname = Configuration.getOverrideProperty((String)("test1.lex." + LexiconKeyOrder.BLOBS), (String)IndexMetadata.Options.SINK_IDLE_TIMEOUT_NANOS);
        pval = "" + TimeUnit.SECONDS.toNanos(1L);
        if (log.isInfoEnabled()) {
            log.info((Object)("Override: " + pname + "=" + pval));
        }
        properties.setProperty(pname, pval);
        return properties;
    }

    public void test_loadAndVerify_small() throws Exception {
        String resource = "/com/bigdata/rdf/rio/small.rdf";
        this.doLoadAndVerifyTest("/com/bigdata/rdf/rio/small.rdf", this.getProperties());
    }

    public void test_loadAndVerify_small_quadsMode() throws Exception {
        String resource = "/com/bigdata/rdf/rio/small.rdf";
        Properties p = this.getProperties();
        p.setProperty(AbstractTripleStore.Options.QUADS, "true");
        this.doLoadAndVerifyTest("/com/bigdata/rdf/rio/small.rdf", p);
    }

    public void test_loadAndVerify_little_ttl_quadsMode() throws Exception {
        String resource = "/com/bigdata/rdf/rio/little.ttl";
        Properties p = this.getProperties();
        p.setProperty(AbstractTripleStore.Options.QUADS, "true");
        this.doLoadAndVerifyTest("/com/bigdata/rdf/rio/little.ttl", p);
    }

    public void test_loadAndVerify_little_trig_quadsMode() throws Exception {
        String resource = "/com/bigdata/rdf/rio/little.trig";
        Properties p = this.getProperties();
        p.setProperty(AbstractTripleStore.Options.QUADS, "true");
        this.doLoadAndVerifyTest("/com/bigdata/rdf/rio/little.trig", p);
    }

    public void test_loadAndVerify_smallWithBlobs() throws Exception {
        String resource = "/com/bigdata/rdf/rio/smallWithBlobs.rdf";
        this.doLoadAndVerifyTest("/com/bigdata/rdf/rio/smallWithBlobs.rdf", this.getProperties());
    }

    public void test_loadAndVerify_smallWithBlobs_quadsMode() throws Exception {
        String resource = "/com/bigdata/rdf/rio/smallWithBlobs.rdf";
        Properties p = this.getProperties();
        p.setProperty(AbstractTripleStore.Options.QUADS, "true");
        this.doLoadAndVerifyTest("/com/bigdata/rdf/rio/smallWithBlobs.rdf", p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_loadFails() throws Exception {
        String resource = "/com/bigdata/rdf/rio/broken.rdf";
        AbstractTripleStore store = this.getStore();
        try {
            if (!(store.getIndexManager() instanceof AbstractScaleOutFederation)) {
                log.warn((Object)"Test requires scale-out index views.");
                return;
            }
            if (store.isQuads()) {
                log.warn((Object)"Quads not supported yet.");
                return;
            }
            AsynchronousStatementBufferFactory<BigdataStatement, File> factory = this.doLoad2(store, new File("/com/bigdata/rdf/rio/broken.rdf"), true);
            TestAsynchronousStatementBufferFactory.assertEquals((String)"errorCount", (long)1L, (long)factory.getDocumentErrorCount());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    public void test_loadAndVerify_sampleData() throws Exception {
        String resource = "/com/bigdata/rdf/rio/sample data.rdf";
        this.doLoadAndVerifyTest("/com/bigdata/rdf/rio/sample data.rdf", this.getProperties());
    }

    public void test_loadAndVerify_sampleData_quadsMode() throws Exception {
        String resource = "/com/bigdata/rdf/rio/sample data.rdf";
        Properties p = this.getProperties();
        p.setProperty(AbstractTripleStore.Options.QUADS, "true");
        this.doLoadAndVerifyTest("/com/bigdata/rdf/rio/sample data.rdf", p);
    }

    public void test_loadAndVerify_bsbm_pc100() throws Exception {
        String file = "/data/bsbm/dataset_pc100.nt";
        Properties p = this.getProperties();
        p.setProperty(AbstractTripleStore.Options.QUADS, "true");
        this.doLoadAndVerifyTest("/data/bsbm/dataset_pc100.nt", p);
    }

    public void test_loadAndVerify_bsbm_pc100_quadsMode() throws Exception {
        String file = "/data/bsbm/dataset_pc100.nt";
        Properties p = this.getProperties();
        p.setProperty(AbstractTripleStore.Options.QUADS, "true");
        this.doLoadAndVerifyTest("/data/bsbm/dataset_pc100.nt", p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLoadAndVerifyTest(String resource, Properties properties) throws Exception {
        AbstractTripleStore store = this.getStore(properties);
        try {
            if (!(store.getIndexManager() instanceof AbstractScaleOutFederation)) {
                log.warn((Object)"Test requires scale-out index views.");
                return;
            }
            this.doLoad(store, resource, true);
            if (log.isDebugEnabled()) {
                SPOKeyOrder keyOrder;
                Iterator itr;
                log.debug((Object)"dumping store...");
                log.debug((Object)("LEXICON:\n" + DumpLexicon.dump((LexiconRelation)store.getLexiconRelation())));
                if (store.getLexiconRelation().isTextIndex()) {
                    itr = ((BigdataValueCentricFullTextIndex)store.getLexiconRelation().getSearchEngine()).getIndex().rangeIterator();
                    while (itr.hasNext()) {
                        log.debug(itr.next().getObject());
                    }
                }
                Iterator iterator = itr = store.isQuads() ? SPOKeyOrder.quadStoreKeyOrderIterator() : SPOKeyOrder.tripleStoreKeyOrderIterator();
                while (itr.hasNext()) {
                    keyOrder = (SPOKeyOrder)itr.next();
                    log.debug((Object)("\n---" + keyOrder + "---\n" + store.getSPORelation().dump((IKeyOrder)keyOrder)));
                }
                Iterator iterator2 = itr = store.isQuads() ? SPOKeyOrder.quadStoreKeyOrderIterator() : SPOKeyOrder.tripleStoreKeyOrderIterator();
                while (itr.hasNext()) {
                    keyOrder = (SPOKeyOrder)itr.next();
                    log.debug((Object)("\n" + keyOrder + "\n" + store.getSPORelation().dump((IKeyOrder)keyOrder)));
                    log.debug((Object)("\n---" + keyOrder + "---\n" + store.dumpStore(store, true, true, true, true, true, true, (IKeyOrder)keyOrder)));
                }
            }
            this.doVerify(store, resource, true);
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    @Override
    protected void doLoad(AbstractTripleStore store, String resource, boolean parallel) throws Exception {
        this.doLoad2(store, new File(resource), parallel);
    }

    protected AsynchronousStatementBufferFactory<BigdataStatement, File> doLoad2(AbstractTripleStore store, File resource, boolean parallel) throws Exception {
        RDFParserOptions parserOptions = new RDFParserOptions();
        parserOptions.setVerifyData(false);
        AsynchronousStatementBufferFactory statementBufferFactory = new AsynchronousStatementBufferFactory((ScaleOutTripleStore)store, 20000, 10000, 16, RDFFormat.RDFXML, null, parserOptions, false, parallel ? 5 : 1, 20, parallel ? 5 : 1, parallel ? 5 : 1, parallel ? 5 : 1, 5000L);
        try {
            if (resource.isDirectory()) {
                statementBufferFactory.submitAll(resource, (FilenameFilter)new RDFFilenameFilter(), 250L);
            } else {
                statementBufferFactory.submitOne((Object)resource);
            }
            statementBufferFactory.awaitAll();
            System.err.println(statementBufferFactory.getCounters().toString());
        }
        catch (Throwable t) {
            statementBufferFactory.cancelAll(true);
            throw new RuntimeException(t);
        }
        return statementBufferFactory;
    }
}

