/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rio;

import com.bigdata.rdf.load.IStatementBufferFactory;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.rio.AbstractRIOTestCase;
import com.bigdata.rdf.rio.IStatementBuffer;
import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.util.Properties;
import org.openrdf.model.Statement;

public class TestLoadAndVerify
extends AbstractRIOTestCase {
    final boolean parallel = false;

    public TestLoadAndVerify() {
    }

    public TestLoadAndVerify(String name) {
        super(name);
    }

    public void test_loadAndVerify_small() throws Exception {
        String resource = "/com/bigdata/rdf/rio/small.rdf";
        this.doLoadAndVerifyTest("/com/bigdata/rdf/rio/small.rdf", false);
    }

    public void test_loadAndVerify_little_ttl() throws Exception {
        String resource = "/com/bigdata/rdf/rio/little.ttl";
        this.doLoadAndVerifyTest("/com/bigdata/rdf/rio/little.ttl", false);
    }

    public void test_loadAndVerify_little_jsonld() throws Exception {
        String resource = "/com/bigdata/rdf/rio/little.jsonld";
        this.doLoadAndVerifyTest("/com/bigdata/rdf/rio/little.jsonld", false);
    }

    public void test_loadAndVerify_little_trig_quadsMode() throws Exception {
        String resource = "/com/bigdata/rdf/rio/little.trig";
        Properties p = this.getProperties();
        if (!Boolean.valueOf(p.getProperty(AbstractTripleStore.Options.QUADS, "false")).booleanValue()) {
            return;
        }
        this.doLoadAndVerifyTest("/com/bigdata/rdf/rio/little.trig", false);
    }

    public void test_loadAndVerify_smallWithBlobs() throws Exception {
        String resource = "/com/bigdata/rdf/rio/smallWithBlobs.rdf";
        this.doLoadAndVerifyTest("/com/bigdata/rdf/rio/smallWithBlobs.rdf", false);
    }

    public void test_loadAndVerify_sampleData() throws Exception {
        String resource = "/com/bigdata/rdf/rio/sample data.rdf";
        this.doLoadAndVerifyTest("/com/bigdata/rdf/rio/sample data.rdf", false);
    }

    public void test_loadAndVerify_bsbm_pc100() throws Exception {
        String file = "/data/bsbm/dataset_pc100.nt";
        this.doLoadAndVerifyTest("/data/bsbm/dataset_pc100.nt", false);
    }

    public void test_loadAndVerify_U1() throws Exception {
        String file = "src/test/resources/data/lehigh/U1/";
        this.doLoadAndVerifyTest("src/test/resources/data/lehigh/U1/", false);
    }

    @Override
    protected AbstractTripleStore getStore() {
        Properties properties = new Properties(this.getProperties());
        return this.getStore(properties);
    }

    @Override
    protected void doLoad(AbstractTripleStore store, String resource, boolean parallel) throws Exception {
        this.doLoad(store, resource, parallel, new StatementBufferFactory<BigdataStatement>(store));
    }

    private static class StatementBufferFactory<S extends Statement>
    implements IStatementBufferFactory<S> {
        final AbstractTripleStore store;

        public StatementBufferFactory(AbstractTripleStore store) {
            this.store = store;
        }

        public IStatementBuffer<S> newStatementBuffer() {
            return new StatementBuffer(this.store, 100000);
        }
    }
}

