/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rio;

import com.bigdata.rdf.ServiceProviderHook;
import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.rio.LoadStats;
import com.bigdata.rdf.rio.ntriples.BigdataNTriplesParser;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.AbstractTripleStoreTestCase;
import com.bigdata.rdf.store.BigdataStatementIterator;
import com.bigdata.rdf.store.DataLoader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParserFactory;
import org.openrdf.rio.RDFParserRegistry;

public class TestNTriplesWithSids
extends AbstractTripleStoreTestCase {
    protected static final transient Logger log = Logger.getLogger(TestNTriplesWithSids.class);

    public TestNTriplesWithSids() {
    }

    public TestNTriplesWithSids(String name) {
        super(name);
    }

    @Override
    public Properties getProperties() {
        Properties properties = new Properties(super.getProperties());
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_ntriples_sids_00() throws RDFParseException, RDFHandlerException, IOException {
        String data = "_:alice <http://xmlns.com/foaf/0.1/mbox> <mailto:alice@work> .\n_:s1 <" + RDF.SUBJECT + "> _:alice .\n" + "_:s1 <" + RDF.PREDICATE + "> <http://xmlns.com/foaf/0.1/mbox> .\n" + "_:s1 <" + RDF.OBJECT + "> <mailto:alice@work> .\n" + "_:s1 <http://purl.org/dc/terms/source> <http://hr.example.com/employees#bob> .\n" + "<<_:alice <http://xmlns.com/foaf/0.1/mbox> <mailto:alice@work>>> <http://purl.org/dc/terms/created>  \"2012-02-05T12:34:00Z\"^^<http://www.w3.org/2001/XMLSchema#dateTime> .\n";
        AbstractTripleStore store = this.getStore();
        try {
            BigdataStatement st;
            if (!store.getStatementIdentifiers()) {
                log.warn((Object)"Statement identifiers not enabled - skipping test");
                return;
            }
            TestNTriplesWithSids.assertEquals((String)"NTriplesParserClass", (String)BigdataNTriplesParser.class.getName(), (String)((RDFParserFactory)RDFParserRegistry.getInstance().get((Object)ServiceProviderHook.NTRIPLES_RDR)).getParser().getClass().getName());
            DataLoader dataLoader = store.getDataLoader();
            LoadStats loadStats = dataLoader.loadData((Reader)new StringReader(data), this.getName(), ServiceProviderHook.NTRIPLES_RDR);
            if (log.isInfoEnabled()) {
                log.info((Object)store.dumpStore());
            }
            TestNTriplesWithSids.assertEquals((String)"toldTriples", (long)3L, (long)store.getStatementCount());
            BigdataStatementIterator it = store.getStatements(null, null, null);
            while (it.hasNext()) {
                System.err.println(it.next());
            }
            BigdataURI dcSource = store.getValueFactory().createURI("http://purl.org/dc/terms/source");
            BigdataURI dcCreated = store.getValueFactory().createURI("http://purl.org/dc/terms/created");
            BigdataURI bobSource = store.getValueFactory().createURI("http://hr.example.com/employees#bob");
            TestNTriplesWithSids.assertEquals((long)1L, (long)store.getAccessPath(null, (URI)dcSource, (Value)bobSource).rangeCount(true));
            TestNTriplesWithSids.assertEquals((long)1L, (long)store.getAccessPath(null, (URI)dcCreated, null).rangeCount(true));
            int n = 0;
            try (BigdataStatementIterator itr = store.getStatements(null, (URI)dcSource, (Value)bobSource);){
                while (itr.hasNext()) {
                    st = (BigdataStatement)itr.next();
                    TestNTriplesWithSids.assertTrue((boolean)st.getSubject().getIV().isStatement());
                    ++n;
                }
            }
            TestNTriplesWithSids.assertEquals((int)1, (int)n);
            n = 0;
            itr = store.getStatements(null, (URI)dcCreated, null);
            try {
                while (itr.hasNext()) {
                    st = (BigdataStatement)itr.next();
                    TestNTriplesWithSids.assertTrue((boolean)st.getSubject().getIV().isStatement());
                    ++n;
                }
            }
            finally {
                itr.close();
            }
            TestNTriplesWithSids.assertEquals((int)1, (int)n);
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_ntriples_sids_01() throws RDFParseException, RDFHandlerException, IOException {
        String data = "_:alice <http://xmlns.com/foaf/0.1/mbox> <mailto:alice@work> .\n<< _:alice <http://xmlns.com/foaf/0.1/mbox> <mailto:alice@work> >> <http://purl.org/dc/terms/source>   <http://hr.example.com/employees#bob> .\n<<_:alice <http://xmlns.com/foaf/0.1/mbox> <mailto:alice@work>>> <http://purl.org/dc/terms/created>  \"2012-02-05T12:34:00Z\"^^<http://www.w3.org/2001/XMLSchema#dateTime> .\n";
        AbstractTripleStore store = this.getStore();
        try {
            BigdataStatement st;
            if (!store.getStatementIdentifiers()) {
                log.warn((Object)"Statement identifiers not enabled - skipping test");
                return;
            }
            TestNTriplesWithSids.assertEquals((String)"NTriplesParserClass", (String)BigdataNTriplesParser.class.getName(), (String)((RDFParserFactory)RDFParserRegistry.getInstance().get((Object)ServiceProviderHook.NTRIPLES_RDR)).getParser().getClass().getName());
            DataLoader dataLoader = store.getDataLoader();
            LoadStats loadStats = dataLoader.loadData((Reader)new StringReader("_:alice <http://xmlns.com/foaf/0.1/mbox> <mailto:alice@work> .\n<< _:alice <http://xmlns.com/foaf/0.1/mbox> <mailto:alice@work> >> <http://purl.org/dc/terms/source>   <http://hr.example.com/employees#bob> .\n<<_:alice <http://xmlns.com/foaf/0.1/mbox> <mailto:alice@work>>> <http://purl.org/dc/terms/created>  \"2012-02-05T12:34:00Z\"^^<http://www.w3.org/2001/XMLSchema#dateTime> .\n"), this.getName(), ServiceProviderHook.NTRIPLES_RDR);
            if (log.isInfoEnabled()) {
                log.info((Object)store.dumpStore());
            }
            TestNTriplesWithSids.assertEquals((String)"toldTriples", (long)3L, (long)store.getStatementCount());
            BigdataURI dcSource = store.getValueFactory().createURI("http://purl.org/dc/terms/source");
            BigdataURI dcCreated = store.getValueFactory().createURI("http://purl.org/dc/terms/created");
            BigdataURI bobSource = store.getValueFactory().createURI("http://hr.example.com/employees#bob");
            TestNTriplesWithSids.assertEquals((long)1L, (long)store.getAccessPath(null, (URI)dcSource, (Value)bobSource).rangeCount(true));
            TestNTriplesWithSids.assertEquals((long)1L, (long)store.getAccessPath(null, (URI)dcCreated, null).rangeCount(true));
            int n = 0;
            try (BigdataStatementIterator itr = store.getStatements(null, (URI)dcSource, (Value)bobSource);){
                while (itr.hasNext()) {
                    st = (BigdataStatement)itr.next();
                    TestNTriplesWithSids.assertTrue((boolean)st.getSubject().getIV().isStatement());
                    ++n;
                }
            }
            TestNTriplesWithSids.assertEquals((int)1, (int)n);
            n = 0;
            itr = store.getStatements(null, (URI)dcCreated, null);
            try {
                while (itr.hasNext()) {
                    st = (BigdataStatement)itr.next();
                    TestNTriplesWithSids.assertTrue((boolean)st.getSubject().getIV().isStatement());
                    ++n;
                }
            }
            finally {
                itr.close();
            }
            TestNTriplesWithSids.assertEquals((int)1, (int)n);
        }
        finally {
            store.__tearDownUnitTest();
        }
    }
}

