/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rio;

import com.bigdata.rdf.rio.ntriples.BigdataNTriplesParser;
import com.bigdata.rdf.rio.turtle.BigdataTurtleParser;
import java.io.IOException;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;
import org.openrdf.model.BNode;
import org.openrdf.model.Statement;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.helpers.RDFHandlerBase;

public class TestStandaloneRDRParsers {
    boolean bNodeFound;

    @Test
    public void testStandaloneBigdataTurtleParser() throws RDFParseException, RDFHandlerException, IOException {
        this.testStandaloneParser((RDFParser)new BigdataTurtleParser(), "com/bigdata/rdf/rio/rdr_test.ttlx");
    }

    @Test
    public void testStandaloneBigdataNTriplesParser() throws RDFParseException, RDFHandlerException, IOException {
        this.testStandaloneParser((RDFParser)new BigdataNTriplesParser(), "com/bigdata/rdf/rio/rdr_test.ntx");
    }

    private void testStandaloneParser(RDFParser parser, String resourceName) throws IOException, RDFParseException, RDFHandlerException {
        this.bNodeFound = false;
        parser.setRDFHandler((RDFHandler)new RDFHandlerBase(){

            public void handleStatement(Statement st) throws RDFHandlerException {
                if (st.getSubject() instanceof BNode) {
                    TestStandaloneRDRParsers.this.bNodeFound = true;
                }
                super.handleStatement(st);
            }
        });
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(resourceName);){
            parser.parse(is, "");
        }
        Assert.assertTrue((boolean)this.bNodeFound);
    }
}

