/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rio;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.internal.impl.bnode.SidIV;
import com.bigdata.rdf.model.BigdataBNode;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.AbstractTripleStoreTestCase;
import java.util.Properties;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;

public class TestStatementBuffer
extends AbstractTripleStoreTestCase {
    public TestStatementBuffer() {
    }

    public TestStatementBuffer(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_ctor01() {
        int capacity = 27;
        boolean queueCapacity = false;
        AbstractTripleStore store = this.getStore();
        try {
            StatementBuffer buffer = new StatementBuffer(store, 27, 0);
            TestStatementBuffer.assertEquals((Object)store, (Object)buffer.getDatabase());
            TestStatementBuffer.assertEquals((int)27, (int)buffer.getCapacity());
            TestStatementBuffer.assertEquals((int)(27 * store.getSPOKeyArity() + 5), (int)buffer.values.length);
            TestStatementBuffer.assertEquals((int)27, (int)buffer.stmts.length);
            TestStatementBuffer.assertEquals((int)5, (int)buffer.numURIs);
            TestStatementBuffer.assertEquals((int)0, (int)buffer.numLiterals);
            TestStatementBuffer.assertEquals((int)0, (int)buffer.numBNodes);
            TestStatementBuffer.assertEquals((int)0, (int)buffer.numStmts);
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_ctor02() {
        int capacity = 27;
        int queueCapacity = 10;
        AbstractTripleStore store = this.getStore();
        try {
            StatementBuffer buffer = new StatementBuffer(store, 27, 10);
            TestStatementBuffer.assertEquals((Object)store, (Object)buffer.getDatabase());
            TestStatementBuffer.assertEquals((int)27, (int)buffer.getCapacity());
            TestStatementBuffer.assertEquals((int)(27 * store.getSPOKeyArity() + 5), (int)buffer.values.length);
            TestStatementBuffer.assertEquals((int)27, (int)buffer.stmts.length);
            TestStatementBuffer.assertEquals((int)5, (int)buffer.numURIs);
            TestStatementBuffer.assertEquals((int)0, (int)buffer.numLiterals);
            TestStatementBuffer.assertEquals((int)0, (int)buffer.numBNodes);
            TestStatementBuffer.assertEquals((int)0, (int)buffer.numStmts);
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_handleStatement_distinctTerm() {
        int capacity = 5;
        AbstractTripleStore store = this.getStore();
        try {
            StatementBuffer buffer = new StatementBuffer(store, 5);
            URIImpl s1 = new URIImpl("http://www.foo.org");
            URI p1 = RDF.TYPE;
            URI o1 = RDFS.RESOURCE;
            Resource c1 = null;
            buffer.handleStatement((Resource)s1, p1, (Value)o1, c1, StatementEnum.Explicit);
            TestStatementBuffer.assertEquals((int)8, (int)buffer.numURIs);
            TestStatementBuffer.assertEquals((int)0, (int)buffer.numLiterals);
            TestStatementBuffer.assertEquals((int)0, (int)buffer.numBNodes);
            TestStatementBuffer.assertEquals((int)1, (int)buffer.numStmts);
            URIImpl s2 = new URIImpl("http://www.foo.org");
            URI p2 = RDFS.LABEL;
            LiteralImpl o2 = new LiteralImpl("test lit.");
            Resource c2 = null;
            buffer.handleStatement((Resource)s2, p2, (Value)o2, c2, StatementEnum.Explicit);
            TestStatementBuffer.assertEquals((int)9, (int)buffer.numURIs);
            TestStatementBuffer.assertEquals((int)1, (int)buffer.numLiterals);
            TestStatementBuffer.assertEquals((int)0, (int)buffer.numBNodes);
            TestStatementBuffer.assertEquals((int)2, (int)buffer.numStmts);
            URIImpl s3 = new URIImpl("http://www.foo.org");
            URI p3 = RDFS.LABEL;
            LiteralImpl o3 = new LiteralImpl("test lit.");
            Resource c3 = null;
            buffer.handleStatement((Resource)s3, p3, (Value)o3, c3, StatementEnum.Explicit);
            TestStatementBuffer.assertEquals((int)9, (int)buffer.numURIs);
            TestStatementBuffer.assertEquals((int)1, (int)buffer.numLiterals);
            TestStatementBuffer.assertEquals((int)0, (int)buffer.numBNodes);
            TestStatementBuffer.assertEquals((int)3, (int)buffer.numStmts);
            buffer.handleStatement((Resource)s3, p3, (Value)o3, c3, StatementEnum.Explicit);
            TestStatementBuffer.assertEquals((int)9, (int)buffer.numURIs);
            TestStatementBuffer.assertEquals((int)1, (int)buffer.numLiterals);
            TestStatementBuffer.assertEquals((int)0, (int)buffer.numBNodes);
            TestStatementBuffer.assertEquals((int)4, (int)buffer.numStmts);
            buffer.flush();
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_statementBuffer() {
        int capacity = 5;
        Properties properties = new Properties(this.getProperties());
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            TestStatementBuffer.assertEquals((long)0L, (long)store.getStatementCount());
            BigdataValueFactory vf = store.getValueFactory();
            StatementBuffer buffer = new StatementBuffer(store, 5);
            URIImpl s1 = new URIImpl("http://www.foo.org");
            URI p1 = RDF.TYPE;
            URI o1 = RDFS.RESOURCE;
            Resource c1 = null;
            buffer.add((Statement)vf.createStatement((Resource)s1, p1, (Value)o1, c1, StatementEnum.Explicit));
            URIImpl s2 = new URIImpl("http://www.foo.org");
            URI p2 = RDFS.LABEL;
            LiteralImpl o2 = new LiteralImpl("test lit.");
            Resource c2 = null;
            buffer.add((Statement)vf.createStatement((Resource)s2, p2, (Value)o2, c2, StatementEnum.Explicit));
            URIImpl s3 = new URIImpl("http://www.foo.org");
            URI p3 = RDFS.LABEL;
            LiteralImpl o3 = new LiteralImpl("test lit.");
            Resource c3 = null;
            buffer.handleStatement((Resource)s3, p3, (Value)o3, c3, StatementEnum.Explicit);
            TestStatementBuffer.assertEquals((long)0L, (long)store.getStatementCount());
            buffer.flush();
            TestStatementBuffer.assertEquals((long)2L, (long)store.getStatementCount());
            TestStatementBuffer.assertTrue((boolean)store.hasStatement((Resource)s1, p1, (Value)o1));
            TestStatementBuffer.assertTrue((boolean)store.hasStatement((Resource)s2, p2, (Value)o2));
            TestStatementBuffer.assertFalse((boolean)store.hasStatement((Resource)s1, p2, (Value)o1));
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    public void test_reificationDoneRight_disabled() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_reificationDoneRight_enabled() {
        int capacity = 20;
        Properties properties = new Properties(this.getProperties());
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            if (!store.isStatementIdentifiers()) {
                return;
            }
            BigdataValueFactory vf = store.getValueFactory();
            BigdataURI SAP = vf.createURI("http://example.com/SAP");
            BigdataURI bought = vf.createURI("http://example.com/bought");
            BigdataURI sybase = vf.createURI("http://example.com/sybase");
            BigdataURI dcSource = vf.createURI("http://purl.org/dc/terms/source");
            BigdataURI dcCreated = vf.createURI("http://purl.org/dc/terms/created");
            BigdataURI newsSybase = vf.createURI("http://example.com/news/us-sybase");
            BigdataLiteral createdDate = vf.createLiteral("2011-04-05T12:00:00Z", XSD.DATETIME);
            BigdataBNode s1 = vf.createBNode("s1");
            TestStatementBuffer.assertEquals((long)0L, (long)store.getStatementCount());
            StatementBuffer buffer = new StatementBuffer(store, 20);
            buffer.add((Statement)vf.createStatement((Resource)SAP, (URI)bought, (Value)sybase, null, StatementEnum.Explicit));
            buffer.add((Statement)vf.createStatement((Resource)s1, RDF.SUBJECT, (Value)SAP, null, StatementEnum.Explicit));
            buffer.add((Statement)vf.createStatement((Resource)s1, RDF.PREDICATE, (Value)bought, null, StatementEnum.Explicit));
            buffer.add((Statement)vf.createStatement((Resource)s1, RDF.OBJECT, (Value)sybase, null, StatementEnum.Explicit));
            buffer.add((Statement)vf.createStatement((Resource)s1, RDF.TYPE, (Value)RDF.STATEMENT, null, StatementEnum.Explicit));
            BigdataStatement mds1 = vf.createStatement((Resource)s1, (URI)dcSource, (Value)newsSybase, null, StatementEnum.Explicit);
            BigdataStatement mds2 = vf.createStatement((Resource)s1, (URI)dcCreated, (Value)createdDate, null, StatementEnum.Explicit);
            buffer.add((Statement)mds1);
            buffer.add((Statement)mds2);
            buffer.flush();
            TestStatementBuffer.assertEquals((long)3L, (long)store.getStatementCount());
            TestStatementBuffer.assertTrue((boolean)store.hasStatement((Resource)SAP, (URI)bought, (Value)sybase));
            TestStatementBuffer.assertFalse((boolean)store.hasStatement((Resource)s1, RDF.SUBJECT, (Value)SAP));
            TestStatementBuffer.assertFalse((boolean)store.hasStatement((Resource)s1, RDF.PREDICATE, (Value)bought));
            TestStatementBuffer.assertFalse((boolean)store.hasStatement((Resource)s1, RDF.OBJECT, (Value)sybase));
            TestStatementBuffer.assertFalse((boolean)store.hasStatement((Resource)s1, RDF.TYPE, (Value)RDF.STATEMENT));
            TestStatementBuffer.assertTrue((boolean)store.hasStatement((Resource)s1, (URI)dcSource, (Value)newsSybase));
            TestStatementBuffer.assertTrue((boolean)store.hasStatement((Resource)s1, (URI)dcCreated, (Value)createdDate));
            TestStatementBuffer.assertTrue((boolean)mds1.hasStatementIdentifier());
            TestStatementBuffer.assertTrue((boolean)mds2.hasStatementIdentifier());
            SidIV sidIV1 = (SidIV)mds1.getStatementIdentifier();
            SidIV sidIV2 = (SidIV)mds2.getStatementIdentifier();
            TestStatementBuffer.assertEquals((Object)sidIV1.getInlineValue().s(), (Object)mds1.s());
            TestStatementBuffer.assertEquals((Object)sidIV1.getInlineValue().p(), (Object)mds1.p());
            TestStatementBuffer.assertEquals((Object)sidIV1.getInlineValue().o(), (Object)mds1.o());
            TestStatementBuffer.assertEquals((Object)sidIV2.getInlineValue().s(), (Object)mds2.s());
            TestStatementBuffer.assertEquals((Object)sidIV2.getInlineValue().p(), (Object)mds2.p());
            TestStatementBuffer.assertEquals((Object)sidIV2.getInlineValue().o(), (Object)mds2.o());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_context_stripping() {
        int capacity = 1;
        AbstractTripleStore store = this.getStore(this.getProperties());
        try {
            BigdataValueFactory vf = store.getValueFactory();
            BigdataURI s = vf.createURI("http://example.com/s");
            BigdataURI p = vf.createURI("http://example.com/p");
            BigdataURI o = vf.createURI("http://example.com/o");
            BigdataURI c = vf.createURI("http://example.com/c");
            StatementBuffer buffer = new StatementBuffer(store, capacity);
            buffer.add((Statement)vf.createStatement((Resource)s, (URI)p, (Value)o, (Resource)c, StatementEnum.Explicit));
            buffer.flush();
            TestStatementBuffer.assertTrue((boolean)store.hasStatement((Resource)s, (URI)p, (Value)o));
            TestStatementBuffer.assertFalse((boolean)store.hasStatement((Resource)s, (URI)p, (Value)o, (Resource)c));
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    public static class TestTriplesModeAPs
    extends TestStatementBuffer {
        @Override
        public Properties getProperties() {
            Properties properties = new Properties(super.getProperties());
            properties.setProperty(AbstractTripleStore.Options.QUADS, "false");
            properties.setProperty(AbstractTripleStore.Options.TRIPLES_MODE, "true");
            return properties;
        }
    }
}

