/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rio.ntriples;

import com.bigdata.rdf.rio.ntriples.BigdataNTriplesParser;
import java.io.InputStream;
import junit.framework.TestCase2;
import org.apache.log4j.Logger;
import org.openrdf.model.Statement;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.helpers.RDFHandlerBase;

public abstract class BigdataNTriplesParserTestCase
extends TestCase2 {
    private static String NTRIPLES_TEST_URL = "http://www.w3.org/2000/10/rdf-tests/rdfcore/ntriples/test.nt";
    private static String NTRIPLES_TEST_FILE = "test.nt";
    private static String NTRIPLES_TEST_FILE_WITH_SIDS = "test-sids.nt";
    private static String NTRIPLES_TEST_FILE_WITH_REIFICATION = "test-reify.nt";
    private static final transient Logger log = Logger.getLogger(BigdataNTriplesParserTestCase.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNTriplesFile() throws Exception {
        RDFParser turtleParser = this.createRDFParser();
        turtleParser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
        turtleParser.setRDFHandler((RDFHandler)new RDFHandlerBase(){

            public void handleStatement(Statement st) throws RDFHandlerException {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Statement: " + st));
                }
            }
        });
        try (InputStream in = BigdataNTriplesParser.class.getResourceAsStream(NTRIPLES_TEST_FILE);){
            turtleParser.parse(in, NTRIPLES_TEST_URL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNTriplesFileWithSIDS() throws Exception {
        RDFParser turtleParser = this.createRDFParser();
        turtleParser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
        turtleParser.setRDFHandler((RDFHandler)new RDFHandlerBase(){

            public void handleStatement(Statement st) throws RDFHandlerException {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Statement: " + st));
                }
            }
        });
        String fileUrl = BigdataNTriplesParser.class.getResource(NTRIPLES_TEST_FILE_WITH_SIDS).toExternalForm();
        try (InputStream in = BigdataNTriplesParser.class.getResourceAsStream(NTRIPLES_TEST_FILE_WITH_SIDS);){
            turtleParser.parse(in, fileUrl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNTriplesFileWithReification() throws Exception {
        RDFParser turtleParser = this.createRDFParser();
        turtleParser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
        turtleParser.setRDFHandler((RDFHandler)new RDFHandlerBase(){

            public void handleStatement(Statement st) throws RDFHandlerException {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Statement: " + st));
                }
            }
        });
        String fileUrl = BigdataNTriplesParser.class.getResource(NTRIPLES_TEST_FILE_WITH_REIFICATION).toExternalForm();
        try (InputStream in = BigdataNTriplesParser.class.getResourceAsStream(NTRIPLES_TEST_FILE_WITH_REIFICATION);){
            turtleParser.parse(in, fileUrl);
        }
    }

    protected abstract RDFParser createRDFParser();
}

