/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rules;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.joinGraph.IEvaluationPlanFactory;
import com.bigdata.bop.joinGraph.fast.DefaultEvaluationPlanFactory2;
import com.bigdata.rdf.rules.AbstractInferenceEngineTestCase;
import com.bigdata.rdf.rules.RuleContextEnum;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.relation.accesspath.IElementFilter;
import com.bigdata.relation.rule.IRule;
import com.bigdata.relation.rule.IStep;
import com.bigdata.relation.rule.eval.ActionEnum;
import com.bigdata.relation.rule.eval.IJoinNexus;
import com.bigdata.relation.rule.eval.ISolution;
import com.bigdata.striterator.IChunkedOrderedIterator;

public abstract class AbstractRuleTestCase
extends AbstractInferenceEngineTestCase {
    public AbstractRuleTestCase() {
    }

    public AbstractRuleTestCase(String name) {
        super(name);
    }

    protected void applyRule(AbstractTripleStore db, IRule rule, long expectedSolutionCount, long expectedMutationCount) throws Exception {
        this.applyRule(db, rule, null, expectedSolutionCount, expectedMutationCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyRule(AbstractTripleStore db, IRule rule, IElementFilter<ISPO> filter, long expectedSolutionCount, long expectedMutationCount) throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("\ndatabase(before)::\n" + db.dumpStore()));
        }
        boolean justify = false;
        boolean backchain = false;
        DefaultEvaluationPlanFactory2 planFactory = DefaultEvaluationPlanFactory2.INSTANCE;
        IJoinNexus joinNexus = db.newJoinNexusFactory(RuleContextEnum.HighLevelQuery, ActionEnum.Query, 7, filter, false, false, (IEvaluationPlanFactory)planFactory).newInstance(db.getIndexManager());
        long n = 0L;
        try (IChunkedOrderedIterator itr = joinNexus.runQuery((IStep)rule);){
            while (itr.hasNext()) {
                ISolution[] chunk;
                for (ISolution solution : chunk = (ISolution[])itr.nextChunk()) {
                    ++n;
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)("#" + n + " : " + solution.toString()));
                }
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Computed " + n + " solutions: " + rule.getName() + " :: " + rule));
        }
        if (expectedSolutionCount != -1L) {
            AbstractRuleTestCase.assertEquals((String)"solutionCount(Query)", (long)expectedSolutionCount, (long)n);
        }
        joinNexus = db.newJoinNexusFactory(RuleContextEnum.DatabaseAtOnceClosure, ActionEnum.Insert, 7, filter, false, false, (IEvaluationPlanFactory)planFactory).newInstance(db.getIndexManager());
        long actualMutationCount = joinNexus.runMutation((IStep)rule);
        if (log.isInfoEnabled()) {
            log.info((Object)("Inserted " + actualMutationCount + " elements : " + rule.getName() + " :: " + rule));
        }
        AbstractRuleTestCase.assertEquals((String)"mutationCount(Insert)", (long)expectedMutationCount, (long)actualMutationCount);
        if (log.isInfoEnabled()) {
            log.info((Object)("\ndatabase(after)::\n" + db.dumpStore()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertSameSolutionsAnyOrder(IChunkedOrderedIterator<ISolution> itr, IBindingSet[] expected) {
        if (itr == null) {
            throw new IllegalArgumentException();
        }
        if (expected == null) {
            throw new IllegalArgumentException();
        }
        try {
            int n = 0;
            while (itr.hasNext()) {
                IBindingSet actual = ((ISolution)itr.next()).getBindingSet();
                AbstractRuleTestCase.assertNotNull((String)"bindings not requested?", (Object)actual);
                if (!this.findAndClear(actual, expected)) {
                    AbstractRuleTestCase.fail((String)("Not found: ndone=" + n + ", bindingSet=" + actual));
                }
                ++n;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Matched " + n + " binding sets"));
            }
            AbstractRuleTestCase.assertEquals((String)"#of solutions", (int)n, (int)expected.length);
        }
        finally {
            itr.close();
        }
    }

    private boolean findAndClear(IBindingSet actual, IBindingSet[] expected) {
        for (int i = 0; i < expected.length; ++i) {
            IBindingSet tmp = expected[i];
            if (tmp == null || !actual.equals((Object)tmp)) continue;
            expected[i] = null;
            if (log.isInfoEnabled()) {
                log.info((Object)("Matched: index=" + i + ", bindingSet=" + actual));
            }
            return true;
        }
        log.warn((Object)("No match: bindingSet=" + actual));
        return false;
    }
}

