/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rules;

import com.bigdata.rdf.inf.BackchainOwlSameAsPropertiesIterator;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.rules.AbstractInferenceEngineTestCase;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.spo.SPOAccessPath;
import com.bigdata.rdf.spo.SPOPredicate;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.striterator.IChunkedOrderedIterator;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;

public class TestBackchainOwlSameAsPropertiesIterator
extends AbstractInferenceEngineTestCase {
    public TestBackchainOwlSameAsPropertiesIterator() {
    }

    public TestBackchainOwlSameAsPropertiesIterator(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_backchain() {
        AbstractTripleStore noClosure = this.getStore();
        try {
            URIImpl A = new URIImpl("http://www.bigdata.com/A");
            URIImpl B = new URIImpl("http://www.bigdata.com/B");
            URIImpl W = new URIImpl("http://www.bigdata.com/W");
            URIImpl X = new URIImpl("http://www.bigdata.com/X");
            URIImpl Y = new URIImpl("http://www.bigdata.com/Y");
            URIImpl Z = new URIImpl("http://www.bigdata.com/Z");
            StatementBuffer buffer = new StatementBuffer(noClosure, 100);
            buffer.add((Resource)X, (URI)A, (Value)Z);
            buffer.add((Resource)Y, (URI)B, (Value)W);
            buffer.add((Resource)X, OWL.SAMEAS, (Value)Y);
            buffer.add((Resource)Z, OWL.SAMEAS, (Value)W);
            buffer.flush();
            noClosure.getInferenceEngine().computeClosure(null);
            IV a = noClosure.getIV((Value)A);
            IV b = noClosure.getIV((Value)B);
            IV w = noClosure.getIV((Value)W);
            IV x = noClosure.getIV((Value)X);
            IV y = noClosure.getIV((Value)Y);
            IV z = noClosure.getIV((Value)Z);
            IV same = noClosure.getIV((Value)OWL.SAMEAS);
            IV type = noClosure.getIV((Value)RDF.TYPE);
            IV property = noClosure.getIV((Value)RDF.PROPERTY);
            IV subpropof = noClosure.getIV((Value)RDFS.SUBPROPERTYOF);
            if (log.isInfoEnabled()) {
                log.info((Object)("\n" + noClosure.dumpStore(true, true, false)));
            }
            SPOAccessPath accessPath = (SPOAccessPath)noClosure.getAccessPath(y, null, null);
            SPOPredicate pred = accessPath.getPredicate();
            BackchainOwlSameAsPropertiesIterator itr = new BackchainOwlSameAsPropertiesIterator(accessPath.iterator(), TestBackchainOwlSameAsPropertiesIterator.getValue(accessPath, 0), TestBackchainOwlSameAsPropertiesIterator.getValue(accessPath, 1), TestBackchainOwlSameAsPropertiesIterator.getValue(accessPath, 2), noClosure, same);
            TestBackchainOwlSameAsPropertiesIterator.assertSameSPOsAnyOrder(noClosure, (ISPO[])new SPO[]{new SPO(y, b, w, StatementEnum.Explicit), new SPO(y, b, z, StatementEnum.Inferred), new SPO(y, a, w, StatementEnum.Inferred), new SPO(y, a, z, StatementEnum.Inferred), new SPO(y, same, x, StatementEnum.Inferred)}, (IChunkedOrderedIterator<ISPO>)itr, true);
            accessPath = (SPOAccessPath)noClosure.getAccessPath(y, b, null);
            BackchainOwlSameAsPropertiesIterator itr2 = new BackchainOwlSameAsPropertiesIterator(accessPath.iterator(), TestBackchainOwlSameAsPropertiesIterator.getValue(accessPath, 0), TestBackchainOwlSameAsPropertiesIterator.getValue(accessPath, 1), TestBackchainOwlSameAsPropertiesIterator.getValue(accessPath, 2), noClosure, same);
            TestBackchainOwlSameAsPropertiesIterator.assertSameSPOsAnyOrder(noClosure, (ISPO[])new SPO[]{new SPO(y, b, w, StatementEnum.Explicit), new SPO(y, b, z, StatementEnum.Inferred)}, (IChunkedOrderedIterator<ISPO>)itr2, true);
            accessPath = (SPOAccessPath)noClosure.getAccessPath((IV)null, (IV)null, w);
            itr2 = new BackchainOwlSameAsPropertiesIterator(accessPath.iterator(), TestBackchainOwlSameAsPropertiesIterator.getValue(accessPath, 0), TestBackchainOwlSameAsPropertiesIterator.getValue(accessPath, 1), TestBackchainOwlSameAsPropertiesIterator.getValue(accessPath, 2), noClosure, same);
            TestBackchainOwlSameAsPropertiesIterator.assertSameSPOsAnyOrder(noClosure, (ISPO[])new SPO[]{new SPO(y, b, w, StatementEnum.Explicit), new SPO(y, a, w, StatementEnum.Inferred), new SPO(x, b, w, StatementEnum.Inferred), new SPO(x, a, w, StatementEnum.Inferred), new SPO(z, same, w, StatementEnum.Explicit)}, (IChunkedOrderedIterator<ISPO>)itr2, true);
            accessPath = (SPOAccessPath)noClosure.getAccessPath(null, a, w);
            itr2 = new BackchainOwlSameAsPropertiesIterator(accessPath.iterator(), TestBackchainOwlSameAsPropertiesIterator.getValue(accessPath, 0), TestBackchainOwlSameAsPropertiesIterator.getValue(accessPath, 1), TestBackchainOwlSameAsPropertiesIterator.getValue(accessPath, 2), noClosure, same);
            TestBackchainOwlSameAsPropertiesIterator.assertSameSPOsAnyOrder(noClosure, (ISPO[])new SPO[]{new SPO(y, a, w, StatementEnum.Inferred), new SPO(x, a, w, StatementEnum.Inferred)}, (IChunkedOrderedIterator<ISPO>)itr2, true);
            accessPath = (SPOAccessPath)noClosure.getAccessPath(x, null, z);
            itr2 = new BackchainOwlSameAsPropertiesIterator(accessPath.iterator(), TestBackchainOwlSameAsPropertiesIterator.getValue(accessPath, 0), TestBackchainOwlSameAsPropertiesIterator.getValue(accessPath, 1), TestBackchainOwlSameAsPropertiesIterator.getValue(accessPath, 2), noClosure, same);
            TestBackchainOwlSameAsPropertiesIterator.assertSameSPOsAnyOrder(noClosure, (ISPO[])new SPO[]{new SPO(x, a, z, StatementEnum.Explicit), new SPO(x, b, z, StatementEnum.Inferred)}, (IChunkedOrderedIterator<ISPO>)itr2, true);
            accessPath = (SPOAccessPath)noClosure.getAccessPath(x, b, z);
            itr2 = new BackchainOwlSameAsPropertiesIterator(accessPath.iterator(), TestBackchainOwlSameAsPropertiesIterator.getValue(accessPath, 0), TestBackchainOwlSameAsPropertiesIterator.getValue(accessPath, 1), TestBackchainOwlSameAsPropertiesIterator.getValue(accessPath, 2), noClosure, same);
            TestBackchainOwlSameAsPropertiesIterator.assertSameSPOsAnyOrder(noClosure, (ISPO[])new SPO[]{new SPO(x, b, z, StatementEnum.Inferred)}, (IChunkedOrderedIterator<ISPO>)itr2, true);
            accessPath = (SPOAccessPath)noClosure.getAccessPath(null, a, null);
            itr2 = new BackchainOwlSameAsPropertiesIterator(accessPath.iterator(), TestBackchainOwlSameAsPropertiesIterator.getValue(accessPath, 0), TestBackchainOwlSameAsPropertiesIterator.getValue(accessPath, 1), TestBackchainOwlSameAsPropertiesIterator.getValue(accessPath, 2), noClosure, same);
            TestBackchainOwlSameAsPropertiesIterator.assertSameSPOsAnyOrder(noClosure, (ISPO[])new SPO[]{new SPO(x, a, z, StatementEnum.Explicit), new SPO(x, a, w, StatementEnum.Inferred), new SPO(y, a, z, StatementEnum.Inferred), new SPO(y, a, w, StatementEnum.Inferred)}, (IChunkedOrderedIterator<ISPO>)itr2, true);
            accessPath = (SPOAccessPath)noClosure.getAccessPath(this.NULL, this.NULL, this.NULL);
            itr2 = new BackchainOwlSameAsPropertiesIterator(accessPath.iterator(), TestBackchainOwlSameAsPropertiesIterator.getValue(accessPath, 0), TestBackchainOwlSameAsPropertiesIterator.getValue(accessPath, 1), TestBackchainOwlSameAsPropertiesIterator.getValue(accessPath, 2), noClosure, same);
            TestBackchainOwlSameAsPropertiesIterator.assertSameSPOsAnyOrder(noClosure, (ISPO[])new SPO[]{new SPO(x, a, z, StatementEnum.Explicit), new SPO(y, b, w, StatementEnum.Explicit), new SPO(x, same, y, StatementEnum.Explicit), new SPO(z, same, w, StatementEnum.Explicit), new SPO(x, a, w, StatementEnum.Inferred), new SPO(x, b, z, StatementEnum.Inferred), new SPO(x, b, w, StatementEnum.Inferred), new SPO(y, a, z, StatementEnum.Inferred), new SPO(y, a, w, StatementEnum.Inferred), new SPO(y, b, z, StatementEnum.Inferred), new SPO(y, same, x, StatementEnum.Inferred), new SPO(w, same, z, StatementEnum.Inferred), new SPO(a, type, property, StatementEnum.Inferred), new SPO(b, type, property, StatementEnum.Inferred), new SPO(a, subpropof, a, StatementEnum.Inferred), new SPO(b, subpropof, b, StatementEnum.Inferred)}, (IChunkedOrderedIterator<ISPO>)itr2, true);
        }
        finally {
            noClosure.__tearDownUnitTest();
        }
    }
}

