/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rules;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.inf.BackchainTypeResourceIterator;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.rules.AbstractRuleTestCase;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.store.AbstractTestCase;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.vocab.Vocabulary;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.striterator.IChunkedOrderedIterator;
import java.util.Properties;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;

public class TestBackchainTypeResourceIterator
extends AbstractRuleTestCase {
    public TestBackchainTypeResourceIterator() {
    }

    public TestBackchainTypeResourceIterator(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_subjectBound() {
        Properties properties = super.getProperties();
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            Vocabulary vocab = store.getVocabulary();
            BigdataValueFactory f = store.getValueFactory();
            BigdataURI A = f.createURI("http://www.foo.org/A");
            BigdataURI B = f.createURI("http://www.foo.org/B");
            BigdataURI C2 = f.createURI("http://www.foo.org/C");
            StatementBuffer buffer = new StatementBuffer(store, 10);
            buffer.add((Resource)A, RDF.TYPE, (Value)B);
            buffer.add((Resource)B, RDF.TYPE, (Value)C2);
            buffer.flush();
            IAccessPath accessPath = store.getAccessPath(store.getIV((Value)A), this.NULL, this.NULL);
            IChunkedOrderedIterator itr = BackchainTypeResourceIterator.newInstance((IChunkedOrderedIterator)accessPath.iterator(), (IAccessPath)accessPath, (AbstractTripleStore)store, (IV)vocab.get((Value)RDF.TYPE), (IV)vocab.get((Value)RDFS.RESOURCE));
            TestBackchainTypeResourceIterator.assertSameSPOsAnyOrder(store, (ISPO[])new SPO[]{new SPO(store.getIV((Value)A), store.getIV((Value)RDF.TYPE), store.getIV((Value)B), StatementEnum.Explicit), new SPO(store.getIV((Value)A), store.getIV((Value)RDF.TYPE), store.getIV((Value)RDFS.RESOURCE), StatementEnum.Inferred)}, (IChunkedOrderedIterator<ISPO>)itr);
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_subjectBound2() {
        Properties properties = super.getProperties();
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            Vocabulary vocab = store.getVocabulary();
            BigdataValueFactory f = store.getValueFactory();
            BigdataURI A = f.createURI("http://www.foo.org/A");
            BigdataURI B = f.createURI("http://www.foo.org/B");
            BigdataURI C2 = f.createURI("http://www.foo.org/C");
            StatementBuffer buffer = new StatementBuffer(store, 10);
            buffer.add((Resource)A, RDF.TYPE, (Value)B);
            buffer.add((Resource)A, RDF.TYPE, (Value)RDFS.RESOURCE);
            buffer.add((Resource)B, RDF.TYPE, (Value)C2);
            buffer.flush();
            if (log.isInfoEnabled()) {
                log.info((Object)("\n" + store.dumpStore()));
            }
            IAccessPath accessPath = store.getAccessPath(store.getIV((Value)A), this.NULL, this.NULL);
            IChunkedOrderedIterator itr = BackchainTypeResourceIterator.newInstance((IChunkedOrderedIterator)accessPath.iterator(), (IAccessPath)accessPath, (AbstractTripleStore)store, (IV)vocab.get((Value)RDF.TYPE), (IV)vocab.get((Value)RDFS.RESOURCE));
            TestBackchainTypeResourceIterator.assertSameSPOsAnyOrder(store, (ISPO[])new SPO[]{new SPO(store.getIV((Value)A), store.getIV((Value)RDF.TYPE), store.getIV((Value)B), StatementEnum.Explicit), new SPO(store.getIV((Value)A), store.getIV((Value)RDF.TYPE), store.getIV((Value)RDFS.RESOURCE), StatementEnum.Explicit)}, (IChunkedOrderedIterator<ISPO>)itr);
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_noneBound() {
        Properties properties = super.getProperties();
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            Vocabulary vocab = store.getVocabulary();
            BigdataValueFactory f = store.getValueFactory();
            BigdataURI A = f.createURI("http://www.foo.org/A");
            BigdataURI B = f.createURI("http://www.foo.org/B");
            BigdataURI C2 = f.createURI("http://www.foo.org/C");
            StatementBuffer buffer = new StatementBuffer(store, 10);
            buffer.add((Resource)A, RDF.TYPE, (Value)B);
            buffer.add((Resource)A, RDF.TYPE, (Value)RDFS.RESOURCE);
            buffer.add((Resource)B, RDF.TYPE, (Value)C2);
            buffer.flush();
            IAccessPath accessPath = store.getAccessPath(this.NULL, this.NULL, this.NULL);
            IChunkedOrderedIterator itr = BackchainTypeResourceIterator.newInstance((IChunkedOrderedIterator)accessPath.iterator(), (IAccessPath)accessPath, (AbstractTripleStore)store, (IV)vocab.get((Value)RDF.TYPE), (IV)vocab.get((Value)RDFS.RESOURCE));
            TestBackchainTypeResourceIterator.assertSameSPOsAnyOrder(store, (ISPO[])new SPO[]{new SPO(store.getIV((Value)A), store.getIV((Value)RDF.TYPE), store.getIV((Value)B), StatementEnum.Explicit), new SPO(store.getIV((Value)B), store.getIV((Value)RDF.TYPE), store.getIV((Value)C2), StatementEnum.Explicit), new SPO(store.getIV((Value)A), store.getIV((Value)RDF.TYPE), store.getIV((Value)RDFS.RESOURCE), StatementEnum.Explicit), new SPO(store.getIV((Value)B), store.getIV((Value)RDF.TYPE), store.getIV((Value)RDFS.RESOURCE), StatementEnum.Inferred), new SPO(store.getIV((Value)C2), store.getIV((Value)RDF.TYPE), store.getIV((Value)RDFS.RESOURCE), StatementEnum.Inferred), new SPO(store.getIV((Value)RDFS.RESOURCE), store.getIV((Value)RDF.TYPE), store.getIV((Value)RDFS.RESOURCE), StatementEnum.Inferred)}, (IChunkedOrderedIterator<ISPO>)itr);
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_otherBound_01() {
        Properties properties = super.getProperties();
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            Vocabulary vocab = store.getVocabulary();
            BigdataValueFactory f = store.getValueFactory();
            BigdataURI A = f.createURI("http://www.foo.org/A");
            BigdataURI B = f.createURI("http://www.foo.org/B");
            BigdataURI C2 = f.createURI("http://www.foo.org/C");
            StatementBuffer buffer = new StatementBuffer(store, 10);
            buffer.add((Resource)A, RDF.TYPE, (Value)B);
            buffer.add((Resource)B, RDF.TYPE, (Value)C2);
            buffer.flush();
            IAccessPath accessPath = store.getAccessPath(this.NULL, this.NULL, store.getIV((Value)B));
            IChunkedOrderedIterator itr = BackchainTypeResourceIterator.newInstance((IChunkedOrderedIterator)accessPath.iterator(), (IAccessPath)accessPath, (AbstractTripleStore)store, (IV)vocab.get((Value)RDF.TYPE), (IV)vocab.get((Value)RDFS.RESOURCE));
            TestBackchainTypeResourceIterator.assertSameSPOsAnyOrder(store, (ISPO[])new SPO[]{new SPO(store.getIV((Value)A), store.getIV((Value)RDF.TYPE), store.getIV((Value)B), StatementEnum.Explicit)}, (IChunkedOrderedIterator<ISPO>)itr);
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_backchain_foo_type_resource() {
        Properties properties = super.getProperties();
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            Vocabulary vocab = store.getVocabulary();
            BigdataValueFactory f = store.getValueFactory();
            BigdataURI S = f.createURI("http://www.bigdata.com/s");
            BigdataURI P2 = f.createURI("http://www.bigdata.com/p");
            BigdataURI O = f.createURI("http://www.bigdata.com/o");
            IV s = store.addTerm((Value)S);
            IV p = store.addTerm((Value)P2);
            IV o = store.addTerm((Value)O);
            IV rdfType = vocab.get((Value)RDF.TYPE);
            IV rdfsResource = vocab.get((Value)RDFS.RESOURCE);
            store.addStatements((ISPO[])new SPO[]{new SPO(s, p, o, StatementEnum.Explicit)}, 1);
            if (log.isInfoEnabled()) {
                log.info((Object)("\n:" + store.dumpStore()));
            }
            AbstractTestCase.assertSameSPOs((ISPO[])new SPO[]{new SPO(s, p, o, StatementEnum.Explicit)}, (IChunkedOrderedIterator<ISPO>)store.getAccessPath(this.NULL, this.NULL, this.NULL).iterator());
            IAccessPath accessPath = store.getAccessPath(s, rdfType, rdfsResource);
            IChunkedOrderedIterator itr = BackchainTypeResourceIterator.newInstance((IChunkedOrderedIterator)accessPath.iterator(), (IAccessPath)accessPath, (AbstractTripleStore)store, (IV)rdfType, (IV)rdfsResource);
            AbstractTestCase.assertSameSPOs((ISPO[])new SPO[]{new SPO(s, rdfType, rdfsResource, StatementEnum.Inferred)}, (IChunkedOrderedIterator<ISPO>)itr);
            accessPath = store.getAccessPath(this.NULL, rdfType, rdfsResource);
            itr = BackchainTypeResourceIterator.newInstance((IChunkedOrderedIterator)accessPath.iterator(), (IAccessPath)accessPath, (AbstractTripleStore)store, (IV)rdfType, (IV)rdfsResource);
            AbstractTestCase.assertSameSPOs((ISPO[])new SPO[]{new SPO(s, rdfType, rdfsResource, StatementEnum.Inferred), new SPO(o, rdfType, rdfsResource, StatementEnum.Inferred)}, (IChunkedOrderedIterator<ISPO>)itr);
        }
        finally {
            store.__tearDownUnitTest();
        }
    }
}

