/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rules;

import com.bigdata.rdf.rio.LoadStats;
import com.bigdata.rdf.rules.AbstractRuleTestCase;
import com.bigdata.rdf.rules.FastClosure;
import com.bigdata.rdf.rules.FullClosure;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.DataLoader;
import com.bigdata.rdf.store.TripleStoreUtility;
import java.util.Properties;
import org.openrdf.rio.RDFFormat;

public class TestCompareFullAndFastClosure
extends AbstractRuleTestCase {
    public TestCompareFullAndFastClosure() {
    }

    public TestCompareFullAndFastClosure(String name) {
        super(name);
    }

    public void test_compareEntailments() throws Exception {
        String[] resource = new String[]{"com/bigdata/rdf/rules/small.rdf"};
        String[] baseURL = new String[]{""};
        RDFFormat[] format = new RDFFormat[]{RDFFormat.RDFXML};
        this.doCompareEntailments(resource, baseURL, format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCompareEntailments(String[] resource, String[] baseURL, RDFFormat[] format) throws Exception {
        Properties properties = new Properties(this.getProperties());
        properties.setProperty(DataLoader.Options.CLOSURE, DataLoader.ClosureEnum.Batch.toString());
        AbstractTripleStore store1 = null;
        AbstractTripleStore store2 = null;
        try {
            Properties tmp = new Properties(properties);
            tmp.setProperty(AbstractTripleStore.Options.CLOSURE_CLASS, FullClosure.class.getName());
            store1 = this.getStore(tmp);
            tmp = new Properties(properties);
            tmp.setProperty(AbstractTripleStore.Options.CLOSURE_CLASS, FastClosure.class.getName());
            store2 = this.getStore(tmp);
            LoadStats loadStats = store1.getDataLoader().loadData(resource, baseURL, format);
            if (log.isInfoEnabled()) {
                log.info((Object)("Full forward closure: " + loadStats));
            }
            if (log.isInfoEnabled()) {
                log.info((Object)store1.dumpStore(store1, true, true, false, true));
            }
            loadStats = store2.getDataLoader().loadData(resource, baseURL, format);
            if (log.isInfoEnabled()) {
                log.info((Object)("Fast forward closure: " + loadStats));
            }
            if (log.isInfoEnabled()) {
                log.info((Object)store2.dumpStore(store2, true, true, false, true));
            }
            TestCompareFullAndFastClosure.assertTrue((boolean)TripleStoreUtility.modelsEqual((AbstractTripleStore)store1, (AbstractTripleStore)store2));
        }
        finally {
            if (store1 != null) {
                store1.__tearDownUnitTest();
            }
            if (store2 != null) {
                store2.__tearDownUnitTest();
            }
        }
    }
}

