/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rules;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.NV;
import com.bigdata.bop.Var;
import com.bigdata.bop.ap.Predicate;
import com.bigdata.bop.rdf.filter.StripContextFilter;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.Journal;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.spo.ContextAdvancer;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.spo.SPOPredicate;
import com.bigdata.rdf.store.AbstractTestCase;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.LocalTripleStore;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.striterator.IKeyOrder;
import cutthecrap.utils.striterators.IFilter;
import java.util.Properties;
import junit.framework.TestCase2;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;

public class TestContextAdvancer
extends TestCase2 {
    public TestContextAdvancer() {
    }

    public TestContextAdvancer(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_contextAdvancer() {
        Properties properties = new Properties();
        properties.setProperty(AbstractTripleStore.Options.QUADS_MODE, "true");
        properties.setProperty(Journal.Options.BUFFER_MODE, BufferMode.Transient.toString());
        Journal store = new Journal(properties);
        try {
            LocalTripleStore db = new LocalTripleStore((IIndexManager)store, "test", Long.valueOf(0L), properties);
            db.create();
            BigdataValueFactory f = db.getValueFactory();
            BigdataURI u1 = f.createURI("http://www.bigdata.com/u1");
            BigdataURI u2 = f.createURI("http://www.bigdata.com/u2");
            BigdataURI v1 = f.createURI("http://www.bigdata.com/v1");
            BigdataURI v2 = f.createURI("http://www.bigdata.com/v2");
            BigdataURI c1 = f.createURI("http://www.bigdata.com/c1");
            BigdataURI c2 = f.createURI("http://www.bigdata.com/c2");
            BigdataURI rdfType = f.createURI(RDF.TYPE.stringValue());
            BigdataValue[] terms = new BigdataValue[]{u1, u2, v1, v2, c1, c2, rdfType};
            db.getLexiconRelation().addTerms(terms, terms.length, false);
            StatementEnum explicit = StatementEnum.Explicit;
            BigdataStatement[] stmts = new BigdataStatement[]{f.createStatement((Resource)u1, (URI)rdfType, (Value)v1, (Resource)c1, explicit), f.createStatement((Resource)u1, (URI)rdfType, (Value)v1, (Resource)c2, explicit), f.createStatement((Resource)u1, (URI)rdfType, (Value)v2, (Resource)c1, explicit), f.createStatement((Resource)u1, (URI)rdfType, (Value)v2, (Resource)c2, explicit), f.createStatement((Resource)u2, (URI)rdfType, (Value)v1, (Resource)c1, explicit), f.createStatement((Resource)u2, (URI)rdfType, (Value)v1, (Resource)c2, explicit), f.createStatement((Resource)u2, (URI)rdfType, (Value)v2, (Resource)c1, explicit), f.createStatement((Resource)u2, (URI)rdfType, (Value)v2, (Resource)c2, explicit)};
            db.addStatements((ISPO[])stmts, stmts.length);
            db.commit();
            if (log.isInfoEnabled()) {
                log.info((Object)db.dumpStore());
            }
            BigdataStatement[] expectedDistinct = new BigdataStatement[]{f.createStatement((Resource)u1, (URI)rdfType, (Value)v1), f.createStatement((Resource)u1, (URI)rdfType, (Value)v2), f.createStatement((Resource)u2, (URI)rdfType, (Value)v1), f.createStatement((Resource)u2, (URI)rdfType, (Value)v2)};
            SPOPredicate pred = new SPOPredicate(new BOp[]{Var.var((String)"s"), Var.var((String)"p"), Var.var((String)"o"), Var.var((String)"c")}, NV.asMap((NV[])new NV[]{new NV(IPredicate.Annotations.TIMESTAMP, (Object)0L)}));
            IAccessPath ap = db.getSPORelation().getAccessPath((IKeyOrder)SPOKeyOrder.SPOC, (IPredicate)pred);
            TestContextAdvancer.assertEquals((Object)SPOKeyOrder.SPOC, (Object)ap.getKeyOrder());
            TestContextAdvancer.assertEquals((long)stmts.length, (long)ap.rangeCount(true));
            pred = (Predicate)pred.setProperty(Predicate.Annotations.FLAGS, (Object)35);
            pred = pred.addIndexLocalFilter((IFilter)new ContextAdvancer());
            pred = pred.addAccessPathFilter((IFilter)StripContextFilter.newInstance());
            ap = db.getSPORelation().getAccessPath((IKeyOrder)SPOKeyOrder.SPOC, (IPredicate)pred);
            TestContextAdvancer.assertEquals((Object)SPOKeyOrder.SPOC, (Object)ap.getKeyOrder());
            TestContextAdvancer.assertEquals((long)4L, (long)ap.rangeCount(true));
            AbstractTestCase.assertSameSPOsAnyOrder((AbstractTripleStore)db, (ISPO[])expectedDistinct, (IChunkedOrderedIterator<ISPO>)ap.iterator());
        }
        finally {
            store.destroy();
        }
    }
}

