/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rules;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.axioms.RdfsAxioms;
import com.bigdata.rdf.inf.ClosureStats;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.rules.AbstractRuleTestCase;
import com.bigdata.rdf.rules.BaseClosure;
import com.bigdata.rdf.rules.FastClosure;
import com.bigdata.rdf.rules.FullClosure;
import com.bigdata.rdf.rules.RuleContextEnum;
import com.bigdata.rdf.rules.RuleRdfs11;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.DataLoader;
import com.bigdata.rdf.store.TempTripleStore;
import com.bigdata.rdf.store.TripleStoreUtility;
import com.bigdata.rdf.vocab.Vocabulary;
import com.bigdata.relation.rule.IRule;
import com.bigdata.relation.rule.IStep;
import com.bigdata.relation.rule.Program;
import com.bigdata.relation.rule.eval.ActionEnum;
import com.bigdata.relation.rule.eval.IJoinNexusFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Properties;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.rio.RDFFormat;
import org.openrdf.sail.NotifyingSail;
import org.openrdf.sail.Sail;
import org.openrdf.sail.inferencer.fc.ForwardChainingRDFSInferencer;
import org.openrdf.sail.memory.MemoryStore;

public class TestDatabaseAtOnceClosure
extends AbstractRuleTestCase {
    public TestDatabaseAtOnceClosure() {
    }

    public TestDatabaseAtOnceClosure(String name) {
        super(name);
    }

    @Override
    public Properties getProperties() {
        Properties properties = super.getProperties();
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, RdfsAxioms.class.getName());
        properties.setProperty(DataLoader.Options.CLOSURE, DataLoader.ClosureEnum.None.toString());
        return properties;
    }

    public Properties getProperties(Class<? extends BaseClosure> closureClass, boolean nestedSubqueryIsIgnored) {
        Properties properties = this.getProperties();
        properties.setProperty(AbstractTripleStore.Options.CLOSURE_CLASS, closureClass.getName());
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_fixedPoint_Small_Full_PipelineJoins() throws Exception {
        Properties properties = this.getProperties(FullClosure.class, false);
        AbstractTripleStore store = this.getStore(properties);
        try {
            this.doFixedPointTest(new String[]{"small.rdf"}, store);
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_fixedPoint_Small_Fast_PipelineJoins() throws Exception {
        Properties properties = this.getProperties(FastClosure.class, false);
        AbstractTripleStore store = this.getStore(properties);
        try {
            this.doFixedPointTest(new String[]{"small.rdf"}, store);
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_fixedPoint_SampleData_Full_PipelineJoins() throws Exception {
        Properties properties = this.getProperties(FullClosure.class, false);
        AbstractTripleStore store = this.getStore(properties);
        try {
            this.doFixedPointTest(new String[]{"sample data.rdf"}, store);
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_fixedPoint_SampleData_Fast_PipelineJoins() throws Exception {
        Properties properties = this.getProperties(FastClosure.class, false);
        AbstractTripleStore store = this.getStore(properties);
        try {
            this.doFixedPointTest(new String[]{"sample data.rdf"}, store);
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_fixedPoint_TestOwlSameAs_Full_PipelineJoins() throws Exception {
        Properties properties = this.getProperties(FullClosure.class, false);
        AbstractTripleStore store = this.getStore(properties);
        try {
            this.doFixedPointTest(new String[]{"small owlSameAs.rdf"}, store);
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_fixedPoint_TestOwlSameAs_Fast_Pipeline() throws Exception {
        Properties properties = this.getProperties(FastClosure.class, false);
        AbstractTripleStore store = this.getStore(properties);
        try {
            this.doFixedPointTest(new String[]{"small owlSameAs.rdf"}, store);
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_fixedPoint_LUBM_U1_As_Full_PipelineJoins() throws Exception {
        String[] dataFiles = this.readFiles(new File("src/test/resources/data/lehigh/U1"), new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".owl");
            }
        });
        LinkedList<String> tmp = new LinkedList<String>();
        tmp.add("src/test/resources/data/lehigh/univ-bench-modified-no-bnodes.owl");
        tmp.addAll(Arrays.asList(dataFiles));
        String[] resources = tmp.toArray(new String[tmp.size()]);
        Properties properties = this.getProperties(FullClosure.class, false);
        AbstractTripleStore store = this.getStore(properties);
        try {
            this.doFixedPointTest(resources, store);
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_fixedPoint_LUBM_U1_As_Fast_PipelineJoins() throws Exception {
        String[] dataFiles = this.readFiles(new File("src/test/resources/data/lehigh/U1"), new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".owl");
            }
        });
        LinkedList<String> tmp = new LinkedList<String>();
        tmp.add("src/test/resources/data/lehigh/univ-bench-modified-no-bnodes.owl");
        tmp.addAll(Arrays.asList(dataFiles));
        String[] resources = tmp.toArray(new String[tmp.size()]);
        Properties properties = this.getProperties(FastClosure.class, false);
        AbstractTripleStore store = this.getStore(properties);
        try {
            this.doFixedPointTest(resources, store);
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    private String[] readFiles(File dir, FilenameFilter filter) {
        TestDatabaseAtOnceClosure.assertTrue((String)("No such file or directory: " + dir), (boolean)dir.exists());
        TestDatabaseAtOnceClosure.assertTrue((String)("Not a directory: " + dir), (boolean)dir.isDirectory());
        File[] files = dir.listFiles(filter);
        TestDatabaseAtOnceClosure.assertNotNull((String)("Could not read directory: " + dir), (Object)files);
        String[] resources = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            resources[i] = files[i].toString();
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFixedPointTest(String[] resources, AbstractTripleStore closureStore) throws Exception {
        TempTripleStore groundTruth = null;
        try {
            Properties tmp = new Properties();
            tmp.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
            groundTruth = new TempTripleStore(tmp);
            int numSesame2Stmts = 0;
            StatementBuffer buf = new StatementBuffer((AbstractTripleStore)groundTruth, 10);
            SailRepository sesame2 = new SailRepository((Sail)new ForwardChainingRDFSInferencer((NotifyingSail)new MemoryStore()));
            sesame2.initialize();
            cxn.setAutoCommit(false);
            try (RepositoryConnection cxn = sesame2.getConnection();){
                for (String resource : resources) {
                    String baseURI;
                    InputStream is = null;
                    try {
                        is = new FileInputStream(new File(resource));
                        baseURI = new File(resource).toURI().toString();
                    }
                    catch (FileNotFoundException ex) {
                        is = ((Object)((Object)this)).getClass().getResourceAsStream(resource);
                        URL resourceUrl = ((Object)((Object)this)).getClass().getResource(resource);
                        if (resourceUrl == null) {
                            is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resource);
                            resourceUrl = ((Object)((Object)this)).getClass().getClassLoader().getResource(resource);
                        }
                        if (resourceUrl == null) {
                            log.warn((Object)("resource not found [" + resource + "]"));
                            throw new Exception("FAILURE: resource not found [" + resource + "]");
                        }
                        baseURI = new java.net.URI(URLEncoder.encode(resourceUrl.toString(), "UTF-8")).toString();
                    }
                    if (is == null) {
                        TestDatabaseAtOnceClosure.fail((String)("No such file or resource: " + resource));
                    }
                    cxn.add(is, baseURI, RDFFormat.RDFXML, new Resource[0]);
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)("Loaded: " + resource));
                }
                cxn.commit();
                RepositoryResult stmts = cxn.getStatements(null, null, null, true, new Resource[0]);
                while (stmts.hasNext()) {
                    Statement stmt = (Statement)stmts.next();
                    buf.add(stmt.getSubject(), stmt.getPredicate(), stmt.getObject());
                    ++numSesame2Stmts;
                }
                buf.flush();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\ngroundTruth:\n" + groundTruth.dumpStore()));
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("# Sesame2 stmts: " + numSesame2Stmts));
                }
            }
            for (String resource : resources) {
                String baseURI;
                InputStream is = null;
                try {
                    is = new FileInputStream(new File(resource));
                    baseURI = new File(resource).toURI().toString();
                }
                catch (FileNotFoundException ex) {
                    is = ((Object)((Object)this)).getClass().getResourceAsStream(resource);
                    URL resourceUrl = ((Object)((Object)this)).getClass().getResource(resource);
                    if (resourceUrl == null) {
                        is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resource);
                        resourceUrl = ((Object)((Object)this)).getClass().getClassLoader().getResource(resource);
                    }
                    if (resourceUrl == null) {
                        log.warn((Object)("resource not found [" + resource + "]"));
                        throw new Exception("FAILURE: resource not found [" + resource + "]");
                    }
                    String encodedUrlStr = resourceUrl.toString().replaceAll(" ", "%20");
                    java.net.URI resourceUri = new java.net.URI(encodedUrlStr);
                    baseURI = resourceUri.toString();
                }
                if (is == null) {
                    TestDatabaseAtOnceClosure.fail((String)("No such file or resource: " + resource));
                }
                try {
                    closureStore.getDataLoader().loadData(is, baseURI, RDFFormat.RDFXML);
                }
                finally {
                    is.close();
                }
            }
            ClosureStats closureStats = closureStore.getInferenceEngine().computeClosure(null);
            if (log.isInfoEnabled()) {
                log.info((Object)closureStats.toString());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("\nclosure:\n" + closureStore.dumpStore()));
            }
            TempTripleStore tmp2 = TripleStoreUtility.bulkExport((AbstractTripleStore)closureStore);
            try {
                TestDatabaseAtOnceClosure.assertTrue((boolean)TripleStoreUtility.modelsEqual((AbstractTripleStore)groundTruth, (AbstractTripleStore)tmp2));
            }
            finally {
                tmp2.__tearDownUnitTest();
            }
        }
        finally {
            if (groundTruth != null) {
                groundTruth.__tearDownUnitTest();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_simpleFixPoint() throws Exception {
        Properties properties = this.getProperties();
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            BigdataValueFactory f = store.getValueFactory();
            BigdataURI A = f.createURI("http://www.bigdata.com/a");
            BigdataURI B = f.createURI("http://www.bigdata.com/b");
            BigdataURI C2 = f.createURI("http://www.bigdata.com/c");
            BigdataURI D = f.createURI("http://www.bigdata.com/d");
            BigdataURI SCO = f.asValue(RDFS.SUBCLASSOF);
            Vocabulary vocab = store.getVocabulary();
            StatementBuffer buf = new StatementBuffer(store, 10);
            buf.add((Resource)A, (URI)SCO, (Value)B);
            buf.add((Resource)B, (URI)SCO, (Value)C2);
            buf.add((Resource)C2, (URI)SCO, (Value)D);
            buf.flush();
            if (log.isInfoEnabled()) {
                log.info((Object)("\n" + store.dumpStore()));
            }
            TestDatabaseAtOnceClosure.assertEquals((long)3L, (long)store.getStatementCount());
            Program program = new Program("rdfs11", false);
            program.addClosureOf((IRule)new RuleRdfs11(store.getSPORelation().getNamespace(), vocab));
            IJoinNexusFactory joinNexusFactory = store.newJoinNexusFactory(RuleContextEnum.DatabaseAtOnceClosure, ActionEnum.Insert, 7, null);
            long mutationCount = joinNexusFactory.newInstance(store.getIndexManager()).runMutation((IStep)program);
            if (3L != mutationCount) {
                log.error((Object)("mutation count: expected=3, actual=" + mutationCount));
            }
            TestDatabaseAtOnceClosure.assertEquals((String)"statementCount", (long)6L, (long)store.getStatementCount());
            TestDatabaseAtOnceClosure.assertNotNull((Object)store.getStatement((Resource)A, (URI)SCO, (Value)C2));
            TestDatabaseAtOnceClosure.assertNotNull((Object)store.getStatement((Resource)B, (URI)SCO, (Value)D));
            TestDatabaseAtOnceClosure.assertNotNull((Object)store.getStatement((Resource)A, (URI)SCO, (Value)D));
        }
        finally {
            store.__tearDownUnitTest();
        }
    }
}

