/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rules;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.rules.AbstractRuleTestCase;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.striterator.IKeyOrder;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;

public class TestDistinctTermScan
extends AbstractRuleTestCase {
    public TestDistinctTermScan() {
    }

    public TestDistinctTermScan(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_getDistinctTermIdentifiers() {
        Properties properties = super.getProperties();
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            URIImpl A = new URIImpl("http://www.foo.org/A");
            URIImpl B = new URIImpl("http://www.foo.org/B");
            URIImpl C2 = new URIImpl("http://www.foo.org/C");
            URIImpl D = new URIImpl("http://www.foo.org/D");
            URIImpl E = new URIImpl("http://www.foo.org/E");
            StatementBuffer buffer = new StatementBuffer(store, 100);
            buffer.add((Resource)A, (URI)B, (Value)C2);
            buffer.add((Resource)C2, (URI)B, (Value)D);
            buffer.add((Resource)A, (URI)E, (Value)C2);
            buffer.flush();
            TestDistinctTermScan.assertTrue((boolean)store.hasStatement((Resource)A, (URI)B, (Value)C2));
            TestDistinctTermScan.assertTrue((boolean)store.hasStatement((Resource)C2, (URI)B, (Value)D));
            TestDistinctTermScan.assertTrue((boolean)store.hasStatement((Resource)A, (URI)E, (Value)C2));
            Object[] expected = new IV[]{store.getIV((Value)A), store.getIV((Value)C2)};
            Arrays.sort(expected);
            TestDistinctTermScan.assertSameIterator((Object[])expected, (Iterator)store.getSPORelation().distinctTermScan((IKeyOrder)SPOKeyOrder.SPO));
            expected = new IV[]{store.getIV((Value)B), store.getIV((Value)E)};
            Arrays.sort(expected);
            TestDistinctTermScan.assertSameIterator((Object[])expected, (Iterator)store.getSPORelation().distinctTermScan((IKeyOrder)SPOKeyOrder.POS));
            expected = new IV[]{store.getIV((Value)C2), store.getIV((Value)D)};
            Arrays.sort(expected);
            TestDistinctTermScan.assertSameIterator((Object[])expected, (Iterator)store.getSPORelation().distinctTermScan((IKeyOrder)SPOKeyOrder.OSP));
        }
        finally {
            store.__tearDownUnitTest();
        }
    }
}

