/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rules;

import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.Var;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.journal.TemporaryRawStore;
import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.inf.FullyBufferedJustificationIterator;
import com.bigdata.rdf.inf.Justification;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.rules.AbstractRuleTestCase;
import com.bigdata.rdf.rules.InferenceEngine;
import com.bigdata.rdf.rules.RuleContextEnum;
import com.bigdata.rdf.rules.RuleRdf01;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.TempTripleStore;
import com.bigdata.rdf.vocab.Vocabulary;
import com.bigdata.relation.IMutableRelation;
import com.bigdata.relation.accesspath.IBuffer;
import com.bigdata.relation.rule.IRule;
import com.bigdata.relation.rule.eval.ActionEnum;
import com.bigdata.relation.rule.eval.IJoinNexus;
import com.bigdata.relation.rule.eval.ISolution;
import com.bigdata.relation.rule.eval.Solution;
import java.util.Arrays;
import java.util.Properties;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;

public class TestJustifications
extends AbstractRuleTestCase {
    public TestJustifications() {
    }

    public TestJustifications(String name) {
        super(name);
    }

    protected void assertEquals(Justification expected, Justification actual) {
        if (!expected.equals(actual)) {
            TestJustifications.fail((String)("Expecting " + expected + ", not " + actual));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_writeReadRetract() {
        Properties properties = super.getProperties();
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        AbstractTripleStore store = this.getStore(properties);
        try {
            if (!store.isJustify()) {
                log.warn((Object)"Test skipped - justifications not enabled");
            }
            IV U = store.addTerm((Value)new URIImpl("http://www.bigdata.com/U"));
            IV A = store.addTerm((Value)new URIImpl("http://www.bigdata.com/A"));
            IV Y = store.addTerm((Value)new URIImpl("http://www.bigdata.com/Y"));
            store.addStatements((ISPO[])new SPO[]{new SPO(U, A, Y, StatementEnum.Explicit)}, 1);
            TestJustifications.assertTrue((boolean)store.hasStatement(U, A, Y));
            TestJustifications.assertEquals((long)1L, (long)store.getStatementCount());
            InferenceEngine inf = store.getInferenceEngine();
            Vocabulary vocab = store.getVocabulary();
            RuleRdf01 rule = new RuleRdf01(store.getSPORelation().getNamespace(), vocab);
            IJoinNexus joinNexus = store.newJoinNexusFactory(RuleContextEnum.DatabaseAtOnceClosure, ActionEnum.Insert, 7, null).newInstance(store.getIndexManager());
            IBuffer insertBuffer = joinNexus.newInsertBuffer((IMutableRelation)store.getSPORelation());
            SPO expectedEntailment = new SPO(A, vocab.get((Value)RDF.TYPE), vocab.get((Value)RDF.PROPERTY), StatementEnum.Inferred);
            IBindingSet bindingSet = joinNexus.newBindingSet((IRule)rule);
            bindingSet.set((IVariable)Var.var((String)"a"), (IConstant)new Constant((Object)A));
            Solution solution = new Solution(joinNexus, (IRule)rule, bindingSet);
            Justification jst = new Justification((ISolution)solution);
            this.assertEquals(expectedEntailment, jst.getHead());
            Object[] expectedTail = new SPO[]{new SPO(this.NULL, A, this.NULL, StatementEnum.Inferred)};
            if (!Arrays.equals(expectedTail, jst.getTail())) {
                TestJustifications.fail((String)("Expected: " + Arrays.toString(expectedTail) + ", but actual: " + jst));
            }
            insertBuffer.add((Object)new ISolution[]{solution});
            TestJustifications.assertEquals((long)0L, (long)store.getSPORelation().getJustificationIndex().rangeCount());
            TestJustifications.assertEquals((long)1L, (long)insertBuffer.flush());
            TestJustifications.assertEquals((long)1L, (long)store.getSPORelation().getJustificationIndex().rangeCount());
            ITupleIterator itr = store.getSPORelation().getJustificationIndex().rangeIterator();
            while (itr.hasNext()) {
                ITuple tuple = itr.next();
                Justification tmp = (Justification)tuple.getObject();
                this.assertEquals(jst, tmp);
                TestJustifications.assertFalse((boolean)itr.hasNext());
            }
            itr = new FullyBufferedJustificationIterator(store, (ISPO)expectedEntailment);
            TestJustifications.assertTrue((boolean)itr.hasNext());
            Justification tmp = itr.next();
            this.assertEquals(jst, tmp);
            TempTripleStore focusStore = new TempTripleStore(store.getIndexManager().getTempStore(), store.getProperties(), store);
            try {
                TestJustifications.assertTrue((boolean)Justification.isGrounded((InferenceEngine)inf, (TempTripleStore)focusStore, (AbstractTripleStore)store, (ISPO)expectedEntailment, (boolean)false, (boolean)true, (Justification.VisitedSPOSet)new Justification.VisitedSPOSet((TemporaryRawStore)focusStore.getIndexManager())));
                focusStore.addStatements((ISPO[])new SPO[]{new SPO(U, A, Y, StatementEnum.Explicit)}, 1);
                TestJustifications.assertFalse((boolean)Justification.isGrounded((InferenceEngine)inf, (TempTripleStore)focusStore, (AbstractTripleStore)store, (ISPO)expectedEntailment, (boolean)false, (boolean)true, (Justification.VisitedSPOSet)new Justification.VisitedSPOSet((TemporaryRawStore)focusStore.getIndexManager())));
            }
            finally {
                focusStore.destroy();
            }
            TestJustifications.assertEquals((long)1L, (long)store.getAccessPath(expectedEntailment.s, expectedEntailment.p, expectedEntailment.o).removeAll());
            ITupleIterator itr2 = store.getSPORelation().getJustificationIndex().rangeIterator();
            TestJustifications.assertFalse((boolean)itr2.hasNext());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }
}

