/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rules;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.Var;
import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.AbstractTripleStoreTestCase;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.HashMap;
import java.util.Map;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;

public class TestMatch
extends AbstractTripleStoreTestCase {
    public TestMatch() {
    }

    public TestMatch(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_match() {
        URIImpl bryan = new URIImpl("http://www.bigdata.com/bryan");
        URIImpl mike = new URIImpl("http://www.bigdata.com/mike");
        URIImpl paul = new URIImpl("http://www.bigdata.com/paul");
        URIImpl person = new URIImpl("http://www.bigdata.com/person");
        URIImpl chiefScientist = new URIImpl("http://www.bigdata.com/chiefScientist");
        URIImpl chiefEngineer = new URIImpl("http://www.bigdata.com/chiefEngineer");
        AbstractTripleStore store = this.getStore();
        try {
            StatementBuffer sb = new StatementBuffer(store, 100);
            sb.add((Resource)bryan, RDFS.LABEL, (Value)new LiteralImpl("bryan"));
            sb.add((Resource)bryan, RDFS.LABEL, (Value)new LiteralImpl("bryan thompson"));
            sb.add((Resource)bryan, RDF.TYPE, (Value)chiefScientist);
            sb.add((Resource)mike, RDFS.LABEL, (Value)new LiteralImpl("mike"));
            sb.add((Resource)mike, RDFS.LABEL, (Value)new LiteralImpl("mike personick"));
            sb.add((Resource)mike, RDF.TYPE, (Value)chiefEngineer);
            sb.add((Resource)paul, RDFS.LABEL, (Value)new LiteralImpl("paul"));
            sb.add((Resource)chiefScientist, RDFS.SUBCLASSOF, (Value)person);
            sb.add((Resource)chiefEngineer, RDFS.SUBCLASSOF, (Value)person);
            sb.flush();
            HashMap expected = new HashMap();
            HashMap<String, Object> bindingSet = new HashMap<String, Object>();
            bindingSet.put("s", bryan);
            bindingSet.put("t", chiefScientist);
            bindingSet.put("p", RDFS.LABEL);
            bindingSet.put("lit", new LiteralImpl("bryan"));
            expected.put(new LiteralImpl("bryan"), bindingSet);
            bindingSet = new HashMap();
            bindingSet.put("s", bryan);
            bindingSet.put("t", chiefScientist);
            bindingSet.put("p", RDFS.LABEL);
            bindingSet.put("lit", new LiteralImpl("bryan thompson"));
            expected.put(new LiteralImpl("bryan thompson"), bindingSet);
            try (ICloseableIterator itr = store.match(new Literal[]{new LiteralImpl("bryan")}, new URI[]{RDFS.LABEL}, (URI)person);){
                while (itr.hasNext()) {
                    IBindingSet actualBindingSet = (IBindingSet)itr.next();
                    if (log.isInfoEnabled()) {
                        log.info((Object)actualBindingSet.toString());
                    }
                    if (expected.isEmpty()) {
                        TestMatch.fail((String)("Nothing else is expected: found=" + actualBindingSet));
                    }
                    Literal lit = (Literal)actualBindingSet.get((IVariable)Var.var((String)"lit")).get();
                    TestMatch.assertNotNull((String)("lit not bound: " + actualBindingSet), (Object)lit);
                    Map expectedBindingSet = (Map)expected.remove(lit);
                    if (expectedBindingSet == null) {
                        TestMatch.fail((String)("Not expecting: " + actualBindingSet));
                    }
                    TestMatch.assertEquals((String)"s", expectedBindingSet.get("s"), (Object)((Value)actualBindingSet.get((IVariable)Var.var((String)"s")).get()));
                    TestMatch.assertEquals((String)"t", expectedBindingSet.get("t"), (Object)((Value)actualBindingSet.get((IVariable)Var.var((String)"t")).get()));
                    TestMatch.assertEquals((String)"p", expectedBindingSet.get("p"), (Object)((Value)actualBindingSet.get((IVariable)Var.var((String)"p")).get()));
                }
                if (!expected.isEmpty()) {
                    TestMatch.fail((String)("Additional terms were expected: not found=" + expected));
                }
            }
            try (ICloseableIterator itr = store.match(new Literal[]{new LiteralImpl("paul")}, new URI[]{RDFS.LABEL}, (URI)person);){
                TestMatch.assertFalse((boolean)itr.hasNext());
            }
        }
        finally {
            store.__tearDownUnitTest();
        }
    }
}

