/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rules;

import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.rules.AbstractRuleTestCase;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.TripleStoreUtility;
import cutthecrap.utils.striterators.ICloseableIterator;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDFS;

public class TestModelsEqual
extends AbstractRuleTestCase {
    public TestModelsEqual() {
    }

    public TestModelsEqual(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_modelsEqual() throws Exception {
        AbstractTripleStore store2;
        AbstractTripleStore store1 = this.getStore();
        TestModelsEqual.assertTrue((store1 != (store2 = this.getStore()) ? 1 : 0) != 0);
        try {
            BigdataValueFactory f = store1.getValueFactory();
            BigdataURI A = f.createURI("http://www.bigdata.com/a");
            BigdataURI B = f.createURI("http://www.bigdata.com/b");
            BigdataURI C2 = f.createURI("http://www.bigdata.com/c");
            BigdataURI D = f.createURI("http://www.bigdata.com/d");
            BigdataURI SCO = f.asValue(RDFS.SUBCLASSOF);
            StatementBuffer buf = new StatementBuffer(store1, 10);
            buf.add((Resource)A, (URI)SCO, (Value)B);
            buf.add((Resource)B, (URI)SCO, (Value)C2);
            buf.add((Resource)C2, (URI)SCO, (Value)D);
            buf.flush();
            f = store1.getValueFactory();
            A = f.createURI("http://www.bigdata.com/a");
            B = f.createURI("http://www.bigdata.com/b");
            C2 = f.createURI("http://www.bigdata.com/c");
            D = f.createURI("http://www.bigdata.com/d");
            SCO = f.asValue(RDFS.SUBCLASSOF);
            buf = new StatementBuffer(store2, 10);
            buf.add((Resource)A, (URI)SCO, (Value)B);
            buf.add((Resource)B, (URI)SCO, (Value)C2);
            buf.add((Resource)C2, (URI)SCO, (Value)D);
            buf.flush();
            try (ICloseableIterator notFoundItr = TripleStoreUtility.notFoundInTarget((AbstractTripleStore)store1, (AbstractTripleStore)store2);){
                TestModelsEqual.assertFalse((boolean)notFoundItr.hasNext());
            }
            notFoundItr = TripleStoreUtility.notFoundInTarget((AbstractTripleStore)store2, (AbstractTripleStore)store1);
            try {
                TestModelsEqual.assertFalse((boolean)notFoundItr.hasNext());
            }
            finally {
                notFoundItr.close();
            }
            TestModelsEqual.assertTrue((boolean)TripleStoreUtility.modelsEqual((AbstractTripleStore)store1, (AbstractTripleStore)store2));
            f = store1.getValueFactory();
            A = f.createURI("http://www.bigdata.com/a");
            B = f.createURI("http://www.bigdata.com/b");
            BigdataURI SCO2 = f.asValue(RDFS.SUBCLASSOF);
            TestModelsEqual.assertEquals((long)1L, (long)store2.removeStatements((Resource)A, (URI)SCO2, (Value)B));
            TestModelsEqual.assertFalse((boolean)store2.hasStatement((Resource)A, (URI)SCO2, (Value)B));
            log.info((Object)"Removed one statement from store2.");
            notFoundItr = TripleStoreUtility.notFoundInTarget((AbstractTripleStore)store1, (AbstractTripleStore)store2);
            int nnotFound = 0;
            try {
                while (notFoundItr.hasNext()) {
                    notFoundItr.next();
                    ++nnotFound;
                }
            }
            finally {
                notFoundItr.close();
            }
            TestModelsEqual.assertEquals((String)"#notFound", (int)1, (int)nnotFound);
            notFoundItr = TripleStoreUtility.notFoundInTarget((AbstractTripleStore)store2, (AbstractTripleStore)store1);
            try {
                TestModelsEqual.assertFalse((boolean)notFoundItr.hasNext());
            }
            finally {
                notFoundItr.close();
            }
            TestModelsEqual.assertFalse((boolean)TripleStoreUtility.modelsEqual((AbstractTripleStore)store1, (AbstractTripleStore)store2));
        }
        finally {
            store1.__tearDownUnitTest();
            store2.__tearDownUnitTest();
        }
    }
}

