/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rules;

import com.bigdata.bop.Constant;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.Var;
import com.bigdata.bop.joinGraph.IEvaluationPlan;
import com.bigdata.bop.joinGraph.IEvaluationPlanFactory;
import com.bigdata.bop.joinGraph.fast.DefaultEvaluationPlanFactory2;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.rules.AbstractInferenceEngineTestCase;
import com.bigdata.rdf.rules.RuleContextEnum;
import com.bigdata.rdf.spo.SPOPredicate;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.relation.rule.IRule;
import com.bigdata.relation.rule.IStep;
import com.bigdata.relation.rule.Rule;
import com.bigdata.relation.rule.eval.ActionEnum;
import com.bigdata.relation.rule.eval.IJoinNexus;
import com.bigdata.relation.rule.eval.IJoinNexusFactory;
import com.bigdata.relation.rule.eval.ISolution;
import com.bigdata.striterator.IChunkedOrderedIterator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;

public class TestOptionals
extends AbstractInferenceEngineTestCase {
    public TestOptionals() {
    }

    public TestOptionals(String name) {
        super(name);
    }

    public void test_optionals_pipeline() {
        Properties p = new Properties(this.getProperties());
        this.doOptionalsTest(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doOptionalsTest(Properties p) {
        AbstractTripleStore db = this.getStore(p);
        try {
            ISolution solution;
            IChunkedOrderedIterator<ISolution> solutions;
            int numSolutions;
            HashMap<Object, IV> termIds = new HashMap<Object, IV>();
            URIImpl A = new URIImpl("http://www.bigdata.com/A");
            URIImpl B = new URIImpl("http://www.bigdata.com/B");
            URIImpl W = new URIImpl("http://www.bigdata.com/W");
            URIImpl X = new URIImpl("http://www.bigdata.com/X");
            URIImpl Y = new URIImpl("http://www.bigdata.com/Y");
            URIImpl Z = new URIImpl("http://www.bigdata.com/Z");
            LiteralImpl foo = new LiteralImpl("foo");
            LiteralImpl bar = new LiteralImpl("bar");
            StatementBuffer buffer = new StatementBuffer(db, 100);
            buffer.add((Resource)A, RDF.TYPE, (Value)X);
            buffer.add((Resource)A, RDFS.LABEL, (Value)foo);
            buffer.add((Resource)A, RDFS.COMMENT, (Value)bar);
            buffer.add((Resource)B, RDF.TYPE, (Value)X);
            buffer.add((Resource)B, RDFS.COMMENT, (Value)bar);
            buffer.flush();
            IV a = db.getIV((Value)A);
            termIds.put(A, a);
            IV b = db.getIV((Value)B);
            termIds.put(B, b);
            IV x = db.getIV((Value)X);
            termIds.put(X, x);
            termIds.put(foo, db.getIV((Value)foo));
            termIds.put(bar, db.getIV((Value)bar));
            IV TYPE = db.getIV((Value)RDF.TYPE);
            termIds.put(RDF.TYPE, TYPE);
            IV LABEL = db.getIV((Value)RDFS.LABEL);
            termIds.put(RDFS.LABEL, LABEL);
            IV COMMENT = db.getIV((Value)RDFS.COMMENT);
            termIds.put(RDFS.COMMENT, COMMENT);
            IV RESOURCE = db.getIV((Value)RDFS.RESOURCE);
            termIds.put(RDFS.RESOURCE, RESOURCE);
            if (log.isInfoEnabled()) {
                log.info((Object)("\n" + db.dumpStore(true, true, false)));
            }
            for (Map.Entry e : termIds.entrySet()) {
                System.err.println(e.getKey() + " = " + e.getValue());
            }
            String SPO2 = db.getSPORelation().getNamespace();
            Var s = Var.var((String)"s");
            Constant type = new Constant((Object)TYPE);
            Constant t = new Constant((Object)x);
            Constant label = new Constant((Object)LABEL);
            Constant comment = new Constant((Object)COMMENT);
            Var l = Var.var((String)"l");
            Var c = Var.var((String)"c");
            Rule rule = new Rule("test_optional", null, new IPredicate[]{new SPOPredicate(SPO2, (IVariableOrConstant)s, (IVariableOrConstant)type, (IVariableOrConstant)t), new SPOPredicate(SPO2, (IVariableOrConstant)s, (IVariableOrConstant)comment, (IVariableOrConstant)c), new SPOPredicate(SPO2, (IVariableOrConstant)s, (IVariableOrConstant)label, (IVariableOrConstant)l, true)}, null);
            try {
                numSolutions = 0;
                solutions = this.runQuery(db, (IRule)rule);
                while (solutions.hasNext()) {
                    solution = (ISolution)solutions.next();
                    System.err.println(solution);
                    ++numSolutions;
                }
                TestOptionals.assertEquals((String)"wrong # of solutions", (int)2, (int)numSolutions);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            SPO2 = db.getSPORelation().getNamespace();
            s = Var.var((String)"s");
            type = new Constant((Object)TYPE);
            t = new Constant((Object)x);
            label = new Constant((Object)LABEL);
            comment = new Constant((Object)COMMENT);
            l = Var.var((String)"l");
            c = Var.var((String)"c");
            rule = new Rule("test_optional", null, new IPredicate[]{new SPOPredicate(SPO2, (IVariableOrConstant)s, (IVariableOrConstant)type, (IVariableOrConstant)t), new SPOPredicate(SPO2, (IVariableOrConstant)s, (IVariableOrConstant)label, (IVariableOrConstant)l, true), new SPOPredicate(SPO2, (IVariableOrConstant)s, (IVariableOrConstant)comment, (IVariableOrConstant)c)}, null);
            try {
                numSolutions = 0;
                solutions = this.runQuery(db, (IRule)rule);
                while (solutions.hasNext()) {
                    solution = (ISolution)solutions.next();
                    System.err.println(solution);
                    ++numSolutions;
                }
                TestOptionals.assertEquals((String)"wrong # of solutions", (int)2, (int)numSolutions);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            SPO2 = db.getSPORelation().getNamespace();
            s = Var.var((String)"s");
            type = new Constant((Object)TYPE);
            t = new Constant((Object)x);
            label = new Constant((Object)LABEL);
            comment = new Constant((Object)COMMENT);
            l = Var.var((String)"l");
            c = Var.var((String)"c");
            rule = new Rule("test_optional", null, new IPredicate[]{new SPOPredicate(SPO2, (IVariableOrConstant)s, (IVariableOrConstant)type, (IVariableOrConstant)t), new SPOPredicate(SPO2, (IVariableOrConstant)s, (IVariableOrConstant)label, (IVariableOrConstant)l, true), new SPOPredicate(SPO2, (IVariableOrConstant)s, (IVariableOrConstant)comment, (IVariableOrConstant)c, true)}, null);
            try {
                int numSolutions2 = 0;
                solutions = this.runQuery(db, (IRule)rule);
                while (solutions.hasNext()) {
                    solution = (ISolution)solutions.next();
                    System.err.println(solution);
                    ++numSolutions2;
                }
                TestOptionals.assertEquals((String)"wrong # of solutions", (int)2, (int)numSolutions2);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        finally {
            db.__tearDownUnitTest();
        }
    }

    private IChunkedOrderedIterator<ISolution> runQuery(AbstractTripleStore db, IRule rule) throws Exception {
        DefaultEvaluationPlanFactory2 planFactory = DefaultEvaluationPlanFactory2.INSTANCE;
        IJoinNexusFactory joinNexusFactory = db.newJoinNexusFactory(RuleContextEnum.HighLevelQuery, ActionEnum.Query, 2, null, false, false, (IEvaluationPlanFactory)planFactory);
        IJoinNexus joinNexus = joinNexusFactory.newInstance(db.getIndexManager());
        IEvaluationPlan plan = planFactory.newPlan(joinNexus, rule);
        StringBuilder sb = new StringBuilder();
        int[] order = plan.getOrder();
        for (int i = 0; i < order.length; ++i) {
            sb.append(order[i]);
            if (i >= order.length - 1) continue;
            sb.append(",");
        }
        System.err.println("order: [" + sb.toString() + "]");
        IChunkedOrderedIterator solutions = joinNexus.runQuery((IStep)rule);
        return solutions;
    }
}

