/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rules;

import com.bigdata.rdf.inf.OwlSameAsPropertiesExpandingIterator;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.rules.AbstractInferenceEngineTestCase;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.spo.SPOAccessPath;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.striterator.IChunkedOrderedIterator;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;

public class TestOwlSameAsPropertiesExpandingIterator
extends AbstractInferenceEngineTestCase {
    public TestOwlSameAsPropertiesExpandingIterator() {
    }

    public TestOwlSameAsPropertiesExpandingIterator(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_backchain() {
        AbstractTripleStore db = this.getStore();
        try {
            URIImpl A = new URIImpl("http://www.bigdata.com/A");
            URIImpl B = new URIImpl("http://www.bigdata.com/B");
            URIImpl W = new URIImpl("http://www.bigdata.com/W");
            URIImpl X = new URIImpl("http://www.bigdata.com/X");
            URIImpl Y = new URIImpl("http://www.bigdata.com/Y");
            URIImpl Z = new URIImpl("http://www.bigdata.com/Z");
            StatementBuffer buffer = new StatementBuffer(db, 100);
            buffer.add((Resource)X, (URI)A, (Value)Z);
            buffer.add((Resource)Y, (URI)B, (Value)W);
            buffer.add((Resource)X, OWL.SAMEAS, (Value)Y);
            buffer.add((Resource)Z, OWL.SAMEAS, (Value)W);
            buffer.flush();
            db.getInferenceEngine().computeClosure(null);
            IV a = db.getIV((Value)A);
            IV b = db.getIV((Value)B);
            IV w = db.getIV((Value)W);
            IV x = db.getIV((Value)X);
            IV y = db.getIV((Value)Y);
            IV z = db.getIV((Value)Z);
            IV same = db.getIV((Value)OWL.SAMEAS);
            IV type = db.getIV((Value)RDF.TYPE);
            IV property = db.getIV((Value)RDF.PROPERTY);
            IV subpropof = db.getIV((Value)RDFS.SUBPROPERTYOF);
            if (log.isInfoEnabled()) {
                log.info((Object)("\n" + db.dumpStore(true, true, false)));
            }
            SPOAccessPath accessPath = (SPOAccessPath)db.getAccessPath(y, this.NULL, this.NULL);
            OwlSameAsPropertiesExpandingIterator itr = new OwlSameAsPropertiesExpandingIterator(TestOwlSameAsPropertiesExpandingIterator.getValue(accessPath, 0), TestOwlSameAsPropertiesExpandingIterator.getValue(accessPath, 1), TestOwlSameAsPropertiesExpandingIterator.getValue(accessPath, 2), db, same, accessPath.getKeyOrder());
            TestOwlSameAsPropertiesExpandingIterator.assertSameSPOsAnyOrder(db, (ISPO[])new SPO[]{new SPO(y, b, w, StatementEnum.Explicit), new SPO(y, b, z, StatementEnum.Inferred), new SPO(y, a, w, StatementEnum.Inferred), new SPO(y, a, z, StatementEnum.Inferred), new SPO(y, same, x, StatementEnum.Inferred)}, (IChunkedOrderedIterator<ISPO>)itr, true);
            accessPath = (SPOAccessPath)db.getAccessPath(y, b, this.NULL);
            itr = new OwlSameAsPropertiesExpandingIterator(TestOwlSameAsPropertiesExpandingIterator.getValue(accessPath, 0), TestOwlSameAsPropertiesExpandingIterator.getValue(accessPath, 1), TestOwlSameAsPropertiesExpandingIterator.getValue(accessPath, 2), db, same, accessPath.getKeyOrder());
            TestOwlSameAsPropertiesExpandingIterator.assertSameSPOsAnyOrder(db, (ISPO[])new SPO[]{new SPO(y, b, w, StatementEnum.Explicit), new SPO(y, b, z, StatementEnum.Inferred)}, (IChunkedOrderedIterator<ISPO>)itr, true);
            accessPath = (SPOAccessPath)db.getAccessPath(this.NULL, this.NULL, w);
            itr = new OwlSameAsPropertiesExpandingIterator(TestOwlSameAsPropertiesExpandingIterator.getValue(accessPath, 0), TestOwlSameAsPropertiesExpandingIterator.getValue(accessPath, 1), TestOwlSameAsPropertiesExpandingIterator.getValue(accessPath, 2), db, same, accessPath.getKeyOrder());
            TestOwlSameAsPropertiesExpandingIterator.assertSameSPOsAnyOrder(db, (ISPO[])new SPO[]{new SPO(y, b, w, StatementEnum.Explicit), new SPO(y, a, w, StatementEnum.Inferred), new SPO(x, b, w, StatementEnum.Inferred), new SPO(x, a, w, StatementEnum.Inferred), new SPO(z, same, w, StatementEnum.Explicit)}, (IChunkedOrderedIterator<ISPO>)itr, true);
            accessPath = (SPOAccessPath)db.getAccessPath(this.NULL, a, w);
            itr = new OwlSameAsPropertiesExpandingIterator(TestOwlSameAsPropertiesExpandingIterator.getValue(accessPath, 0), TestOwlSameAsPropertiesExpandingIterator.getValue(accessPath, 1), TestOwlSameAsPropertiesExpandingIterator.getValue(accessPath, 2), db, same, accessPath.getKeyOrder());
            TestOwlSameAsPropertiesExpandingIterator.assertSameSPOsAnyOrder(db, (ISPO[])new SPO[]{new SPO(y, a, w, StatementEnum.Inferred), new SPO(x, a, w, StatementEnum.Inferred)}, (IChunkedOrderedIterator<ISPO>)itr, true);
            accessPath = (SPOAccessPath)db.getAccessPath(x, this.NULL, z);
            itr = new OwlSameAsPropertiesExpandingIterator(TestOwlSameAsPropertiesExpandingIterator.getValue(accessPath, 0), TestOwlSameAsPropertiesExpandingIterator.getValue(accessPath, 1), TestOwlSameAsPropertiesExpandingIterator.getValue(accessPath, 2), db, same, accessPath.getKeyOrder());
            TestOwlSameAsPropertiesExpandingIterator.assertSameSPOsAnyOrder(db, (ISPO[])new SPO[]{new SPO(x, a, z, StatementEnum.Explicit), new SPO(x, b, z, StatementEnum.Inferred)}, (IChunkedOrderedIterator<ISPO>)itr, true);
            accessPath = (SPOAccessPath)db.getAccessPath(x, b, z);
            itr = new OwlSameAsPropertiesExpandingIterator(TestOwlSameAsPropertiesExpandingIterator.getValue(accessPath, 0), TestOwlSameAsPropertiesExpandingIterator.getValue(accessPath, 1), TestOwlSameAsPropertiesExpandingIterator.getValue(accessPath, 2), db, same, accessPath.getKeyOrder());
            TestOwlSameAsPropertiesExpandingIterator.assertSameSPOsAnyOrder(db, (ISPO[])new SPO[]{new SPO(x, b, z, StatementEnum.Inferred)}, (IChunkedOrderedIterator<ISPO>)itr, true);
            accessPath = (SPOAccessPath)db.getAccessPath(this.NULL, a, this.NULL);
            itr = new OwlSameAsPropertiesExpandingIterator(TestOwlSameAsPropertiesExpandingIterator.getValue(accessPath, 0), TestOwlSameAsPropertiesExpandingIterator.getValue(accessPath, 1), TestOwlSameAsPropertiesExpandingIterator.getValue(accessPath, 2), db, same, accessPath.getKeyOrder());
            TestOwlSameAsPropertiesExpandingIterator.assertSameSPOsAnyOrder(db, (ISPO[])new SPO[]{new SPO(x, a, z, StatementEnum.Explicit), new SPO(x, a, w, StatementEnum.Inferred), new SPO(y, a, z, StatementEnum.Inferred), new SPO(y, a, w, StatementEnum.Inferred)}, (IChunkedOrderedIterator<ISPO>)itr, true);
            accessPath = (SPOAccessPath)db.getAccessPath(this.NULL, this.NULL, this.NULL);
            itr = new OwlSameAsPropertiesExpandingIterator(TestOwlSameAsPropertiesExpandingIterator.getValue(accessPath, 0), TestOwlSameAsPropertiesExpandingIterator.getValue(accessPath, 1), TestOwlSameAsPropertiesExpandingIterator.getValue(accessPath, 2), db, same, accessPath.getKeyOrder());
            TestOwlSameAsPropertiesExpandingIterator.assertSameSPOsAnyOrder(db, (ISPO[])new SPO[]{new SPO(x, a, z, StatementEnum.Explicit), new SPO(y, b, w, StatementEnum.Explicit), new SPO(x, same, y, StatementEnum.Explicit), new SPO(z, same, w, StatementEnum.Explicit), new SPO(x, a, w, StatementEnum.Inferred), new SPO(x, b, z, StatementEnum.Inferred), new SPO(x, b, w, StatementEnum.Inferred), new SPO(y, a, z, StatementEnum.Inferred), new SPO(y, a, w, StatementEnum.Inferred), new SPO(y, b, z, StatementEnum.Inferred), new SPO(y, same, x, StatementEnum.Inferred), new SPO(w, same, z, StatementEnum.Inferred), new SPO(a, type, property, StatementEnum.Inferred), new SPO(b, type, property, StatementEnum.Inferred), new SPO(a, subpropof, a, StatementEnum.Inferred), new SPO(b, subpropof, b, StatementEnum.Inferred)}, (IChunkedOrderedIterator<ISPO>)itr, true);
        }
        finally {
            db.__tearDownUnitTest();
        }
    }
}

