/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rules;

import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IConstraint;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.Var;
import com.bigdata.bop.constraint.BooleanValueExpression;
import com.bigdata.bop.constraint.Constraint;
import com.bigdata.bop.constraint.NEConstant;
import com.bigdata.bop.joinGraph.IEvaluationPlan;
import com.bigdata.bop.joinGraph.IEvaluationPlanFactory;
import com.bigdata.bop.joinGraph.fast.DefaultEvaluationPlanFactory2;
import com.bigdata.btree.IIndex;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.rules.AbstractInferenceEngineTestCase;
import com.bigdata.rdf.rules.RuleContextEnum;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.spo.SPOPredicate;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.IRawTripleStore;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.relation.rule.IAccessPathExpander;
import com.bigdata.relation.rule.IRule;
import com.bigdata.relation.rule.IStep;
import com.bigdata.relation.rule.Rule;
import com.bigdata.relation.rule.eval.ActionEnum;
import com.bigdata.relation.rule.eval.IJoinNexus;
import com.bigdata.relation.rule.eval.IJoinNexusFactory;
import com.bigdata.relation.rule.eval.ISolution;
import com.bigdata.striterator.ChunkedArrayIterator;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.striterator.IKeyOrder;
import java.util.HashMap;
import java.util.Map;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.OWL;

public class TestRuleExpansion
extends AbstractInferenceEngineTestCase {
    public TestRuleExpansion() {
    }

    public TestRuleExpansion(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_optionals() {
        final AbstractTripleStore db = this.getStore();
        try {
            final HashMap<Object, IV> termIds = new HashMap<Object, IV>();
            URIImpl A = new URIImpl("http://www.bigdata.com/A");
            URIImpl B = new URIImpl("http://www.bigdata.com/B");
            URIImpl W = new URIImpl("http://www.bigdata.com/W");
            URIImpl X = new URIImpl("http://www.bigdata.com/X");
            URIImpl Y = new URIImpl("http://www.bigdata.com/Y");
            URIImpl Z = new URIImpl("http://www.bigdata.com/Z");
            StatementBuffer buffer = new StatementBuffer(db, 100);
            buffer.add((Resource)X, (URI)A, (Value)Z);
            buffer.add((Resource)Y, (URI)B, (Value)W);
            buffer.add((Resource)X, OWL.SAMEAS, (Value)Y);
            buffer.add((Resource)Z, OWL.SAMEAS, (Value)W);
            buffer.flush();
            db.getInferenceEngine().computeClosure(null);
            termIds.put(A, db.getIV((Value)A));
            termIds.put(B, db.getIV((Value)B));
            termIds.put(W, db.getIV((Value)W));
            termIds.put(X, db.getIV((Value)X));
            termIds.put(Y, db.getIV((Value)Y));
            termIds.put(Z, db.getIV((Value)Z));
            termIds.put(OWL.SAMEAS, db.getIV((Value)OWL.SAMEAS));
            if (log.isInfoEnabled()) {
                log.info((Object)("\n" + db.dumpStore(true, true, false)));
            }
            for (Map.Entry e : termIds.entrySet()) {
                System.err.println(e.getKey() + " = " + e.getValue());
            }
            IAccessPathExpander<ISPO> expander = new IAccessPathExpander<ISPO>(){

                public boolean backchain() {
                    return false;
                }

                public boolean runFirst() {
                    return false;
                }

                public IAccessPath<ISPO> getAccessPath(final IAccessPath<ISPO> accessPath) {
                    SPO spo;
                    IVariableOrConstant s = accessPath.getPredicate().get(0);
                    IVariableOrConstant p = accessPath.getPredicate().get(1);
                    IVariableOrConstant o = accessPath.getPredicate().get(2);
                    boolean isValid = true;
                    if (!p.isConstant() || !IVUtility.equals((IV)((IV)p.get()), (IV)((IV)termIds.get(OWL.SAMEAS)))) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)"p must be owl:sameAs");
                        }
                        isValid = false;
                    }
                    if (s.isVar() && o.isVar()) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)"s and o cannot both be variables");
                        }
                        isValid = false;
                    }
                    if (s.isConstant() && o.isConstant()) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)"s and o cannot both be constants");
                        }
                        isValid = false;
                    }
                    if (isValid) {
                        IV constant = s.isConstant() ? (IV)s.get() : (IV)o.get();
                        SPO sPO = spo = s.isConstant() ? new SPO((IV)s.get(), (IV)p.get(), constant) : new SPO(constant, (IV)p.get(), (IV)o.get());
                        if (log.isInfoEnabled()) {
                            log.info((Object)("appending SPO: " + spo.toString((IRawTripleStore)db)));
                        }
                    } else {
                        spo = null;
                    }
                    return new IAccessPath<ISPO>(){

                        public IIndex getIndex() {
                            return accessPath.getIndex();
                        }

                        public IKeyOrder<ISPO> getKeyOrder() {
                            return accessPath.getKeyOrder();
                        }

                        public IPredicate<ISPO> getPredicate() {
                            return accessPath.getPredicate();
                        }

                        public boolean isEmpty() {
                            return false;
                        }

                        public IChunkedOrderedIterator<ISPO> iterator() {
                            final IChunkedOrderedIterator delegate = accessPath.iterator();
                            if (spo == null) {
                                return delegate;
                            }
                            ChunkedArrayIterator appender = new ChunkedArrayIterator(1, (Object[])new ISPO[]{spo}, (IKeyOrder)SPOKeyOrder.SPO);
                            return new IChunkedOrderedIterator<ISPO>((IChunkedOrderedIterator)appender){
                                final /* synthetic */ IChunkedOrderedIterator val$appender;
                                {
                                    this.val$appender = iChunkedOrderedIterator2;
                                }

                                public ISPO next() {
                                    if (delegate.hasNext()) {
                                        return (ISPO)delegate.next();
                                    }
                                    return (ISPO)this.val$appender.next();
                                }

                                public ISPO[] nextChunk() {
                                    if (delegate.hasNext()) {
                                        return (ISPO[])delegate.nextChunk();
                                    }
                                    return (ISPO[])this.val$appender.nextChunk();
                                }

                                public void remove() {
                                    throw new UnsupportedOperationException();
                                }

                                public boolean hasNext() {
                                    return delegate.hasNext() || this.val$appender.hasNext();
                                }

                                public IKeyOrder<ISPO> getKeyOrder() {
                                    return delegate.getKeyOrder();
                                }

                                public ISPO[] nextChunk(IKeyOrder<ISPO> keyOrder) {
                                    if (delegate.hasNext()) {
                                        return (ISPO[])delegate.nextChunk(keyOrder);
                                    }
                                    return (ISPO[])this.val$appender.nextChunk(keyOrder);
                                }

                                public void close() {
                                    delegate.close();
                                    this.val$appender.close();
                                }
                            };
                        }

                        public IChunkedOrderedIterator<ISPO> iterator(long offset, long limit, int capacity) {
                            throw new UnsupportedOperationException();
                        }

                        public long rangeCount(boolean exact) {
                            return accessPath.rangeCount(exact) + 1L;
                        }

                        public long removeAll() {
                            return accessPath.removeAll();
                        }
                    };
                }
            };
            String SPO2 = db.getSPORelation().getNamespace();
            Constant s = new Constant(termIds.get(X));
            Var _p = Var.var((String)"p");
            Var _o = Var.var((String)"o");
            Var _sameS = Var.var((String)"sameS");
            Var _sameO = Var.var((String)"sameO");
            Constant sameAs = new Constant(termIds.get(OWL.SAMEAS));
            Rule rule = new Rule("sameas", null, new IPredicate[]{new SPOPredicate(SPO2, (IVariableOrConstant)_sameS, (IVariableOrConstant)sameAs, (IVariableOrConstant)s, (IAccessPathExpander)expander), new SPOPredicate(SPO2, (IVariableOrConstant)_sameS, (IVariableOrConstant)_p, (IVariableOrConstant)_o), new SPOPredicate(SPO2, (IVariableOrConstant)_o, (IVariableOrConstant)sameAs, (IVariableOrConstant)_sameO, true, (IAccessPathExpander)expander)}, new IConstraint[]{Constraint.wrap((BooleanValueExpression)new NEConstant((IVariable)_p, (IConstant)sameAs))});
            try {
                int numSolutions = 0;
                IChunkedOrderedIterator<ISolution> solutions = this.runQuery(db, (IRule)rule);
                while (solutions.hasNext()) {
                    ISolution solution = (ISolution)solutions.next();
                    IBindingSet bindings = solution.getBindingSet();
                    System.err.println(solution);
                    ++numSolutions;
                }
                TestRuleExpansion.assertTrue((String)"wrong # of solutions", (numSolutions == 4 ? 1 : 0) != 0);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        finally {
            db.__tearDownUnitTest();
        }
    }

    private IChunkedOrderedIterator<ISolution> runQuery(AbstractTripleStore db, IRule rule) throws Exception {
        DefaultEvaluationPlanFactory2 planFactory = DefaultEvaluationPlanFactory2.INSTANCE;
        IJoinNexusFactory joinNexusFactory = db.newJoinNexusFactory(RuleContextEnum.HighLevelQuery, ActionEnum.Query, 2, null, false, false, (IEvaluationPlanFactory)planFactory);
        IJoinNexus joinNexus = joinNexusFactory.newInstance(db.getIndexManager());
        IEvaluationPlan plan = planFactory.newPlan(joinNexus, rule);
        StringBuilder sb = new StringBuilder();
        int[] order = plan.getOrder();
        for (int i = 0; i < order.length; ++i) {
            sb.append(order[i]);
            if (i >= order.length - 1) continue;
            sb.append(",");
        }
        System.err.println("order: [" + sb.toString() + "]");
        IChunkedOrderedIterator solutions = joinNexus.runQuery((IStep)rule);
        return solutions;
    }
}

