/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rules;

import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.rules.AbstractRuleTestCase;
import com.bigdata.rdf.rules.RuleOwlEquivalentClass;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.vocab.Vocabulary;
import com.bigdata.relation.rule.IRule;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.OWL;

public class TestRuleOwlEquivalentClass
extends AbstractRuleTestCase {
    public TestRuleOwlEquivalentClass() {
    }

    public TestRuleOwlEquivalentClass(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_owlEquivalentClass() throws Exception {
        AbstractTripleStore store = this.getStore();
        try {
            URIImpl A = new URIImpl("http://www.foo.org/A");
            URIImpl B = new URIImpl("http://www.foo.org/B");
            StatementBuffer buffer = new StatementBuffer(store, 100);
            buffer.add((Resource)A, OWL.EQUIVALENTCLASS, (Value)B);
            buffer.flush();
            TestRuleOwlEquivalentClass.assertTrue((boolean)store.hasStatement((Resource)A, OWL.EQUIVALENTCLASS, (Value)B));
            long nbefore = store.getStatementCount();
            Vocabulary vocab = store.getVocabulary();
            RuleOwlEquivalentClass r = new RuleOwlEquivalentClass(store.getSPORelation().getNamespace(), vocab);
            this.applyRule(store, (IRule)r, -1L, 1L);
            TestRuleOwlEquivalentClass.assertTrue((boolean)store.hasStatement((Resource)A, OWL.EQUIVALENTCLASS, (Value)B));
            TestRuleOwlEquivalentClass.assertTrue((boolean)store.hasStatement((Resource)B, OWL.EQUIVALENTCLASS, (Value)A));
            TestRuleOwlEquivalentClass.assertEquals((long)(nbefore + 1L), (long)store.getStatementCount());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }
}

