/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rules;

import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.rules.AbstractRuleTestCase;
import com.bigdata.rdf.rules.RuleOwlEquivalentProperty;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.vocab.Vocabulary;
import com.bigdata.relation.rule.IRule;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.OWL;

public class TestRuleOwlEquivalentProperty
extends AbstractRuleTestCase {
    public TestRuleOwlEquivalentProperty() {
    }

    public TestRuleOwlEquivalentProperty(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_owlEquivalentProperty() throws Exception {
        AbstractTripleStore store = this.getStore();
        try {
            URIImpl A = new URIImpl("http://www.foo.org/A");
            URIImpl B = new URIImpl("http://www.foo.org/B");
            StatementBuffer buffer = new StatementBuffer(store, 100);
            buffer.add((Resource)A, OWL.EQUIVALENTPROPERTY, (Value)B);
            buffer.flush();
            TestRuleOwlEquivalentProperty.assertTrue((boolean)store.hasStatement((Resource)A, OWL.EQUIVALENTPROPERTY, (Value)B));
            long nbefore = store.getStatementCount();
            Vocabulary vocab = store.getVocabulary();
            RuleOwlEquivalentProperty r = new RuleOwlEquivalentProperty(store.getSPORelation().getNamespace(), vocab);
            this.applyRule(store, (IRule)r, -1L, 1L);
            TestRuleOwlEquivalentProperty.assertTrue((boolean)store.hasStatement((Resource)A, OWL.EQUIVALENTPROPERTY, (Value)B));
            TestRuleOwlEquivalentProperty.assertTrue((boolean)store.hasStatement((Resource)B, OWL.EQUIVALENTPROPERTY, (Value)A));
            TestRuleOwlEquivalentProperty.assertEquals((long)(nbefore + 1L), (long)store.getStatementCount());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }
}

