/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rules;

import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.rules.AbstractRuleTestCase;
import com.bigdata.rdf.rules.RuleOwlFunctionalProperty;
import com.bigdata.rdf.rules.RuleOwlInverseFunctionalProperty;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.vocab.Vocabulary;
import com.bigdata.relation.rule.IRule;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDF;

public class TestRuleOwlFunctionalProperty
extends AbstractRuleTestCase {
    public TestRuleOwlFunctionalProperty() {
    }

    public TestRuleOwlFunctionalProperty(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_RuleOwlFunctionalProperty() throws Exception {
        AbstractTripleStore store = this.getStore();
        try {
            URIImpl john = new URIImpl("http://www.foo.org/john");
            URIImpl mary = new URIImpl("http://www.foo.org/mary");
            URIImpl susie = new URIImpl("http://www.foo.org/susie");
            URIImpl wife = new URIImpl("http://www.foo.org/wife");
            StatementBuffer buffer = new StatementBuffer(store, 100);
            buffer.add((Resource)wife, RDF.TYPE, (Value)OWL.FUNCTIONALPROPERTY);
            buffer.add((Resource)john, (URI)wife, (Value)mary);
            buffer.flush();
            TestRuleOwlFunctionalProperty.assertTrue((boolean)store.hasStatement((Resource)wife, RDF.TYPE, (Value)OWL.FUNCTIONALPROPERTY));
            TestRuleOwlFunctionalProperty.assertTrue((boolean)store.hasStatement((Resource)john, (URI)wife, (Value)mary));
            long nbefore = store.getStatementCount();
            Vocabulary vocab = store.getVocabulary();
            RuleOwlFunctionalProperty r = new RuleOwlFunctionalProperty(store.getSPORelation().getNamespace(), vocab);
            this.applyRule(store, (IRule)r, -1L, 0L);
            TestRuleOwlFunctionalProperty.assertTrue((boolean)store.hasStatement((Resource)wife, RDF.TYPE, (Value)OWL.FUNCTIONALPROPERTY));
            TestRuleOwlFunctionalProperty.assertTrue((boolean)store.hasStatement((Resource)john, (URI)wife, (Value)mary));
            TestRuleOwlFunctionalProperty.assertEquals((long)nbefore, (long)store.getStatementCount());
            buffer.add((Resource)john, (URI)wife, (Value)susie);
            buffer.flush();
            this.applyRule(store, (IRule)r, -1L, 2L);
            TestRuleOwlFunctionalProperty.assertTrue((boolean)store.hasStatement((Resource)mary, OWL.SAMEAS, (Value)susie));
            TestRuleOwlFunctionalProperty.assertTrue((boolean)store.hasStatement((Resource)susie, OWL.SAMEAS, (Value)mary));
            TestRuleOwlFunctionalProperty.assertEquals((long)(nbefore + 3L), (long)store.getStatementCount());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_RuleOwlInverseFunctionalProperty() throws Exception {
        AbstractTripleStore store = this.getStore();
        try {
            URIImpl john = new URIImpl("http://www.foo.org/john");
            URIImpl paul = new URIImpl("http://www.foo.org/paul");
            URIImpl mary = new URIImpl("http://www.foo.org/mary");
            URIImpl wife = new URIImpl("http://www.foo.org/wife");
            StatementBuffer buffer = new StatementBuffer(store, 100);
            buffer.add((Resource)wife, RDF.TYPE, (Value)OWL.INVERSEFUNCTIONALPROPERTY);
            buffer.add((Resource)john, (URI)wife, (Value)mary);
            buffer.flush();
            TestRuleOwlFunctionalProperty.assertTrue((boolean)store.hasStatement((Resource)wife, RDF.TYPE, (Value)OWL.INVERSEFUNCTIONALPROPERTY));
            TestRuleOwlFunctionalProperty.assertTrue((boolean)store.hasStatement((Resource)john, (URI)wife, (Value)mary));
            long nbefore = store.getStatementCount();
            Vocabulary vocab = store.getVocabulary();
            RuleOwlInverseFunctionalProperty r = new RuleOwlInverseFunctionalProperty(store.getSPORelation().getNamespace(), vocab);
            this.applyRule(store, (IRule)r, -1L, 0L);
            TestRuleOwlFunctionalProperty.assertTrue((boolean)store.hasStatement((Resource)wife, RDF.TYPE, (Value)OWL.INVERSEFUNCTIONALPROPERTY));
            TestRuleOwlFunctionalProperty.assertTrue((boolean)store.hasStatement((Resource)john, (URI)wife, (Value)mary));
            TestRuleOwlFunctionalProperty.assertEquals((long)nbefore, (long)store.getStatementCount());
            buffer.add((Resource)paul, (URI)wife, (Value)mary);
            buffer.flush();
            this.applyRule(store, (IRule)r, -1L, 2L);
            TestRuleOwlFunctionalProperty.assertTrue((boolean)store.hasStatement((Resource)john, OWL.SAMEAS, (Value)paul));
            TestRuleOwlFunctionalProperty.assertTrue((boolean)store.hasStatement((Resource)paul, OWL.SAMEAS, (Value)john));
            TestRuleOwlFunctionalProperty.assertEquals((long)(nbefore + 3L), (long)store.getStatementCount());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }
}

