/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rules;

import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.rules.AbstractRuleTestCase;
import com.bigdata.rdf.rules.RuleOwlHasValue;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.vocab.Vocabulary;
import com.bigdata.relation.rule.IRule;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDF;

public class TestRuleOwlHasValue
extends AbstractRuleTestCase {
    public TestRuleOwlHasValue() {
    }

    public TestRuleOwlHasValue(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_OwlHasValue() throws Exception {
        AbstractTripleStore store = this.getStore();
        try {
            URIImpl A = new URIImpl("http://www.foo.org/A");
            URIImpl X = new URIImpl("http://www.foo.org/X");
            URIImpl P2 = new URIImpl("http://www.foo.org/P");
            URIImpl V = new URIImpl("http://www.foo.org/V");
            StatementBuffer buffer = new StatementBuffer(store, 100);
            buffer.add((Resource)A, RDF.TYPE, (Value)X);
            buffer.add((Resource)X, RDF.TYPE, (Value)OWL.RESTRICTION);
            buffer.add((Resource)X, OWL.ONPROPERTY, (Value)P2);
            buffer.add((Resource)X, OWL.HASVALUE, (Value)V);
            buffer.flush();
            TestRuleOwlHasValue.assertTrue((boolean)store.hasStatement((Resource)A, RDF.TYPE, (Value)X));
            TestRuleOwlHasValue.assertTrue((boolean)store.hasStatement((Resource)X, RDF.TYPE, (Value)OWL.RESTRICTION));
            TestRuleOwlHasValue.assertTrue((boolean)store.hasStatement((Resource)X, OWL.ONPROPERTY, (Value)P2));
            TestRuleOwlHasValue.assertTrue((boolean)store.hasStatement((Resource)X, OWL.HASVALUE, (Value)V));
            long nbefore = store.getStatementCount();
            Vocabulary vocab = store.getVocabulary();
            RuleOwlHasValue r = new RuleOwlHasValue(store.getSPORelation().getNamespace(), vocab);
            this.applyRule(store, (IRule)r, -1L, 1L);
            TestRuleOwlHasValue.assertTrue((boolean)store.hasStatement((Resource)A, RDF.TYPE, (Value)X));
            TestRuleOwlHasValue.assertTrue((boolean)store.hasStatement((Resource)X, RDF.TYPE, (Value)OWL.RESTRICTION));
            TestRuleOwlHasValue.assertTrue((boolean)store.hasStatement((Resource)X, OWL.ONPROPERTY, (Value)P2));
            TestRuleOwlHasValue.assertTrue((boolean)store.hasStatement((Resource)X, OWL.HASVALUE, (Value)V));
            TestRuleOwlHasValue.assertTrue((boolean)store.hasStatement((Resource)A, (URI)P2, (Value)V));
            TestRuleOwlHasValue.assertEquals((long)(nbefore + 1L), (long)store.getStatementCount());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }
}

