/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rules;

import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.rules.AbstractRuleTestCase;
import com.bigdata.rdf.rules.RuleOwlInverseOf1;
import com.bigdata.rdf.rules.RuleOwlInverseOf2;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.vocab.Vocabulary;
import com.bigdata.relation.rule.IRule;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.OWL;

public class TestRuleOwlInverseOf
extends AbstractRuleTestCase {
    public TestRuleOwlInverseOf() {
    }

    public TestRuleOwlInverseOf(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_owlInverseOf1() throws Exception {
        AbstractTripleStore store = this.getStore();
        try {
            URIImpl X = new URIImpl("http://www.foo.org/X");
            URIImpl Y = new URIImpl("http://www.foo.org/Y");
            StatementBuffer buffer = new StatementBuffer(store, 100);
            buffer.add((Resource)X, OWL.INVERSEOF, (Value)Y);
            buffer.flush();
            TestRuleOwlInverseOf.assertTrue((boolean)store.hasStatement((Resource)X, OWL.INVERSEOF, (Value)Y));
            long nbefore = store.getStatementCount();
            Vocabulary vocab = store.getVocabulary();
            RuleOwlInverseOf1 r = new RuleOwlInverseOf1(store.getSPORelation().getNamespace(), vocab);
            this.applyRule(store, (IRule)r, -1L, 1L);
            TestRuleOwlInverseOf.assertTrue((boolean)store.hasStatement((Resource)X, OWL.INVERSEOF, (Value)Y));
            TestRuleOwlInverseOf.assertTrue((boolean)store.hasStatement((Resource)Y, OWL.INVERSEOF, (Value)X));
            TestRuleOwlInverseOf.assertEquals((long)(nbefore + 1L), (long)store.getStatementCount());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_owlInverseOf2() throws Exception {
        AbstractTripleStore store = this.getStore();
        try {
            URIImpl A = new URIImpl("http://www.foo.org/A");
            URIImpl B = new URIImpl("http://www.foo.org/B");
            URIImpl Z = new URIImpl("http://www.foo.org/Z");
            URIImpl X = new URIImpl("http://www.foo.org/X");
            URIImpl Y = new URIImpl("http://www.foo.org/Y");
            StatementBuffer buffer = new StatementBuffer(store, 100);
            buffer.add((Resource)A, OWL.INVERSEOF, (Value)B);
            buffer.add((Resource)X, (URI)A, (Value)Z);
            buffer.flush();
            TestRuleOwlInverseOf.assertTrue((boolean)store.hasStatement((Resource)A, OWL.INVERSEOF, (Value)B));
            TestRuleOwlInverseOf.assertTrue((boolean)store.hasStatement((Resource)X, (URI)A, (Value)Z));
            long nbefore = store.getStatementCount();
            Vocabulary vocab = store.getVocabulary();
            RuleOwlInverseOf2 r = new RuleOwlInverseOf2(store.getSPORelation().getNamespace(), vocab);
            this.applyRule(store, (IRule)r, -1L, 1L);
            TestRuleOwlInverseOf.assertTrue((boolean)store.hasStatement((Resource)A, OWL.INVERSEOF, (Value)B));
            TestRuleOwlInverseOf.assertTrue((boolean)store.hasStatement((Resource)X, (URI)A, (Value)Z));
            TestRuleOwlInverseOf.assertTrue((boolean)store.hasStatement((Resource)Z, (URI)B, (Value)X));
            TestRuleOwlInverseOf.assertEquals((long)(nbefore + 1L), (long)store.getStatementCount());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }
}

