/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rules;

import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.rules.AbstractRuleTestCase;
import com.bigdata.rdf.rules.RuleOwlSameAs1;
import com.bigdata.rdf.rules.RuleOwlSameAs1b;
import com.bigdata.rdf.rules.RuleOwlSameAs2;
import com.bigdata.rdf.rules.RuleOwlSameAs3;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.vocab.Vocabulary;
import com.bigdata.relation.rule.IRule;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.OWL;

public class TestRuleOwlSameAs
extends AbstractRuleTestCase {
    public TestRuleOwlSameAs() {
    }

    public TestRuleOwlSameAs(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_owlSameAs1() throws Exception {
        AbstractTripleStore store = this.getStore();
        try {
            URIImpl X = new URIImpl("http://www.foo.org/X");
            URIImpl Y = new URIImpl("http://www.foo.org/Y");
            StatementBuffer buffer = new StatementBuffer(store, 100);
            buffer.add((Resource)X, OWL.SAMEAS, (Value)Y);
            buffer.flush();
            TestRuleOwlSameAs.assertTrue((boolean)store.hasStatement((Resource)X, OWL.SAMEAS, (Value)Y));
            long nbefore = store.getStatementCount();
            Vocabulary vocab = store.getVocabulary();
            RuleOwlSameAs1 r = new RuleOwlSameAs1(store.getSPORelation().getNamespace(), vocab);
            this.applyRule(store, (IRule)r, -1L, 1L);
            TestRuleOwlSameAs.assertTrue((boolean)store.hasStatement((Resource)X, OWL.SAMEAS, (Value)Y));
            TestRuleOwlSameAs.assertTrue((boolean)store.hasStatement((Resource)Y, OWL.SAMEAS, (Value)X));
            TestRuleOwlSameAs.assertEquals((long)(nbefore + 1L), (long)store.getStatementCount());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_owlSameAs1b() throws Exception {
        AbstractTripleStore store = this.getStore();
        try {
            URIImpl X = new URIImpl("http://www.foo.org/X");
            URIImpl Y = new URIImpl("http://www.foo.org/Y");
            URIImpl Z = new URIImpl("http://www.foo.org/Z");
            StatementBuffer buffer = new StatementBuffer(store, 100);
            buffer.add((Resource)X, OWL.SAMEAS, (Value)Y);
            buffer.add((Resource)Y, OWL.SAMEAS, (Value)Z);
            buffer.flush();
            TestRuleOwlSameAs.assertTrue((boolean)store.hasStatement((Resource)X, OWL.SAMEAS, (Value)Y));
            TestRuleOwlSameAs.assertTrue((boolean)store.hasStatement((Resource)Y, OWL.SAMEAS, (Value)Z));
            long nbefore = store.getStatementCount();
            Vocabulary vocab = store.getVocabulary();
            RuleOwlSameAs1b r = new RuleOwlSameAs1b(store.getSPORelation().getNamespace(), vocab);
            this.applyRule(store, (IRule)r, -1L, 1L);
            TestRuleOwlSameAs.assertTrue((boolean)store.hasStatement((Resource)X, OWL.SAMEAS, (Value)Y));
            TestRuleOwlSameAs.assertTrue((boolean)store.hasStatement((Resource)Y, OWL.SAMEAS, (Value)Z));
            TestRuleOwlSameAs.assertTrue((boolean)store.hasStatement((Resource)X, OWL.SAMEAS, (Value)Z));
            TestRuleOwlSameAs.assertEquals((long)(nbefore + 1L), (long)store.getStatementCount());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_owlSameAs2() throws Exception {
        AbstractTripleStore store = this.getStore();
        try {
            URIImpl A = new URIImpl("http://www.foo.org/A");
            URIImpl Z = new URIImpl("http://www.foo.org/Z");
            URIImpl X = new URIImpl("http://www.foo.org/X");
            URIImpl Y = new URIImpl("http://www.foo.org/Y");
            StatementBuffer buffer = new StatementBuffer(store, 100);
            buffer.add((Resource)X, OWL.SAMEAS, (Value)Y);
            buffer.add((Resource)X, (URI)A, (Value)Z);
            buffer.flush();
            TestRuleOwlSameAs.assertTrue((boolean)store.hasStatement((Resource)X, OWL.SAMEAS, (Value)Y));
            TestRuleOwlSameAs.assertTrue((boolean)store.hasStatement((Resource)X, (URI)A, (Value)Z));
            long nbefore = store.getStatementCount();
            Vocabulary vocab = store.getVocabulary();
            RuleOwlSameAs2 r = new RuleOwlSameAs2(store.getSPORelation().getNamespace(), vocab);
            this.applyRule(store, (IRule)r, -1L, 1L);
            TestRuleOwlSameAs.assertTrue((boolean)store.hasStatement((Resource)X, OWL.SAMEAS, (Value)Y));
            TestRuleOwlSameAs.assertTrue((boolean)store.hasStatement((Resource)X, (URI)A, (Value)Z));
            TestRuleOwlSameAs.assertTrue((boolean)store.hasStatement((Resource)Y, (URI)A, (Value)Z));
            TestRuleOwlSameAs.assertEquals((long)(nbefore + 1L), (long)store.getStatementCount());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_owlSameAs3() throws Exception {
        AbstractTripleStore store = this.getStore();
        try {
            URIImpl A = new URIImpl("http://www.foo.org/A");
            URIImpl Z = new URIImpl("http://www.foo.org/Z");
            URIImpl X = new URIImpl("http://www.foo.org/X");
            URIImpl Y = new URIImpl("http://www.foo.org/Y");
            StatementBuffer buffer = new StatementBuffer(store, 100);
            buffer.add((Resource)X, OWL.SAMEAS, (Value)Y);
            buffer.add((Resource)Z, (URI)A, (Value)X);
            buffer.flush();
            TestRuleOwlSameAs.assertTrue((boolean)store.hasStatement((Resource)X, OWL.SAMEAS, (Value)Y));
            TestRuleOwlSameAs.assertTrue((boolean)store.hasStatement((Resource)Z, (URI)A, (Value)X));
            long nbefore = store.getStatementCount();
            Vocabulary vocab = store.getVocabulary();
            RuleOwlSameAs3 r = new RuleOwlSameAs3(store.getSPORelation().getNamespace(), vocab);
            this.applyRule(store, (IRule)r, -1L, 1L);
            TestRuleOwlSameAs.assertTrue((boolean)store.hasStatement((Resource)X, OWL.SAMEAS, (Value)Y));
            TestRuleOwlSameAs.assertTrue((boolean)store.hasStatement((Resource)Z, (URI)A, (Value)X));
            TestRuleOwlSameAs.assertTrue((boolean)store.hasStatement((Resource)Z, (URI)A, (Value)Y));
            TestRuleOwlSameAs.assertEquals((long)(nbefore + 1L), (long)store.getStatementCount());
        }
        finally {
            store.__tearDownUnitTest();
        }
    }
}

